@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.CatalogTableArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableOpenTableFormatInputArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableOpenTableFormatInputArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionIndexArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionIndexArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionKeyArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTablePartitionKeyArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableStorageDescriptorArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableStorageDescriptorArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableTargetTableArgs
import com.pulumi.aws.glue.kotlin.inputs.CatalogTableTargetTableArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Catalog Table Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality.
 * ## Example Usage
 * ### Basic Table
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const awsGlueCatalogTable = new aws.glue.CatalogTable("aws_glue_catalog_table", {
 *     name: "MyCatalogTable",
 *     databaseName: "MyCatalogDatabase",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * aws_glue_catalog_table = aws.glue.CatalogTable("aws_glue_catalog_table",
 *     name="MyCatalogTable",
 *     database_name="MyCatalogDatabase")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awsGlueCatalogTable = new Aws.Glue.CatalogTable("aws_glue_catalog_table", new()
 *     {
 *         Name = "MyCatalogTable",
 *         DatabaseName = "MyCatalogDatabase",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCatalogTable(ctx, "aws_glue_catalog_table", &glue.CatalogTableArgs{
 * 			Name:         pulumi.String("MyCatalogTable"),
 * 			DatabaseName: pulumi.String("MyCatalogDatabase"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogTable = new CatalogTable("awsGlueCatalogTable", CatalogTableArgs.builder()
 *             .name("MyCatalogTable")
 *             .databaseName("MyCatalogDatabase")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awsGlueCatalogTable:
 *     type: aws:glue:CatalogTable
 *     name: aws_glue_catalog_table
 *     properties:
 *       name: MyCatalogTable
 *       databaseName: MyCatalogDatabase
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Parquet Table for Athena
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const awsGlueCatalogTable = new aws.glue.CatalogTable("aws_glue_catalog_table", {
 *     name: "MyCatalogTable",
 *     databaseName: "MyCatalogDatabase",
 *     tableType: "EXTERNAL_TABLE",
 *     parameters: {
 *         EXTERNAL: "TRUE",
 *         "parquet.compression": "SNAPPY",
 *     },
 *     storageDescriptor: {
 *         location: "s3://my-bucket/event-streams/my-stream",
 *         inputFormat: "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat",
 *         outputFormat: "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat",
 *         serDeInfo: {
 *             name: "my-stream",
 *             serializationLibrary: "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe",
 *             parameters: {
 *                 "serialization.format": "1",
 *             },
 *         },
 *         columns: [
 *             {
 *                 name: "my_string",
 *                 type: "string",
 *             },
 *             {
 *                 name: "my_double",
 *                 type: "double",
 *             },
 *             {
 *                 name: "my_date",
 *                 type: "date",
 *                 comment: "",
 *             },
 *             {
 *                 name: "my_bigint",
 *                 type: "bigint",
 *                 comment: "",
 *             },
 *             {
 *                 name: "my_struct",
 *                 type: "struct<my_nested_string:string>",
 *                 comment: "",
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * aws_glue_catalog_table = aws.glue.CatalogTable("aws_glue_catalog_table",
 *     name="MyCatalogTable",
 *     database_name="MyCatalogDatabase",
 *     table_type="EXTERNAL_TABLE",
 *     parameters={
 *         "EXTERNAL": "TRUE",
 *         "parquet.compression": "SNAPPY",
 *     },
 *     storage_descriptor={
 *         "location": "s3://my-bucket/event-streams/my-stream",
 *         "input_format": "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat",
 *         "output_format": "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat",
 *         "ser_de_info": {
 *             "name": "my-stream",
 *             "serialization_library": "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe",
 *             "parameters": {
 *                 "serialization_format": "1",
 *             },
 *         },
 *         "columns": [
 *             {
 *                 "name": "my_string",
 *                 "type": "string",
 *             },
 *             {
 *                 "name": "my_double",
 *                 "type": "double",
 *             },
 *             {
 *                 "name": "my_date",
 *                 "type": "date",
 *                 "comment": "",
 *             },
 *             {
 *                 "name": "my_bigint",
 *                 "type": "bigint",
 *                 "comment": "",
 *             },
 *             {
 *                 "name": "my_struct",
 *                 "type": "struct<my_nested_string:string>",
 *                 "comment": "",
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awsGlueCatalogTable = new Aws.Glue.CatalogTable("aws_glue_catalog_table", new()
 *     {
 *         Name = "MyCatalogTable",
 *         DatabaseName = "MyCatalogDatabase",
 *         TableType = "EXTERNAL_TABLE",
 *         Parameters =
 *         {
 *             { "EXTERNAL", "TRUE" },
 *             { "parquet.compression", "SNAPPY" },
 *         },
 *         StorageDescriptor = new Aws.Glue.Inputs.CatalogTableStorageDescriptorArgs
 *         {
 *             Location = "s3://my-bucket/event-streams/my-stream",
 *             InputFormat = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat",
 *             OutputFormat = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat",
 *             SerDeInfo = new Aws.Glue.Inputs.CatalogTableStorageDescriptorSerDeInfoArgs
 *             {
 *                 Name = "my-stream",
 *                 SerializationLibrary = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe",
 *                 Parameters =
 *                 {
 *                     { "serialization.format", "1" },
 *                 },
 *             },
 *             Columns = new[]
 *             {
 *                 new Aws.Glue.Inputs.CatalogTableStorageDescriptorColumnArgs
 *                 {
 *                     Name = "my_string",
 *                     Type = "string",
 *                 },
 *                 new Aws.Glue.Inputs.CatalogTableStorageDescriptorColumnArgs
 *                 {
 *                     Name = "my_double",
 *                     Type = "double",
 *                 },
 *                 new Aws.Glue.Inputs.CatalogTableStorageDescriptorColumnArgs
 *                 {
 *                     Name = "my_date",
 *                     Type = "date",
 *                     Comment = "",
 *                 },
 *                 new Aws.Glue.Inputs.CatalogTableStorageDescriptorColumnArgs
 *                 {
 *                     Name = "my_bigint",
 *                     Type = "bigint",
 *                     Comment = "",
 *                 },
 *                 new Aws.Glue.Inputs.CatalogTableStorageDescriptorColumnArgs
 *                 {
 *                     Name = "my_struct",
 *                     Type = "struct<my_nested_string:string>",
 *                     Comment = "",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCatalogTable(ctx, "aws_glue_catalog_table", &glue.CatalogTableArgs{
 * 			Name:         pulumi.String("MyCatalogTable"),
 * 			DatabaseName: pulumi.String("MyCatalogDatabase"),
 * 			TableType:    pulumi.String("EXTERNAL_TABLE"),
 * 			Parameters: pulumi.StringMap{
 * 				"EXTERNAL":            pulumi.String("TRUE"),
 * 				"parquet.compression": pulumi.String("SNAPPY"),
 * 			},
 * 			StorageDescriptor: &glue.CatalogTableStorageDescriptorArgs{
 * 				Location:     pulumi.String("s3://my-bucket/event-streams/my-stream"),
 * 				InputFormat:  pulumi.String("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat"),
 * 				OutputFormat: pulumi.String("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat"),
 * 				SerDeInfo: &glue.CatalogTableStorageDescriptorSerDeInfoArgs{
 * 					Name:                 pulumi.String("my-stream"),
 * 					SerializationLibrary: pulumi.String("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe"),
 * 					Parameters: pulumi.StringMap{
 * 						"serialization.format": pulumi.String("1"),
 * 					},
 * 				},
 * 				Columns: glue.CatalogTableStorageDescriptorColumnArray{
 * 					&glue.CatalogTableStorageDescriptorColumnArgs{
 * 						Name: pulumi.String("my_string"),
 * 						Type: pulumi.String("string"),
 * 					},
 * 					&glue.CatalogTableStorageDescriptorColumnArgs{
 * 						Name: pulumi.String("my_double"),
 * 						Type: pulumi.String("double"),
 * 					},
 * 					&glue.CatalogTableStorageDescriptorColumnArgs{
 * 						Name:    pulumi.String("my_date"),
 * 						Type:    pulumi.String("date"),
 * 						Comment: pulumi.String(""),
 * 					},
 * 					&glue.CatalogTableStorageDescriptorColumnArgs{
 * 						Name:    pulumi.String("my_bigint"),
 * 						Type:    pulumi.String("bigint"),
 * 						Comment: pulumi.String(""),
 * 					},
 * 					&glue.CatalogTableStorageDescriptorColumnArgs{
 * 						Name:    pulumi.String("my_struct"),
 * 						Type:    pulumi.String("struct<my_nested_string:string>"),
 * 						Comment: pulumi.String(""),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogTable;
 * import com.pulumi.aws.glue.CatalogTableArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs;
 * import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awsGlueCatalogTable = new CatalogTable("awsGlueCatalogTable", CatalogTableArgs.builder()
 *             .name("MyCatalogTable")
 *             .databaseName("MyCatalogDatabase")
 *             .tableType("EXTERNAL_TABLE")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("EXTERNAL", "TRUE"),
 *                 Map.entry("parquet.compression", "SNAPPY")
 *             ))
 *             .storageDescriptor(CatalogTableStorageDescriptorArgs.builder()
 *                 .location("s3://my-bucket/event-streams/my-stream")
 *                 .inputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat")
 *                 .outputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat")
 *                 .serDeInfo(CatalogTableStorageDescriptorSerDeInfoArgs.builder()
 *                     .name("my-stream")
 *                     .serializationLibrary("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe")
 *                     .parameters(Map.of("serialization.format", 1))
 *                     .build())
 *                 .columns(
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_string")
 *                         .type("string")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_double")
 *                         .type("double")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_date")
 *                         .type("date")
 *                         .comment("")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_bigint")
 *                         .type("bigint")
 *                         .comment("")
 *                         .build(),
 *                     CatalogTableStorageDescriptorColumnArgs.builder()
 *                         .name("my_struct")
 *                         .type("struct<my_nested_string:string>")
 *                         .comment("")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awsGlueCatalogTable:
 *     type: aws:glue:CatalogTable
 *     name: aws_glue_catalog_table
 *     properties:
 *       name: MyCatalogTable
 *       databaseName: MyCatalogDatabase
 *       tableType: EXTERNAL_TABLE
 *       parameters:
 *         EXTERNAL: TRUE
 *         parquet.compression: SNAPPY
 *       storageDescriptor:
 *         location: s3://my-bucket/event-streams/my-stream
 *         inputFormat: org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat
 *         outputFormat: org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat
 *         serDeInfo:
 *           name: my-stream
 *           serializationLibrary: org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe
 *           parameters:
 *             serialization.format: 1
 *         columns:
 *           - name: my_string
 *             type: string
 *           - name: my_double
 *             type: double
 *           - name: my_date
 *             type: date
 *             comment:
 *           - name: my_bigint
 *             type: bigint
 *             comment:
 *           - name: my_struct
 *             type: struct<my_nested_string:string>
 *             comment:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Tables using the catalog ID (usually AWS account ID), database name, and table name. For example:
 * ```sh
 * $ pulumi import aws:glue/catalogTable:CatalogTable MyTable 123456789012:MyDatabase:MyTable
 * ```
 * @property catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
 * @property databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
 * The follow arguments are optional:
 * @property description Description of the table.
 * @property name Name of the table. For Hive compatibility, this must be entirely lowercase.
 * @property openTableFormatInput Configuration block for open table formats. See `open_table_format_input` below.
 * @property owner Owner of the table.
 * @property parameters Properties associated with this table, as a list of key-value pairs.
 * @property partitionIndices Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
 * @property partitionKeys Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
 * @property retention Retention time for this table.
 * @property storageDescriptor Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
 * @property tableType Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
 * @property targetTable Configuration block of a target table for resource linking. See `target_table` below.
 * @property viewExpandedText If the table is a view, the expanded text of the view; otherwise null.
 * @property viewOriginalText If the table is a view, the original text of the view; otherwise null.
 */
public data class CatalogTableArgs(
    public val catalogId: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val openTableFormatInput: Output<CatalogTableOpenTableFormatInputArgs>? = null,
    public val owner: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val partitionIndices: Output<List<CatalogTablePartitionIndexArgs>>? = null,
    public val partitionKeys: Output<List<CatalogTablePartitionKeyArgs>>? = null,
    public val retention: Output<Int>? = null,
    public val storageDescriptor: Output<CatalogTableStorageDescriptorArgs>? = null,
    public val tableType: Output<String>? = null,
    public val targetTable: Output<CatalogTableTargetTableArgs>? = null,
    public val viewExpandedText: Output<String>? = null,
    public val viewOriginalText: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.CatalogTableArgs> {
    override fun toJava(): com.pulumi.aws.glue.CatalogTableArgs =
        com.pulumi.aws.glue.CatalogTableArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .openTableFormatInput(
                openTableFormatInput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .owner(owner?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .partitionIndices(
                partitionIndices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .partitionKeys(
                partitionKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .retention(retention?.applyValue({ args0 -> args0 }))
            .storageDescriptor(storageDescriptor?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableType(tableType?.applyValue({ args0 -> args0 }))
            .targetTable(targetTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .viewExpandedText(viewExpandedText?.applyValue({ args0 -> args0 }))
            .viewOriginalText(viewOriginalText?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableArgs].
 */
@PulumiTagMarker
public class CatalogTableArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var openTableFormatInput: Output<CatalogTableOpenTableFormatInputArgs>? = null

    private var owner: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var partitionIndices: Output<List<CatalogTablePartitionIndexArgs>>? = null

    private var partitionKeys: Output<List<CatalogTablePartitionKeyArgs>>? = null

    private var retention: Output<Int>? = null

    private var storageDescriptor: Output<CatalogTableStorageDescriptorArgs>? = null

    private var tableType: Output<String>? = null

    private var targetTable: Output<CatalogTableTargetTableArgs>? = null

    private var viewExpandedText: Output<String>? = null

    private var viewOriginalText: Output<String>? = null

    /**
     * @param value ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    @JvmName("jwmwbtmaqhvktqfl")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * The follow arguments are optional:
     */
    @JvmName("kovmskjgjlbllorh")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Description of the table.
     */
    @JvmName("almgtjtnpmeqfvox")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    @JvmName("kpwyslvpkaclfalw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for open table formats. See `open_table_format_input` below.
     */
    @JvmName("lpvgperikohwagxb")
    public suspend fun openTableFormatInput(`value`: Output<CatalogTableOpenTableFormatInputArgs>) {
        this.openTableFormatInput = value
    }

    /**
     * @param value Owner of the table.
     */
    @JvmName("bvuqyyrdyvicnpas")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("arckblbsvrpxfagw")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("uxlsvinysvcuumtr")
    public suspend fun partitionIndices(`value`: Output<List<CatalogTablePartitionIndexArgs>>) {
        this.partitionIndices = value
    }

    @JvmName("rcguylendtjnfwxg")
    public suspend fun partitionIndices(vararg values: Output<CatalogTablePartitionIndexArgs>) {
        this.partitionIndices = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("tnkygohaeqhyajhg")
    public suspend fun partitionIndices(values: List<Output<CatalogTablePartitionIndexArgs>>) {
        this.partitionIndices = Output.all(values)
    }

    /**
     * @param value Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("yajojkcxokaamapc")
    public suspend fun partitionKeys(`value`: Output<List<CatalogTablePartitionKeyArgs>>) {
        this.partitionKeys = value
    }

    @JvmName("kpcofidwskdxlasr")
    public suspend fun partitionKeys(vararg values: Output<CatalogTablePartitionKeyArgs>) {
        this.partitionKeys = Output.all(values.asList())
    }

    /**
     * @param values Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("vuexmdbaxdkknllq")
    public suspend fun partitionKeys(values: List<Output<CatalogTablePartitionKeyArgs>>) {
        this.partitionKeys = Output.all(values)
    }

    /**
     * @param value Retention time for this table.
     */
    @JvmName("oxxwryjgplxfjexy")
    public suspend fun retention(`value`: Output<Int>) {
        this.retention = value
    }

    /**
     * @param value Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     */
    @JvmName("cipnrdmrjeeckoeb")
    public suspend fun storageDescriptor(`value`: Output<CatalogTableStorageDescriptorArgs>) {
        this.storageDescriptor = value
    }

    /**
     * @param value Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
     */
    @JvmName("twlyjelbwwqknbws")
    public suspend fun tableType(`value`: Output<String>) {
        this.tableType = value
    }

    /**
     * @param value Configuration block of a target table for resource linking. See `target_table` below.
     */
    @JvmName("pniuwluwjkpcdpcl")
    public suspend fun targetTable(`value`: Output<CatalogTableTargetTableArgs>) {
        this.targetTable = value
    }

    /**
     * @param value If the table is a view, the expanded text of the view; otherwise null.
     */
    @JvmName("bmadlrwlkuxsitdr")
    public suspend fun viewExpandedText(`value`: Output<String>) {
        this.viewExpandedText = value
    }

    /**
     * @param value If the table is a view, the original text of the view; otherwise null.
     */
    @JvmName("uvncnpefwtujexke")
    public suspend fun viewOriginalText(`value`: Output<String>) {
        this.viewOriginalText = value
    }

    /**
     * @param value ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    @JvmName("chfeefliwggvoofn")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     * The follow arguments are optional:
     */
    @JvmName("ntmpchnhvnhkrynj")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Description of the table.
     */
    @JvmName("pesuggiyenbdgtwo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    @JvmName("oybdvbprjbeooosg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for open table formats. See `open_table_format_input` below.
     */
    @JvmName("uudvikbjyqxyxmsv")
    public suspend fun openTableFormatInput(`value`: CatalogTableOpenTableFormatInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openTableFormatInput = mapped
    }

    /**
     * @param argument Configuration block for open table formats. See `open_table_format_input` below.
     */
    @JvmName("rmtftstyusooljhj")
    public suspend fun openTableFormatInput(argument: suspend CatalogTableOpenTableFormatInputArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableOpenTableFormatInputArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.openTableFormatInput = mapped
    }

    /**
     * @param value Owner of the table.
     */
    @JvmName("rmonvvndgdxybplq")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("yuxawdvdnvcvtlcy")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("pxmcgrpfslrfaxbj")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("qpsmwooqmbcekrls")
    public suspend fun partitionIndices(`value`: List<CatalogTablePartitionIndexArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionIndices = mapped
    }

    /**
     * @param argument Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("uamjoedjduyqcrqp")
    public suspend fun partitionIndices(argument: List<suspend CatalogTablePartitionIndexArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionIndexArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionIndices = mapped
    }

    /**
     * @param argument Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("fnebdleafqohfvtm")
    public suspend fun partitionIndices(vararg argument: suspend CatalogTablePartitionIndexArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionIndexArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionIndices = mapped
    }

    /**
     * @param argument Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("rrtuegoptvystlsf")
    public suspend fun partitionIndices(argument: suspend CatalogTablePartitionIndexArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogTablePartitionIndexArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.partitionIndices = mapped
    }

    /**
     * @param values Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
     */
    @JvmName("vpcdrfhypkgvujcs")
    public suspend fun partitionIndices(vararg values: CatalogTablePartitionIndexArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionIndices = mapped
    }

    /**
     * @param value Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("khvwvviagkwjxeav")
    public suspend fun partitionKeys(`value`: List<CatalogTablePartitionKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param argument Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("qttirxiuijmueytb")
    public suspend fun partitionKeys(argument: List<suspend CatalogTablePartitionKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("xbidigcgglygnjgd")
    public suspend fun partitionKeys(vararg argument: suspend CatalogTablePartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CatalogTablePartitionKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("cyphqxxpmabpnesy")
    public suspend fun partitionKeys(argument: suspend CatalogTablePartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogTablePartitionKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param values Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
     */
    @JvmName("qwpyimehkltuijxo")
    public suspend fun partitionKeys(vararg values: CatalogTablePartitionKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param value Retention time for this table.
     */
    @JvmName("vxiskxkqwlvsxpfe")
    public suspend fun retention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     */
    @JvmName("wjqgotjdbfapeunf")
    public suspend fun storageDescriptor(`value`: CatalogTableStorageDescriptorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageDescriptor = mapped
    }

    /**
     * @param argument Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
     */
    @JvmName("rdapumjcwvddsira")
    public suspend fun storageDescriptor(argument: suspend CatalogTableStorageDescriptorArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableStorageDescriptorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageDescriptor = mapped
    }

    /**
     * @param value Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
     */
    @JvmName("jygignpqnrxfpfbd")
    public suspend fun tableType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableType = mapped
    }

    /**
     * @param value Configuration block of a target table for resource linking. See `target_table` below.
     */
    @JvmName("irfpowwcyjkxskrv")
    public suspend fun targetTable(`value`: CatalogTableTargetTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTable = mapped
    }

    /**
     * @param argument Configuration block of a target table for resource linking. See `target_table` below.
     */
    @JvmName("xqgsysltxxgmdmfj")
    public suspend fun targetTable(argument: suspend CatalogTableTargetTableArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableTargetTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetTable = mapped
    }

    /**
     * @param value If the table is a view, the expanded text of the view; otherwise null.
     */
    @JvmName("mijccscywoqbihbp")
    public suspend fun viewExpandedText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewExpandedText = mapped
    }

    /**
     * @param value If the table is a view, the original text of the view; otherwise null.
     */
    @JvmName("tffuwyecsaacyghn")
    public suspend fun viewOriginalText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewOriginalText = mapped
    }

    internal fun build(): CatalogTableArgs = CatalogTableArgs(
        catalogId = catalogId,
        databaseName = databaseName,
        description = description,
        name = name,
        openTableFormatInput = openTableFormatInput,
        owner = owner,
        parameters = parameters,
        partitionIndices = partitionIndices,
        partitionKeys = partitionKeys,
        retention = retention,
        storageDescriptor = storageDescriptor,
        tableType = tableType,
        targetTable = targetTable,
        viewExpandedText = viewExpandedText,
        viewOriginalText = viewOriginalText,
    )
}
