@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.ClassifierCsvClassifier
import com.pulumi.aws.glue.kotlin.outputs.ClassifierGrokClassifier
import com.pulumi.aws.glue.kotlin.outputs.ClassifierJsonClassifier
import com.pulumi.aws.glue.kotlin.outputs.ClassifierXmlClassifier
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.glue.kotlin.outputs.ClassifierCsvClassifier.Companion.toKotlin as classifierCsvClassifierToKotlin
import com.pulumi.aws.glue.kotlin.outputs.ClassifierGrokClassifier.Companion.toKotlin as classifierGrokClassifierToKotlin
import com.pulumi.aws.glue.kotlin.outputs.ClassifierJsonClassifier.Companion.toKotlin as classifierJsonClassifierToKotlin
import com.pulumi.aws.glue.kotlin.outputs.ClassifierXmlClassifier.Companion.toKotlin as classifierXmlClassifierToKotlin

/**
 * Builder for [Classifier].
 */
@PulumiTagMarker
public class ClassifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClassifierArgs = ClassifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClassifierArgsBuilder.() -> Unit) {
        val builder = ClassifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Classifier {
        val builtJavaResource = com.pulumi.aws.glue.Classifier(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Classifier(builtJavaResource)
    }
}

/**
 * Provides a Glue Classifier resource.
 * > **NOTE:** It is only valid to create one type of classifier (CSV, grok, JSON, or XML). Changing classifier types will recreate the classifier.
 * ## Example Usage
 * ### CSV Classifier
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Classifier("example", {
 *     name: "example",
 *     csvClassifier: {
 *         allowSingleColumn: false,
 *         containsHeader: "PRESENT",
 *         delimiter: ",",
 *         disableValueTrimming: false,
 *         headers: [
 *             "example1",
 *             "example2",
 *         ],
 *         quoteSymbol: "'",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Classifier("example",
 *     name="example",
 *     csv_classifier={
 *         "allow_single_column": False,
 *         "contains_header": "PRESENT",
 *         "delimiter": ",",
 *         "disable_value_trimming": False,
 *         "headers": [
 *             "example1",
 *             "example2",
 *         ],
 *         "quote_symbol": "'",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Classifier("example", new()
 *     {
 *         Name = "example",
 *         CsvClassifier = new Aws.Glue.Inputs.ClassifierCsvClassifierArgs
 *         {
 *             AllowSingleColumn = false,
 *             ContainsHeader = "PRESENT",
 *             Delimiter = ",",
 *             DisableValueTrimming = false,
 *             Headers = new[]
 *             {
 *                 "example1",
 *                 "example2",
 *             },
 *             QuoteSymbol = "'",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewClassifier(ctx, "example", &glue.ClassifierArgs{
 * 			Name: pulumi.String("example"),
 * 			CsvClassifier: &glue.ClassifierCsvClassifierArgs{
 * 				AllowSingleColumn:    pulumi.Bool(false),
 * 				ContainsHeader:       pulumi.String("PRESENT"),
 * 				Delimiter:            pulumi.String(","),
 * 				DisableValueTrimming: pulumi.Bool(false),
 * 				Headers: pulumi.StringArray{
 * 					pulumi.String("example1"),
 * 					pulumi.String("example2"),
 * 				},
 * 				QuoteSymbol: pulumi.String("'"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .name("example")
 *             .csvClassifier(ClassifierCsvClassifierArgs.builder()
 *                 .allowSingleColumn(false)
 *                 .containsHeader("PRESENT")
 *                 .delimiter(",")
 *                 .disableValueTrimming(false)
 *                 .headers(
 *                     "example1",
 *                     "example2")
 *                 .quoteSymbol("'")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Classifier
 *     properties:
 *       name: example
 *       csvClassifier:
 *         allowSingleColumn: false
 *         containsHeader: PRESENT
 *         delimiter: ','
 *         disableValueTrimming: false
 *         headers:
 *           - example1
 *           - example2
 *         quoteSymbol: ''''
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Grok Classifier
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Classifier("example", {
 *     name: "example",
 *     grokClassifier: {
 *         classification: "example",
 *         grokPattern: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Classifier("example",
 *     name="example",
 *     grok_classifier={
 *         "classification": "example",
 *         "grok_pattern": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Classifier("example", new()
 *     {
 *         Name = "example",
 *         GrokClassifier = new Aws.Glue.Inputs.ClassifierGrokClassifierArgs
 *         {
 *             Classification = "example",
 *             GrokPattern = "example",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewClassifier(ctx, "example", &glue.ClassifierArgs{
 * 			Name: pulumi.String("example"),
 * 			GrokClassifier: &glue.ClassifierGrokClassifierArgs{
 * 				Classification: pulumi.String("example"),
 * 				GrokPattern:    pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .name("example")
 *             .grokClassifier(ClassifierGrokClassifierArgs.builder()
 *                 .classification("example")
 *                 .grokPattern("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Classifier
 *     properties:
 *       name: example
 *       grokClassifier:
 *         classification: example
 *         grokPattern: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### JSON Classifier
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Classifier("example", {
 *     name: "example",
 *     jsonClassifier: {
 *         jsonPath: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Classifier("example",
 *     name="example",
 *     json_classifier={
 *         "json_path": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Classifier("example", new()
 *     {
 *         Name = "example",
 *         JsonClassifier = new Aws.Glue.Inputs.ClassifierJsonClassifierArgs
 *         {
 *             JsonPath = "example",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewClassifier(ctx, "example", &glue.ClassifierArgs{
 * 			Name: pulumi.String("example"),
 * 			JsonClassifier: &glue.ClassifierJsonClassifierArgs{
 * 				JsonPath: pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierJsonClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .name("example")
 *             .jsonClassifier(ClassifierJsonClassifierArgs.builder()
 *                 .jsonPath("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Classifier
 *     properties:
 *       name: example
 *       jsonClassifier:
 *         jsonPath: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### XML Classifier
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Classifier("example", {
 *     name: "example",
 *     xmlClassifier: {
 *         classification: "example",
 *         rowTag: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Classifier("example",
 *     name="example",
 *     xml_classifier={
 *         "classification": "example",
 *         "row_tag": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Classifier("example", new()
 *     {
 *         Name = "example",
 *         XmlClassifier = new Aws.Glue.Inputs.ClassifierXmlClassifierArgs
 *         {
 *             Classification = "example",
 *             RowTag = "example",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewClassifier(ctx, "example", &glue.ClassifierArgs{
 * 			Name: pulumi.String("example"),
 * 			XmlClassifier: &glue.ClassifierXmlClassifierArgs{
 * 				Classification: pulumi.String("example"),
 * 				RowTag:         pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Classifier;
 * import com.pulumi.aws.glue.ClassifierArgs;
 * import com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Classifier("example", ClassifierArgs.builder()
 *             .name("example")
 *             .xmlClassifier(ClassifierXmlClassifierArgs.builder()
 *                 .classification("example")
 *                 .rowTag("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Classifier
 *     properties:
 *       name: example
 *       xmlClassifier:
 *         classification: example
 *         rowTag: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Classifiers using their name. For example:
 * ```sh
 * $ pulumi import aws:glue/classifier:Classifier MyClassifier MyClassifier
 * ```
 */
public class Classifier internal constructor(
    override val javaResource: com.pulumi.aws.glue.Classifier,
) : KotlinCustomResource(javaResource, ClassifierMapper) {
    /**
     * A classifier for CSV content. Defined below.
     */
    public val csvClassifier: Output<ClassifierCsvClassifier>?
        get() = javaResource.csvClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierCsvClassifierToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A classifier that uses grok patterns. Defined below.
     */
    public val grokClassifier: Output<ClassifierGrokClassifier>?
        get() = javaResource.grokClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierGrokClassifierToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A classifier for JSON content. Defined below.
     */
    public val jsonClassifier: Output<ClassifierJsonClassifier>?
        get() = javaResource.jsonClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierJsonClassifierToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the classifier.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A classifier for XML content. Defined below.
     */
    public val xmlClassifier: Output<ClassifierXmlClassifier>?
        get() = javaResource.xmlClassifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> classifierXmlClassifierToKotlin(args0) })
            }).orElse(null)
        })
}

public object ClassifierMapper : ResourceMapper<Classifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Classifier::class == javaResource::class

    override fun map(javaResource: Resource): Classifier = Classifier(
        javaResource as
            com.pulumi.aws.glue.Classifier,
    )
}

/**
 * @see [Classifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Classifier].
 */
public suspend fun classifier(name: String, block: suspend ClassifierResourceBuilder.() -> Unit): Classifier {
    val builder = ClassifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Classifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun classifier(name: String): Classifier {
    val builder = ClassifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
