@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.CrawlerCatalogTarget
import com.pulumi.aws.glue.kotlin.outputs.CrawlerDeltaTarget
import com.pulumi.aws.glue.kotlin.outputs.CrawlerDynamodbTarget
import com.pulumi.aws.glue.kotlin.outputs.CrawlerHudiTarget
import com.pulumi.aws.glue.kotlin.outputs.CrawlerIcebergTarget
import com.pulumi.aws.glue.kotlin.outputs.CrawlerJdbcTarget
import com.pulumi.aws.glue.kotlin.outputs.CrawlerLakeFormationConfiguration
import com.pulumi.aws.glue.kotlin.outputs.CrawlerLineageConfiguration
import com.pulumi.aws.glue.kotlin.outputs.CrawlerMongodbTarget
import com.pulumi.aws.glue.kotlin.outputs.CrawlerRecrawlPolicy
import com.pulumi.aws.glue.kotlin.outputs.CrawlerS3Target
import com.pulumi.aws.glue.kotlin.outputs.CrawlerSchemaChangePolicy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.glue.kotlin.outputs.CrawlerCatalogTarget.Companion.toKotlin as crawlerCatalogTargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerDeltaTarget.Companion.toKotlin as crawlerDeltaTargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerDynamodbTarget.Companion.toKotlin as crawlerDynamodbTargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerHudiTarget.Companion.toKotlin as crawlerHudiTargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerIcebergTarget.Companion.toKotlin as crawlerIcebergTargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerJdbcTarget.Companion.toKotlin as crawlerJdbcTargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerLakeFormationConfiguration.Companion.toKotlin as crawlerLakeFormationConfigurationToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerLineageConfiguration.Companion.toKotlin as crawlerLineageConfigurationToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerMongodbTarget.Companion.toKotlin as crawlerMongodbTargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerRecrawlPolicy.Companion.toKotlin as crawlerRecrawlPolicyToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerS3Target.Companion.toKotlin as crawlerS3TargetToKotlin
import com.pulumi.aws.glue.kotlin.outputs.CrawlerSchemaChangePolicy.Companion.toKotlin as crawlerSchemaChangePolicyToKotlin

/**
 * Builder for [Crawler].
 */
@PulumiTagMarker
public class CrawlerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CrawlerArgs = CrawlerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CrawlerArgsBuilder.() -> Unit) {
        val builder = CrawlerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Crawler {
        val builtJavaResource = com.pulumi.aws.glue.Crawler(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Crawler(builtJavaResource)
    }
}

/**
 * Manages a Glue Crawler. More information can be found in the [AWS Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html)
 * ## Example Usage
 * ### DynamoDB Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     dynamodbTargets: [{
 *         path: "table-name",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     dynamodb_targets=[{
 *         "path": "table-name",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         DynamodbTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerDynamodbTargetArgs
 *             {
 *                 Path = "table-name",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			DynamodbTargets: glue.CrawlerDynamodbTargetArray{
 * 				&glue.CrawlerDynamodbTargetArgs{
 * 					Path: pulumi.String("table-name"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerDynamodbTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .dynamodbTargets(CrawlerDynamodbTargetArgs.builder()
 *                 .path("table-name")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       dynamodbTargets:
 *         - path: table-name
 * ```
 * <!--End PulumiCodeChooser -->
 * ### JDBC Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     jdbcTargets: [{
 *         connectionName: exampleAwsGlueConnection.name,
 *         path: "database-name/%",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     jdbc_targets=[{
 *         "connection_name": example_aws_glue_connection["name"],
 *         "path": "database-name/%",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         JdbcTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerJdbcTargetArgs
 *             {
 *                 ConnectionName = exampleAwsGlueConnection.Name,
 *                 Path = "database-name/%",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			JdbcTargets: glue.CrawlerJdbcTargetArray{
 * 				&glue.CrawlerJdbcTargetArgs{
 * 					ConnectionName: pulumi.Any(exampleAwsGlueConnection.Name),
 * 					Path:           pulumi.String("database-name/%"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerJdbcTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .jdbcTargets(CrawlerJdbcTargetArgs.builder()
 *                 .connectionName(exampleAwsGlueConnection.name())
 *                 .path("database-name/%")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       jdbcTargets:
 *         - connectionName: ${exampleAwsGlueConnection.name}
 *           path: database-name/%
 * ```
 * <!--End PulumiCodeChooser -->
 * ### S3 Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     s3Targets: [{
 *         path: `s3://${exampleAwsS3Bucket.bucket}`,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     s3_targets=[{
 *         "path": f"s3://{example_aws_s3_bucket['bucket']}",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         S3Targets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerS3TargetArgs
 *             {
 *                 Path = $"s3://{exampleAwsS3Bucket.Bucket}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			S3Targets: glue.CrawlerS3TargetArray{
 * 				&glue.CrawlerS3TargetArgs{
 * 					Path: pulumi.Sprintf("s3://%v", exampleAwsS3Bucket.Bucket),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .s3Targets(CrawlerS3TargetArgs.builder()
 *                 .path(String.format("s3://%s", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       s3Targets:
 *         - path: s3://${exampleAwsS3Bucket.bucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Catalog Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     catalogTargets: [{
 *         databaseName: exampleAwsGlueCatalogDatabase.name,
 *         tables: [exampleAwsGlueCatalogTable&#46;name],
 *     }],
 *     schemaChangePolicy: {
 *         deleteBehavior: "LOG",
 *     },
 *     configuration: `{
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     catalog_targets=[{
 *         "database_name": example_aws_glue_catalog_database["name"],
 *         "tables": [example_aws_glue_catalog_table["name"]],
 *     }],
 *     schema_change_policy={
 *         "delete_behavior": "LOG",
 *     },
 *     configuration="""{
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         CatalogTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerCatalogTargetArgs
 *             {
 *                 DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *                 Tables = new[]
 *                 {
 *                     exampleAwsGlueCatalogTable.Name,
 *                 },
 *             },
 *         },
 *         SchemaChangePolicy = new Aws.Glue.Inputs.CrawlerSchemaChangePolicyArgs
 *         {
 *             DeleteBehavior = "LOG",
 *         },
 *         Configuration = @"{
 *   ""Version"":1.0,
 *   ""Grouping"": {
 *     ""TableGroupingPolicy"": ""CombineCompatibleSchemas""
 *   }
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			CatalogTargets: glue.CrawlerCatalogTargetArray{
 * 				&glue.CrawlerCatalogTargetArgs{
 * 					DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 					Tables: pulumi.StringArray{
 * 						exampleAwsGlueCatalogTable.Name,
 * 					},
 * 				},
 * 			},
 * 			SchemaChangePolicy: &glue.CrawlerSchemaChangePolicyArgs{
 * 				DeleteBehavior: pulumi.String("LOG"),
 * 			},
 * 			Configuration: pulumi.String(`{
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerCatalogTargetArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerSchemaChangePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .catalogTargets(CrawlerCatalogTargetArgs.builder()
 *                 .databaseName(exampleAwsGlueCatalogDatabase.name())
 *                 .tables(exampleAwsGlueCatalogTable.name())
 *                 .build())
 *             .schemaChangePolicy(CrawlerSchemaChangePolicyArgs.builder()
 *                 .deleteBehavior("LOG")
 *                 .build())
 *             .configuration("""
 * {
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       catalogTargets:
 *         - databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *           tables:
 *             - ${exampleAwsGlueCatalogTable.name}
 *       schemaChangePolicy:
 *         deleteBehavior: LOG
 *       configuration: |
 *         {
 *           "Version":1.0,
 *           "Grouping": {
 *             "TableGroupingPolicy": "CombineCompatibleSchemas"
 *           }
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### MongoDB Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     mongodbTargets: [{
 *         connectionName: exampleAwsGlueConnection.name,
 *         path: "database-name/%",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     mongodb_targets=[{
 *         "connection_name": example_aws_glue_connection["name"],
 *         "path": "database-name/%",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         MongodbTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerMongodbTargetArgs
 *             {
 *                 ConnectionName = exampleAwsGlueConnection.Name,
 *                 Path = "database-name/%",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			MongodbTargets: glue.CrawlerMongodbTargetArray{
 * 				&glue.CrawlerMongodbTargetArgs{
 * 					ConnectionName: pulumi.Any(exampleAwsGlueConnection.Name),
 * 					Path:           pulumi.String("database-name/%"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerMongodbTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .mongodbTargets(CrawlerMongodbTargetArgs.builder()
 *                 .connectionName(exampleAwsGlueConnection.name())
 *                 .path("database-name/%")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       mongodbTargets:
 *         - connectionName: ${exampleAwsGlueConnection.name}
 *           path: database-name/%
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Configuration Settings Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const eventsCrawler = new aws.glue.Crawler("events_crawler", {
 *     databaseName: glueDatabase.name,
 *     schedule: "cron(0 1 * * ? *)",
 *     name: `events_crawler_${environmentName}`,
 *     role: glueRole.arn,
 *     tags: tags,
 *     configuration: JSON.stringify({
 *         Grouping: {
 *             TableGroupingPolicy: "CombineCompatibleSchemas",
 *         },
 *         CrawlerOutput: {
 *             Partitions: {
 *                 AddOrUpdateBehavior: "InheritFromTable",
 *             },
 *         },
 *         Version: 1,
 *     }),
 *     s3Targets: [{
 *         path: `s3://${dataLakeBucket.bucket}`,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * events_crawler = aws.glue.Crawler("events_crawler",
 *     database_name=glue_database["name"],
 *     schedule="cron(0 1 * * ? *)",
 *     name=f"events_crawler_{environment_name}",
 *     role=glue_role["arn"],
 *     tags=tags,
 *     configuration=json.dumps({
 *         "Grouping": {
 *             "TableGroupingPolicy": "CombineCompatibleSchemas",
 *         },
 *         "CrawlerOutput": {
 *             "Partitions": {
 *                 "AddOrUpdateBehavior": "InheritFromTable",
 *             },
 *         },
 *         "Version": 1,
 *     }),
 *     s3_targets=[{
 *         "path": f"s3://{data_lake_bucket['bucket']}",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventsCrawler = new Aws.Glue.Crawler("events_crawler", new()
 *     {
 *         DatabaseName = glueDatabase.Name,
 *         Schedule = "cron(0 1 * * ? *)",
 *         Name = $"events_crawler_{environmentName}",
 *         Role = glueRole.Arn,
 *         Tags = tags,
 *         Configuration = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Grouping"] = new Dictionary<string, object?>
 *             {
 *                 ["TableGroupingPolicy"] = "CombineCompatibleSchemas",
 *             },
 *             ["CrawlerOutput"] = new Dictionary<string, object?>
 *             {
 *                 ["Partitions"] = new Dictionary<string, object?>
 *                 {
 *                     ["AddOrUpdateBehavior"] = "InheritFromTable",
 *                 },
 *             },
 *             ["Version"] = 1,
 *         }),
 *         S3Targets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerS3TargetArgs
 *             {
 *                 Path = $"s3://{dataLakeBucket.Bucket}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Grouping": map[string]interface{}{
 * 				"TableGroupingPolicy": "CombineCompatibleSchemas",
 * 			},
 * 			"CrawlerOutput": map[string]interface{}{
 * 				"Partitions": map[string]interface{}{
 * 					"AddOrUpdateBehavior": "InheritFromTable",
 * 				},
 * 			},
 * 			"Version": 1,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = glue.NewCrawler(ctx, "events_crawler", &glue.CrawlerArgs{
 * 			DatabaseName:  pulumi.Any(glueDatabase.Name),
 * 			Schedule:      pulumi.String("cron(0 1 * * ? *)"),
 * 			Name:          pulumi.Sprintf("events_crawler_%v", environmentName),
 * 			Role:          pulumi.Any(glueRole.Arn),
 * 			Tags:          pulumi.Any(tags),
 * 			Configuration: pulumi.String(json0),
 * 			S3Targets: glue.CrawlerS3TargetArray{
 * 				&glue.CrawlerS3TargetArgs{
 * 					Path: pulumi.Sprintf("s3://%v", dataLakeBucket.Bucket),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventsCrawler = new Crawler("eventsCrawler", CrawlerArgs.builder()
 *             .databaseName(glueDatabase.name())
 *             .schedule("cron(0 1 * * ? *)")
 *             .name(String.format("events_crawler_%s", environmentName))
 *             .role(glueRole.arn())
 *             .tags(tags)
 *             .configuration(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Grouping", jsonObject(
 *                         jsonProperty("TableGroupingPolicy", "CombineCompatibleSchemas")
 *                     )),
 *                     jsonProperty("CrawlerOutput", jsonObject(
 *                         jsonProperty("Partitions", jsonObject(
 *                             jsonProperty("AddOrUpdateBehavior", "InheritFromTable")
 *                         ))
 *                     )),
 *                     jsonProperty("Version", 1)
 *                 )))
 *             .s3Targets(CrawlerS3TargetArgs.builder()
 *                 .path(String.format("s3://%s", dataLakeBucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   eventsCrawler:
 *     type: aws:glue:Crawler
 *     name: events_crawler
 *     properties:
 *       databaseName: ${glueDatabase.name}
 *       schedule: cron(0 1 * * ? *)
 *       name: events_crawler_${environmentName}
 *       role: ${glueRole.arn}
 *       tags: ${tags}
 *       configuration:
 *         fn::toJSON:
 *           Grouping:
 *             TableGroupingPolicy: CombineCompatibleSchemas
 *           CrawlerOutput:
 *             Partitions:
 *               AddOrUpdateBehavior: InheritFromTable
 *           Version: 1
 *       s3Targets:
 *         - path: s3://${dataLakeBucket.bucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Crawlers using `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/crawler:Crawler MyJob MyJob
 * ```
 */
public class Crawler internal constructor(
    override val javaResource: com.pulumi.aws.glue.Crawler,
) : KotlinCustomResource(javaResource, CrawlerMapper) {
    /**
     * The ARN of the crawler
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    public val catalogTargets: Output<List<CrawlerCatalogTarget>>?
        get() = javaResource.catalogTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        crawlerCatalogTargetToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    public val classifiers: Output<List<String>>?
        get() = javaResource.classifiers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
     */
    public val configuration: Output<String>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Glue database where results are written.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * List of nested Delta Lake target arguments. See Delta Target below.
     */
    public val deltaTargets: Output<List<CrawlerDeltaTarget>>?
        get() = javaResource.deltaTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> crawlerDeltaTargetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Description of the crawler.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    public val dynamodbTargets: Output<List<CrawlerDynamodbTarget>>?
        get() = javaResource.dynamodbTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        crawlerDynamodbTargetToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of nested Hudi target arguments. See Iceberg Target below.
     */
    public val hudiTargets: Output<List<CrawlerHudiTarget>>?
        get() = javaResource.hudiTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> crawlerHudiTargetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * List of nested Iceberg target arguments. See Iceberg Target below.
     */
    public val icebergTargets: Output<List<CrawlerIcebergTarget>>?
        get() = javaResource.icebergTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        crawlerIcebergTargetToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of nested JDBC target arguments. See JDBC Target below.
     */
    public val jdbcTargets: Output<List<CrawlerJdbcTarget>>?
        get() = javaResource.jdbcTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> crawlerJdbcTargetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
     */
    public val lakeFormationConfiguration: Output<CrawlerLakeFormationConfiguration>?
        get() = javaResource.lakeFormationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> crawlerLakeFormationConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
     */
    public val lineageConfiguration: Output<CrawlerLineageConfiguration>?
        get() = javaResource.lineageConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> crawlerLineageConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of nested MongoDB target arguments. See MongoDB Target below.
     */
    public val mongodbTargets: Output<List<CrawlerMongodbTarget>>?
        get() = javaResource.mongodbTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        crawlerMongodbTargetToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Name of the crawler.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
     */
    public val recrawlPolicy: Output<CrawlerRecrawlPolicy>?
        get() = javaResource.recrawlPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> crawlerRecrawlPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * List of nested Amazon S3 target arguments. See S3 Target below.
     */
    public val s3Targets: Output<List<CrawlerS3Target>>?
        get() = javaResource.s3Targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> crawlerS3TargetToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
     */
    public val schedule: Output<String>?
        get() = javaResource.schedule().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
     */
    public val schemaChangePolicy: Output<CrawlerSchemaChangePolicy>?
        get() = javaResource.schemaChangePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> crawlerSchemaChangePolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of Security Configuration to be used by the crawler
     */
    public val securityConfiguration: Output<String>?
        get() = javaResource.securityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The table prefix used for catalog tables that are created.
     */
    public val tablePrefix: Output<String>?
        get() = javaResource.tablePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CrawlerMapper : ResourceMapper<Crawler> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Crawler::class == javaResource::class

    override fun map(javaResource: Resource): Crawler = Crawler(
        javaResource as
            com.pulumi.aws.glue.Crawler,
    )
}

/**
 * @see [Crawler].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Crawler].
 */
public suspend fun crawler(name: String, block: suspend CrawlerResourceBuilder.() -> Unit): Crawler {
    val builder = CrawlerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Crawler].
 * @param name The _unique_ name of the resulting resource.
 */
public fun crawler(name: String): Crawler {
    val builder = CrawlerResourceBuilder()
    builder.name(name)
    return builder.build()
}
