@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.CrawlerArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerCatalogTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerCatalogTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDeltaTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDeltaTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDynamodbTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerDynamodbTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerHudiTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerHudiTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerIcebergTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerIcebergTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerJdbcTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerJdbcTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLakeFormationConfigurationArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLakeFormationConfigurationArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLineageConfigurationArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerLineageConfigurationArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerMongodbTargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerMongodbTargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerRecrawlPolicyArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerRecrawlPolicyArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerS3TargetArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerS3TargetArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.CrawlerSchemaChangePolicyArgs
import com.pulumi.aws.glue.kotlin.inputs.CrawlerSchemaChangePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Glue Crawler. More information can be found in the [AWS Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html)
 * ## Example Usage
 * ### DynamoDB Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     dynamodbTargets: [{
 *         path: "table-name",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     dynamodb_targets=[{
 *         "path": "table-name",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         DynamodbTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerDynamodbTargetArgs
 *             {
 *                 Path = "table-name",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			DynamodbTargets: glue.CrawlerDynamodbTargetArray{
 * 				&glue.CrawlerDynamodbTargetArgs{
 * 					Path: pulumi.String("table-name"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerDynamodbTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .dynamodbTargets(CrawlerDynamodbTargetArgs.builder()
 *                 .path("table-name")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       dynamodbTargets:
 *         - path: table-name
 * ```
 * <!--End PulumiCodeChooser -->
 * ### JDBC Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     jdbcTargets: [{
 *         connectionName: exampleAwsGlueConnection.name,
 *         path: "database-name/%",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     jdbc_targets=[{
 *         "connection_name": example_aws_glue_connection["name"],
 *         "path": "database-name/%",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         JdbcTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerJdbcTargetArgs
 *             {
 *                 ConnectionName = exampleAwsGlueConnection.Name,
 *                 Path = "database-name/%",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			JdbcTargets: glue.CrawlerJdbcTargetArray{
 * 				&glue.CrawlerJdbcTargetArgs{
 * 					ConnectionName: pulumi.Any(exampleAwsGlueConnection.Name),
 * 					Path:           pulumi.String("database-name/%"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerJdbcTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .jdbcTargets(CrawlerJdbcTargetArgs.builder()
 *                 .connectionName(exampleAwsGlueConnection.name())
 *                 .path("database-name/%")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       jdbcTargets:
 *         - connectionName: ${exampleAwsGlueConnection.name}
 *           path: database-name/%
 * ```
 * <!--End PulumiCodeChooser -->
 * ### S3 Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     s3Targets: [{
 *         path: `s3://${exampleAwsS3Bucket.bucket}`,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     s3_targets=[{
 *         "path": f"s3://{example_aws_s3_bucket['bucket']}",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         S3Targets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerS3TargetArgs
 *             {
 *                 Path = $"s3://{exampleAwsS3Bucket.Bucket}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			S3Targets: glue.CrawlerS3TargetArray{
 * 				&glue.CrawlerS3TargetArgs{
 * 					Path: pulumi.Sprintf("s3://%v", exampleAwsS3Bucket.Bucket),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .s3Targets(CrawlerS3TargetArgs.builder()
 *                 .path(String.format("s3://%s", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       s3Targets:
 *         - path: s3://${exampleAwsS3Bucket.bucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Catalog Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     catalogTargets: [{
 *         databaseName: exampleAwsGlueCatalogDatabase.name,
 *         tables: [exampleAwsGlueCatalogTable&#46;name],
 *     }],
 *     schemaChangePolicy: {
 *         deleteBehavior: "LOG",
 *     },
 *     configuration: `{
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     catalog_targets=[{
 *         "database_name": example_aws_glue_catalog_database["name"],
 *         "tables": [example_aws_glue_catalog_table["name"]],
 *     }],
 *     schema_change_policy={
 *         "delete_behavior": "LOG",
 *     },
 *     configuration="""{
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         CatalogTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerCatalogTargetArgs
 *             {
 *                 DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *                 Tables = new[]
 *                 {
 *                     exampleAwsGlueCatalogTable.Name,
 *                 },
 *             },
 *         },
 *         SchemaChangePolicy = new Aws.Glue.Inputs.CrawlerSchemaChangePolicyArgs
 *         {
 *             DeleteBehavior = "LOG",
 *         },
 *         Configuration = @"{
 *   ""Version"":1.0,
 *   ""Grouping"": {
 *     ""TableGroupingPolicy"": ""CombineCompatibleSchemas""
 *   }
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			CatalogTargets: glue.CrawlerCatalogTargetArray{
 * 				&glue.CrawlerCatalogTargetArgs{
 * 					DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 					Tables: pulumi.StringArray{
 * 						exampleAwsGlueCatalogTable.Name,
 * 					},
 * 				},
 * 			},
 * 			SchemaChangePolicy: &glue.CrawlerSchemaChangePolicyArgs{
 * 				DeleteBehavior: pulumi.String("LOG"),
 * 			},
 * 			Configuration: pulumi.String(`{
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerCatalogTargetArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerSchemaChangePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .catalogTargets(CrawlerCatalogTargetArgs.builder()
 *                 .databaseName(exampleAwsGlueCatalogDatabase.name())
 *                 .tables(exampleAwsGlueCatalogTable.name())
 *                 .build())
 *             .schemaChangePolicy(CrawlerSchemaChangePolicyArgs.builder()
 *                 .deleteBehavior("LOG")
 *                 .build())
 *             .configuration("""
 * {
 *   "Version":1.0,
 *   "Grouping": {
 *     "TableGroupingPolicy": "CombineCompatibleSchemas"
 *   }
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       catalogTargets:
 *         - databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *           tables:
 *             - ${exampleAwsGlueCatalogTable.name}
 *       schemaChangePolicy:
 *         deleteBehavior: LOG
 *       configuration: |
 *         {
 *           "Version":1.0,
 *           "Grouping": {
 *             "TableGroupingPolicy": "CombineCompatibleSchemas"
 *           }
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### MongoDB Target Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Crawler("example", {
 *     databaseName: exampleAwsGlueCatalogDatabase.name,
 *     name: "example",
 *     role: exampleAwsIamRole.arn,
 *     mongodbTargets: [{
 *         connectionName: exampleAwsGlueConnection.name,
 *         path: "database-name/%",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Crawler("example",
 *     database_name=example_aws_glue_catalog_database["name"],
 *     name="example",
 *     role=example_aws_iam_role["arn"],
 *     mongodb_targets=[{
 *         "connection_name": example_aws_glue_connection["name"],
 *         "path": "database-name/%",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Crawler("example", new()
 *     {
 *         DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *         Name = "example",
 *         Role = exampleAwsIamRole.Arn,
 *         MongodbTargets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerMongodbTargetArgs
 *             {
 *                 ConnectionName = exampleAwsGlueConnection.Name,
 *                 Path = "database-name/%",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewCrawler(ctx, "example", &glue.CrawlerArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 			Name:         pulumi.String("example"),
 * 			Role:         pulumi.Any(exampleAwsIamRole.Arn),
 * 			MongodbTargets: glue.CrawlerMongodbTargetArray{
 * 				&glue.CrawlerMongodbTargetArgs{
 * 					ConnectionName: pulumi.Any(exampleAwsGlueConnection.Name),
 * 					Path:           pulumi.String("database-name/%"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerMongodbTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Crawler("example", CrawlerArgs.builder()
 *             .databaseName(exampleAwsGlueCatalogDatabase.name())
 *             .name("example")
 *             .role(exampleAwsIamRole.arn())
 *             .mongodbTargets(CrawlerMongodbTargetArgs.builder()
 *                 .connectionName(exampleAwsGlueConnection.name())
 *                 .path("database-name/%")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Crawler
 *     properties:
 *       databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *       name: example
 *       role: ${exampleAwsIamRole.arn}
 *       mongodbTargets:
 *         - connectionName: ${exampleAwsGlueConnection.name}
 *           path: database-name/%
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Configuration Settings Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const eventsCrawler = new aws.glue.Crawler("events_crawler", {
 *     databaseName: glueDatabase.name,
 *     schedule: "cron(0 1 * * ? *)",
 *     name: `events_crawler_${environmentName}`,
 *     role: glueRole.arn,
 *     tags: tags,
 *     configuration: JSON.stringify({
 *         Grouping: {
 *             TableGroupingPolicy: "CombineCompatibleSchemas",
 *         },
 *         CrawlerOutput: {
 *             Partitions: {
 *                 AddOrUpdateBehavior: "InheritFromTable",
 *             },
 *         },
 *         Version: 1,
 *     }),
 *     s3Targets: [{
 *         path: `s3://${dataLakeBucket.bucket}`,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * events_crawler = aws.glue.Crawler("events_crawler",
 *     database_name=glue_database["name"],
 *     schedule="cron(0 1 * * ? *)",
 *     name=f"events_crawler_{environment_name}",
 *     role=glue_role["arn"],
 *     tags=tags,
 *     configuration=json.dumps({
 *         "Grouping": {
 *             "TableGroupingPolicy": "CombineCompatibleSchemas",
 *         },
 *         "CrawlerOutput": {
 *             "Partitions": {
 *                 "AddOrUpdateBehavior": "InheritFromTable",
 *             },
 *         },
 *         "Version": 1,
 *     }),
 *     s3_targets=[{
 *         "path": f"s3://{data_lake_bucket['bucket']}",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventsCrawler = new Aws.Glue.Crawler("events_crawler", new()
 *     {
 *         DatabaseName = glueDatabase.Name,
 *         Schedule = "cron(0 1 * * ? *)",
 *         Name = $"events_crawler_{environmentName}",
 *         Role = glueRole.Arn,
 *         Tags = tags,
 *         Configuration = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Grouping"] = new Dictionary<string, object?>
 *             {
 *                 ["TableGroupingPolicy"] = "CombineCompatibleSchemas",
 *             },
 *             ["CrawlerOutput"] = new Dictionary<string, object?>
 *             {
 *                 ["Partitions"] = new Dictionary<string, object?>
 *                 {
 *                     ["AddOrUpdateBehavior"] = "InheritFromTable",
 *                 },
 *             },
 *             ["Version"] = 1,
 *         }),
 *         S3Targets = new[]
 *         {
 *             new Aws.Glue.Inputs.CrawlerS3TargetArgs
 *             {
 *                 Path = $"s3://{dataLakeBucket.Bucket}",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Grouping": map[string]interface{}{
 * 				"TableGroupingPolicy": "CombineCompatibleSchemas",
 * 			},
 * 			"CrawlerOutput": map[string]interface{}{
 * 				"Partitions": map[string]interface{}{
 * 					"AddOrUpdateBehavior": "InheritFromTable",
 * 				},
 * 			},
 * 			"Version": 1,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = glue.NewCrawler(ctx, "events_crawler", &glue.CrawlerArgs{
 * 			DatabaseName:  pulumi.Any(glueDatabase.Name),
 * 			Schedule:      pulumi.String("cron(0 1 * * ? *)"),
 * 			Name:          pulumi.Sprintf("events_crawler_%v", environmentName),
 * 			Role:          pulumi.Any(glueRole.Arn),
 * 			Tags:          pulumi.Any(tags),
 * 			Configuration: pulumi.String(json0),
 * 			S3Targets: glue.CrawlerS3TargetArray{
 * 				&glue.CrawlerS3TargetArgs{
 * 					Path: pulumi.Sprintf("s3://%v", dataLakeBucket.Bucket),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Crawler;
 * import com.pulumi.aws.glue.CrawlerArgs;
 * import com.pulumi.aws.glue.inputs.CrawlerS3TargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventsCrawler = new Crawler("eventsCrawler", CrawlerArgs.builder()
 *             .databaseName(glueDatabase.name())
 *             .schedule("cron(0 1 * * ? *)")
 *             .name(String.format("events_crawler_%s", environmentName))
 *             .role(glueRole.arn())
 *             .tags(tags)
 *             .configuration(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Grouping", jsonObject(
 *                         jsonProperty("TableGroupingPolicy", "CombineCompatibleSchemas")
 *                     )),
 *                     jsonProperty("CrawlerOutput", jsonObject(
 *                         jsonProperty("Partitions", jsonObject(
 *                             jsonProperty("AddOrUpdateBehavior", "InheritFromTable")
 *                         ))
 *                     )),
 *                     jsonProperty("Version", 1)
 *                 )))
 *             .s3Targets(CrawlerS3TargetArgs.builder()
 *                 .path(String.format("s3://%s", dataLakeBucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   eventsCrawler:
 *     type: aws:glue:Crawler
 *     name: events_crawler
 *     properties:
 *       databaseName: ${glueDatabase.name}
 *       schedule: cron(0 1 * * ? *)
 *       name: events_crawler_${environmentName}
 *       role: ${glueRole.arn}
 *       tags: ${tags}
 *       configuration:
 *         fn::toJSON:
 *           Grouping:
 *             TableGroupingPolicy: CombineCompatibleSchemas
 *           CrawlerOutput:
 *             Partitions:
 *               AddOrUpdateBehavior: InheritFromTable
 *           Version: 1
 *       s3Targets:
 *         - path: s3://${dataLakeBucket.bucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Crawlers using `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/crawler:Crawler MyJob MyJob
 * ```
 * @property catalogTargets List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
 * @property classifiers List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
 * @property configuration JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
 * @property databaseName Glue database where results are written.
 * @property deltaTargets List of nested Delta Lake target arguments. See Delta Target below.
 * @property description Description of the crawler.
 * @property dynamodbTargets List of nested DynamoDB target arguments. See Dynamodb Target below.
 * @property hudiTargets List of nested Hudi target arguments. See Iceberg Target below.
 * @property icebergTargets List of nested Iceberg target arguments. See Iceberg Target below.
 * @property jdbcTargets List of nested JDBC target arguments. See JDBC Target below.
 * @property lakeFormationConfiguration Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
 * @property lineageConfiguration Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
 * @property mongodbTargets List of nested MongoDB target arguments. See MongoDB Target below.
 * @property name Name of the crawler.
 * @property recrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
 * @property role The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
 * @property s3Targets List of nested Amazon S3 target arguments. See S3 Target below.
 * @property schedule A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
 * @property schemaChangePolicy Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
 * @property securityConfiguration The name of Security Configuration to be used by the crawler
 * @property tablePrefix The table prefix used for catalog tables that are created.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CrawlerArgs(
    public val catalogTargets: Output<List<CrawlerCatalogTargetArgs>>? = null,
    public val classifiers: Output<List<String>>? = null,
    public val configuration: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val deltaTargets: Output<List<CrawlerDeltaTargetArgs>>? = null,
    public val description: Output<String>? = null,
    public val dynamodbTargets: Output<List<CrawlerDynamodbTargetArgs>>? = null,
    public val hudiTargets: Output<List<CrawlerHudiTargetArgs>>? = null,
    public val icebergTargets: Output<List<CrawlerIcebergTargetArgs>>? = null,
    public val jdbcTargets: Output<List<CrawlerJdbcTargetArgs>>? = null,
    public val lakeFormationConfiguration: Output<CrawlerLakeFormationConfigurationArgs>? = null,
    public val lineageConfiguration: Output<CrawlerLineageConfigurationArgs>? = null,
    public val mongodbTargets: Output<List<CrawlerMongodbTargetArgs>>? = null,
    public val name: Output<String>? = null,
    public val recrawlPolicy: Output<CrawlerRecrawlPolicyArgs>? = null,
    public val role: Output<String>? = null,
    public val s3Targets: Output<List<CrawlerS3TargetArgs>>? = null,
    public val schedule: Output<String>? = null,
    public val schemaChangePolicy: Output<CrawlerSchemaChangePolicyArgs>? = null,
    public val securityConfiguration: Output<String>? = null,
    public val tablePrefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.CrawlerArgs> {
    override fun toJava(): com.pulumi.aws.glue.CrawlerArgs = com.pulumi.aws.glue.CrawlerArgs.builder()
        .catalogTargets(
            catalogTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .classifiers(classifiers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .configuration(configuration?.applyValue({ args0 -> args0 }))
        .databaseName(databaseName?.applyValue({ args0 -> args0 }))
        .deltaTargets(
            deltaTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .description(description?.applyValue({ args0 -> args0 }))
        .dynamodbTargets(
            dynamodbTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .hudiTargets(
            hudiTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .icebergTargets(
            icebergTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .jdbcTargets(
            jdbcTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .lakeFormationConfiguration(
            lakeFormationConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .lineageConfiguration(
            lineageConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .mongodbTargets(
            mongodbTargets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .recrawlPolicy(recrawlPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .role(role?.applyValue({ args0 -> args0 }))
        .s3Targets(
            s3Targets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .schedule(schedule?.applyValue({ args0 -> args0 }))
        .schemaChangePolicy(
            schemaChangePolicy?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .securityConfiguration(securityConfiguration?.applyValue({ args0 -> args0 }))
        .tablePrefix(tablePrefix?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [CrawlerArgs].
 */
@PulumiTagMarker
public class CrawlerArgsBuilder internal constructor() {
    private var catalogTargets: Output<List<CrawlerCatalogTargetArgs>>? = null

    private var classifiers: Output<List<String>>? = null

    private var configuration: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var deltaTargets: Output<List<CrawlerDeltaTargetArgs>>? = null

    private var description: Output<String>? = null

    private var dynamodbTargets: Output<List<CrawlerDynamodbTargetArgs>>? = null

    private var hudiTargets: Output<List<CrawlerHudiTargetArgs>>? = null

    private var icebergTargets: Output<List<CrawlerIcebergTargetArgs>>? = null

    private var jdbcTargets: Output<List<CrawlerJdbcTargetArgs>>? = null

    private var lakeFormationConfiguration: Output<CrawlerLakeFormationConfigurationArgs>? = null

    private var lineageConfiguration: Output<CrawlerLineageConfigurationArgs>? = null

    private var mongodbTargets: Output<List<CrawlerMongodbTargetArgs>>? = null

    private var name: Output<String>? = null

    private var recrawlPolicy: Output<CrawlerRecrawlPolicyArgs>? = null

    private var role: Output<String>? = null

    private var s3Targets: Output<List<CrawlerS3TargetArgs>>? = null

    private var schedule: Output<String>? = null

    private var schemaChangePolicy: Output<CrawlerSchemaChangePolicyArgs>? = null

    private var securityConfiguration: Output<String>? = null

    private var tablePrefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("myreuhmboarxffne")
    public suspend fun catalogTargets(`value`: Output<List<CrawlerCatalogTargetArgs>>) {
        this.catalogTargets = value
    }

    @JvmName("crieosfjjjyvbbqs")
    public suspend fun catalogTargets(vararg values: Output<CrawlerCatalogTargetArgs>) {
        this.catalogTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("ebttisopqrykfqpf")
    public suspend fun catalogTargets(values: List<Output<CrawlerCatalogTargetArgs>>) {
        this.catalogTargets = Output.all(values)
    }

    /**
     * @param value List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("xwdosoxabndkmrsa")
    public suspend fun classifiers(`value`: Output<List<String>>) {
        this.classifiers = value
    }

    @JvmName("jqdhhfxohpjwhuho")
    public suspend fun classifiers(vararg values: Output<String>) {
        this.classifiers = Output.all(values.asList())
    }

    /**
     * @param values List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("gsrbuynlppscjhqt")
    public suspend fun classifiers(values: List<Output<String>>) {
        this.classifiers = Output.all(values)
    }

    /**
     * @param value JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
     */
    @JvmName("camvaakkqxykdspy")
    public suspend fun configuration(`value`: Output<String>) {
        this.configuration = value
    }

    /**
     * @param value Glue database where results are written.
     */
    @JvmName("sbvesinwtwlhgudr")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("sgephuntgrdraxgr")
    public suspend fun deltaTargets(`value`: Output<List<CrawlerDeltaTargetArgs>>) {
        this.deltaTargets = value
    }

    @JvmName("kbyonxbvnpowycsb")
    public suspend fun deltaTargets(vararg values: Output<CrawlerDeltaTargetArgs>) {
        this.deltaTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("tmsmytqmnehkjslm")
    public suspend fun deltaTargets(values: List<Output<CrawlerDeltaTargetArgs>>) {
        this.deltaTargets = Output.all(values)
    }

    /**
     * @param value Description of the crawler.
     */
    @JvmName("hkkhlkhjoapibgdk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("grbwxfdxexrochlj")
    public suspend fun dynamodbTargets(`value`: Output<List<CrawlerDynamodbTargetArgs>>) {
        this.dynamodbTargets = value
    }

    @JvmName("hcswptvfkudcdptk")
    public suspend fun dynamodbTargets(vararg values: Output<CrawlerDynamodbTargetArgs>) {
        this.dynamodbTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("gpbmhhqiklyuybou")
    public suspend fun dynamodbTargets(values: List<Output<CrawlerDynamodbTargetArgs>>) {
        this.dynamodbTargets = Output.all(values)
    }

    /**
     * @param value List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("ehajwivrbdeilcxy")
    public suspend fun hudiTargets(`value`: Output<List<CrawlerHudiTargetArgs>>) {
        this.hudiTargets = value
    }

    @JvmName("ksxperiseoxetwuh")
    public suspend fun hudiTargets(vararg values: Output<CrawlerHudiTargetArgs>) {
        this.hudiTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("dldtnirjxgqqqakv")
    public suspend fun hudiTargets(values: List<Output<CrawlerHudiTargetArgs>>) {
        this.hudiTargets = Output.all(values)
    }

    /**
     * @param value List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("hvynhisrmbqsnxek")
    public suspend fun icebergTargets(`value`: Output<List<CrawlerIcebergTargetArgs>>) {
        this.icebergTargets = value
    }

    @JvmName("cqtljsgebinwldou")
    public suspend fun icebergTargets(vararg values: Output<CrawlerIcebergTargetArgs>) {
        this.icebergTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("utvqvdslibjvmxka")
    public suspend fun icebergTargets(values: List<Output<CrawlerIcebergTargetArgs>>) {
        this.icebergTargets = Output.all(values)
    }

    /**
     * @param value List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("afwfmvykyvaohwyo")
    public suspend fun jdbcTargets(`value`: Output<List<CrawlerJdbcTargetArgs>>) {
        this.jdbcTargets = value
    }

    @JvmName("xmyytldfxpkdcord")
    public suspend fun jdbcTargets(vararg values: Output<CrawlerJdbcTargetArgs>) {
        this.jdbcTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("ngvikxkblglsrksd")
    public suspend fun jdbcTargets(values: List<Output<CrawlerJdbcTargetArgs>>) {
        this.jdbcTargets = Output.all(values)
    }

    /**
     * @param value Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
     */
    @JvmName("qrxoewkjajjpqrpq")
    public suspend fun lakeFormationConfiguration(`value`: Output<CrawlerLakeFormationConfigurationArgs>) {
        this.lakeFormationConfiguration = value
    }

    /**
     * @param value Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
     */
    @JvmName("pbfiyxolppwsghdm")
    public suspend fun lineageConfiguration(`value`: Output<CrawlerLineageConfigurationArgs>) {
        this.lineageConfiguration = value
    }

    /**
     * @param value List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("yieckbfsyqwkohld")
    public suspend fun mongodbTargets(`value`: Output<List<CrawlerMongodbTargetArgs>>) {
        this.mongodbTargets = value
    }

    @JvmName("bhlrrjepkxlchnui")
    public suspend fun mongodbTargets(vararg values: Output<CrawlerMongodbTargetArgs>) {
        this.mongodbTargets = Output.all(values.asList())
    }

    /**
     * @param values List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("rlhcdbokbclyhcuv")
    public suspend fun mongodbTargets(values: List<Output<CrawlerMongodbTargetArgs>>) {
        this.mongodbTargets = Output.all(values)
    }

    /**
     * @param value Name of the crawler.
     */
    @JvmName("xyqwywngqasyuhpb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
     */
    @JvmName("bsoaiohnnwrbefvg")
    public suspend fun recrawlPolicy(`value`: Output<CrawlerRecrawlPolicyArgs>) {
        this.recrawlPolicy = value
    }

    /**
     * @param value The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
     */
    @JvmName("nlejyoultjdpykge")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("hnaklfbsjgajrxql")
    public suspend fun s3Targets(`value`: Output<List<CrawlerS3TargetArgs>>) {
        this.s3Targets = value
    }

    @JvmName("oisqovuwmuipjgug")
    public suspend fun s3Targets(vararg values: Output<CrawlerS3TargetArgs>) {
        this.s3Targets = Output.all(values.asList())
    }

    /**
     * @param values List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("axripyisvtcapcnc")
    public suspend fun s3Targets(values: List<Output<CrawlerS3TargetArgs>>) {
        this.s3Targets = Output.all(values)
    }

    /**
     * @param value A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
     */
    @JvmName("lwpiylarmkbdfdbs")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
     */
    @JvmName("vkxenbipbcmnxsod")
    public suspend fun schemaChangePolicy(`value`: Output<CrawlerSchemaChangePolicyArgs>) {
        this.schemaChangePolicy = value
    }

    /**
     * @param value The name of Security Configuration to be used by the crawler
     */
    @JvmName("gpkkjhnhljujjrfo")
    public suspend fun securityConfiguration(`value`: Output<String>) {
        this.securityConfiguration = value
    }

    /**
     * @param value The table prefix used for catalog tables that are created.
     */
    @JvmName("vhjojerertyihabn")
    public suspend fun tablePrefix(`value`: Output<String>) {
        this.tablePrefix = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lkmqgcjnikotrawo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("bcfyxmjifoifnrur")
    public suspend fun catalogTargets(`value`: List<CrawlerCatalogTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogTargets = mapped
    }

    /**
     * @param argument List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("auomafsawsjtahxv")
    public suspend fun catalogTargets(argument: List<suspend CrawlerCatalogTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerCatalogTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.catalogTargets = mapped
    }

    /**
     * @param argument List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("ffntrtlyvycsilxi")
    public suspend fun catalogTargets(vararg argument: suspend CrawlerCatalogTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerCatalogTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.catalogTargets = mapped
    }

    /**
     * @param argument List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("ryqgciqdnrbnytph")
    public suspend fun catalogTargets(argument: suspend CrawlerCatalogTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerCatalogTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.catalogTargets = mapped
    }

    /**
     * @param values List of nested AWS Glue Data Catalog target arguments. See Catalog Target below.
     */
    @JvmName("qaakfwelyghplxnc")
    public suspend fun catalogTargets(vararg values: CrawlerCatalogTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogTargets = mapped
    }

    /**
     * @param value List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("kqqkeyiynarneqiy")
    public suspend fun classifiers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.classifiers = mapped
    }

    /**
     * @param values List of custom classifiers. By default, all AWS classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.
     */
    @JvmName("cksiwnwngjyfewqm")
    public suspend fun classifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classifiers = mapped
    }

    /**
     * @param value JSON string of configuration information. For more details see [Setting Crawler Configuration Options](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
     */
    @JvmName("xcwepeksprwvtgdy")
    public suspend fun configuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value Glue database where results are written.
     */
    @JvmName("qjcbjtpohwxhxccy")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("tkgpfuvigifqnfbp")
    public suspend fun deltaTargets(`value`: List<CrawlerDeltaTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deltaTargets = mapped
    }

    /**
     * @param argument List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("rvxtnurkgwiddmbx")
    public suspend fun deltaTargets(argument: List<suspend CrawlerDeltaTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerDeltaTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.deltaTargets = mapped
    }

    /**
     * @param argument List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("nuonbpkvjfugguuf")
    public suspend fun deltaTargets(vararg argument: suspend CrawlerDeltaTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerDeltaTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.deltaTargets = mapped
    }

    /**
     * @param argument List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("tcisjkdevgxrfmjy")
    public suspend fun deltaTargets(argument: suspend CrawlerDeltaTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerDeltaTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.deltaTargets = mapped
    }

    /**
     * @param values List of nested Delta Lake target arguments. See Delta Target below.
     */
    @JvmName("ovoxdxpbfngbcran")
    public suspend fun deltaTargets(vararg values: CrawlerDeltaTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deltaTargets = mapped
    }

    /**
     * @param value Description of the crawler.
     */
    @JvmName("lpuhqabddwgdjuhy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("pjicsteryqyelbxi")
    public suspend fun dynamodbTargets(`value`: List<CrawlerDynamodbTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamodbTargets = mapped
    }

    /**
     * @param argument List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("gnhjmnrfgwudccmv")
    public suspend fun dynamodbTargets(argument: List<suspend CrawlerDynamodbTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerDynamodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbTargets = mapped
    }

    /**
     * @param argument List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("mpchwnrjuyjdjqqp")
    public suspend fun dynamodbTargets(vararg argument: suspend CrawlerDynamodbTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerDynamodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dynamodbTargets = mapped
    }

    /**
     * @param argument List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("kauxevwbcnalyybm")
    public suspend fun dynamodbTargets(argument: suspend CrawlerDynamodbTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerDynamodbTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dynamodbTargets = mapped
    }

    /**
     * @param values List of nested DynamoDB target arguments. See Dynamodb Target below.
     */
    @JvmName("bqcpptwgfxuqnuoq")
    public suspend fun dynamodbTargets(vararg values: CrawlerDynamodbTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamodbTargets = mapped
    }

    /**
     * @param value List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("roxmrlabnclmejgn")
    public suspend fun hudiTargets(`value`: List<CrawlerHudiTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hudiTargets = mapped
    }

    /**
     * @param argument List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("xyartmewfgbwhdhr")
    public suspend fun hudiTargets(argument: List<suspend CrawlerHudiTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerHudiTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hudiTargets = mapped
    }

    /**
     * @param argument List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("aglxhsgtuofogtmy")
    public suspend fun hudiTargets(vararg argument: suspend CrawlerHudiTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerHudiTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hudiTargets = mapped
    }

    /**
     * @param argument List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("gcrvwmribdmcoxoj")
    public suspend fun hudiTargets(argument: suspend CrawlerHudiTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerHudiTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.hudiTargets = mapped
    }

    /**
     * @param values List of nested Hudi target arguments. See Iceberg Target below.
     */
    @JvmName("yabwqubhagftybvx")
    public suspend fun hudiTargets(vararg values: CrawlerHudiTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hudiTargets = mapped
    }

    /**
     * @param value List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("gmxbojkhfwvqguyi")
    public suspend fun icebergTargets(`value`: List<CrawlerIcebergTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icebergTargets = mapped
    }

    /**
     * @param argument List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("mmumhxqstkwjahkj")
    public suspend fun icebergTargets(argument: List<suspend CrawlerIcebergTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerIcebergTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.icebergTargets = mapped
    }

    /**
     * @param argument List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("gqgbkvoqtdwccfax")
    public suspend fun icebergTargets(vararg argument: suspend CrawlerIcebergTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerIcebergTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.icebergTargets = mapped
    }

    /**
     * @param argument List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("fhkbggptpilmaddi")
    public suspend fun icebergTargets(argument: suspend CrawlerIcebergTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerIcebergTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.icebergTargets = mapped
    }

    /**
     * @param values List of nested Iceberg target arguments. See Iceberg Target below.
     */
    @JvmName("sabdgavtnpuadaln")
    public suspend fun icebergTargets(vararg values: CrawlerIcebergTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.icebergTargets = mapped
    }

    /**
     * @param value List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("catpqbiafuxcmalr")
    public suspend fun jdbcTargets(`value`: List<CrawlerJdbcTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jdbcTargets = mapped
    }

    /**
     * @param argument List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("mmcmiujnnkkaxrfb")
    public suspend fun jdbcTargets(argument: List<suspend CrawlerJdbcTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerJdbcTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jdbcTargets = mapped
    }

    /**
     * @param argument List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("utxrclwdvelrdypm")
    public suspend fun jdbcTargets(vararg argument: suspend CrawlerJdbcTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerJdbcTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.jdbcTargets = mapped
    }

    /**
     * @param argument List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("iitgbhxlwpwtiaks")
    public suspend fun jdbcTargets(argument: suspend CrawlerJdbcTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerJdbcTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.jdbcTargets = mapped
    }

    /**
     * @param values List of nested JDBC target arguments. See JDBC Target below.
     */
    @JvmName("gukubqcuqurcpegb")
    public suspend fun jdbcTargets(vararg values: CrawlerJdbcTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jdbcTargets = mapped
    }

    /**
     * @param value Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
     */
    @JvmName("retkihquiuwwigpt")
    public suspend fun lakeFormationConfiguration(`value`: CrawlerLakeFormationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lakeFormationConfiguration = mapped
    }

    /**
     * @param argument Specifies Lake Formation configuration settings for the crawler. See Lake Formation Configuration below.
     */
    @JvmName("qdfnnwsjmuyygbvi")
    public suspend fun lakeFormationConfiguration(argument: suspend CrawlerLakeFormationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerLakeFormationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lakeFormationConfiguration = mapped
    }

    /**
     * @param value Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
     */
    @JvmName("wcawhrkkfinjliss")
    public suspend fun lineageConfiguration(`value`: CrawlerLineageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lineageConfiguration = mapped
    }

    /**
     * @param argument Specifies data lineage configuration settings for the crawler. See Lineage Configuration below.
     */
    @JvmName("efecwfmsbapqbsai")
    public suspend fun lineageConfiguration(argument: suspend CrawlerLineageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerLineageConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lineageConfiguration = mapped
    }

    /**
     * @param value List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("tlkreuwucwkclbos")
    public suspend fun mongodbTargets(`value`: List<CrawlerMongodbTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongodbTargets = mapped
    }

    /**
     * @param argument List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("woesxmbehltjeyxo")
    public suspend fun mongodbTargets(argument: List<suspend CrawlerMongodbTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerMongodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mongodbTargets = mapped
    }

    /**
     * @param argument List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("ilamsbbqjyatmvau")
    public suspend fun mongodbTargets(vararg argument: suspend CrawlerMongodbTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerMongodbTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mongodbTargets = mapped
    }

    /**
     * @param argument List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("nmenjgrpueaudaft")
    public suspend fun mongodbTargets(argument: suspend CrawlerMongodbTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerMongodbTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mongodbTargets = mapped
    }

    /**
     * @param values List of nested MongoDB target arguments. See MongoDB Target below.
     */
    @JvmName("isubrgkrodajtkkc")
    public suspend fun mongodbTargets(vararg values: CrawlerMongodbTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mongodbTargets = mapped
    }

    /**
     * @param value Name of the crawler.
     */
    @JvmName("hyqdostvpfnhqiji")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
     */
    @JvmName("bqbghgukwkktklmi")
    public suspend fun recrawlPolicy(`value`: CrawlerRecrawlPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recrawlPolicy = mapped
    }

    /**
     * @param argument A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.. See Recrawl Policy below.
     */
    @JvmName("etgqnebppvhusyvj")
    public suspend fun recrawlPolicy(argument: suspend CrawlerRecrawlPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerRecrawlPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recrawlPolicy = mapped
    }

    /**
     * @param value The IAM role friendly name (including path without leading slash), or ARN of an IAM role, used by the crawler to access other resources.
     */
    @JvmName("haoekkrdxsttawtt")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("gbwyeklqkuhlmbro")
    public suspend fun s3Targets(`value`: List<CrawlerS3TargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Targets = mapped
    }

    /**
     * @param argument List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("kshxwkrupfrgwbge")
    public suspend fun s3Targets(argument: List<suspend CrawlerS3TargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CrawlerS3TargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Targets = mapped
    }

    /**
     * @param argument List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("otkmlbcwcjqiblpo")
    public suspend fun s3Targets(vararg argument: suspend CrawlerS3TargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CrawlerS3TargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.s3Targets = mapped
    }

    /**
     * @param argument List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("djdvjcxbfkfyhvsl")
    public suspend fun s3Targets(argument: suspend CrawlerS3TargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CrawlerS3TargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.s3Targets = mapped
    }

    /**
     * @param values List of nested Amazon S3 target arguments. See S3 Target below.
     */
    @JvmName("kodmadswjaqylmek")
    public suspend fun s3Targets(vararg values: CrawlerS3TargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Targets = mapped
    }

    /**
     * @param value A cron expression used to specify the schedule. For more information, see [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html). For example, to run something every day at 12:15 UTC, you would specify: `cron(15 12 * * ? *)`.
     */
    @JvmName("pmnndbiabooffnss")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
     */
    @JvmName("nwhfcntrgjqgvnca")
    public suspend fun schemaChangePolicy(`value`: CrawlerSchemaChangePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaChangePolicy = mapped
    }

    /**
     * @param argument Policy for the crawler's update and deletion behavior. See Schema Change Policy below.
     */
    @JvmName("cytuigwhxryodrcg")
    public suspend fun schemaChangePolicy(argument: suspend CrawlerSchemaChangePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = CrawlerSchemaChangePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schemaChangePolicy = mapped
    }

    /**
     * @param value The name of Security Configuration to be used by the crawler
     */
    @JvmName("jcayuvfjligewsky")
    public suspend fun securityConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfiguration = mapped
    }

    /**
     * @param value The table prefix used for catalog tables that are created.
     */
    @JvmName("vqdqgqgosntweedp")
    public suspend fun tablePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablePrefix = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ujagmrxhlnycedly")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mpnkiiggloooxtwg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CrawlerArgs = CrawlerArgs(
        catalogTargets = catalogTargets,
        classifiers = classifiers,
        configuration = configuration,
        databaseName = databaseName,
        deltaTargets = deltaTargets,
        description = description,
        dynamodbTargets = dynamodbTargets,
        hudiTargets = hudiTargets,
        icebergTargets = icebergTargets,
        jdbcTargets = jdbcTargets,
        lakeFormationConfiguration = lakeFormationConfiguration,
        lineageConfiguration = lineageConfiguration,
        mongodbTargets = mongodbTargets,
        name = name,
        recrawlPolicy = recrawlPolicy,
        role = role,
        s3Targets = s3Targets,
        schedule = schedule,
        schemaChangePolicy = schemaChangePolicy,
        securityConfiguration = securityConfiguration,
        tablePrefix = tablePrefix,
        tags = tags,
    )
}
