@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettings
import com.pulumi.aws.glue.kotlin.outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataCatalogEncryptionSettings].
 */
@PulumiTagMarker
public class DataCatalogEncryptionSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataCatalogEncryptionSettingsArgs = DataCatalogEncryptionSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataCatalogEncryptionSettingsArgsBuilder.() -> Unit) {
        val builder = DataCatalogEncryptionSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataCatalogEncryptionSettings {
        val builtJavaResource =
            com.pulumi.aws.glue.DataCatalogEncryptionSettings(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataCatalogEncryptionSettings(builtJavaResource)
    }
}

/**
 * Provides a Glue Data Catalog Encryption Settings resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.DataCatalogEncryptionSettings("example", {dataCatalogEncryptionSettings: {
 *     connectionPasswordEncryption: {
 *         awsKmsKeyId: test.arn,
 *         returnConnectionPasswordEncrypted: true,
 *     },
 *     encryptionAtRest: {
 *         catalogEncryptionMode: "SSE-KMS",
 *         catalogEncryptionServiceRole: role.test.arn,
 *         sseAwsKmsKeyId: test.arn,
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.DataCatalogEncryptionSettings("example", data_catalog_encryption_settings={
 *     "connection_password_encryption": {
 *         "aws_kms_key_id": test["arn"],
 *         "return_connection_password_encrypted": True,
 *     },
 *     "encryption_at_rest": {
 *         "catalog_encryption_mode": "SSE-KMS",
 *         "catalog_encryption_service_role": role["test"]["arn"],
 *         "sse_aws_kms_key_id": test["arn"],
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.DataCatalogEncryptionSettings("example", new()
 *     {
 *         DataCatalogEncryptionSettingsConfig = new Aws.Glue.Inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs
 *         {
 *             ConnectionPasswordEncryption = new Aws.Glue.Inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs
 *             {
 *                 AwsKmsKeyId = test.Arn,
 *                 ReturnConnectionPasswordEncrypted = true,
 *             },
 *             EncryptionAtRest = new Aws.Glue.Inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs
 *             {
 *                 CatalogEncryptionMode = "SSE-KMS",
 *                 CatalogEncryptionServiceRole = role.Test.Arn,
 *                 SseAwsKmsKeyId = test.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewDataCatalogEncryptionSettings(ctx, "example", &glue.DataCatalogEncryptionSettingsArgs{
 * 			DataCatalogEncryptionSettings: &glue.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs{
 * 				ConnectionPasswordEncryption: &glue.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs{
 * 					AwsKmsKeyId:                       pulumi.Any(test.Arn),
 * 					ReturnConnectionPasswordEncrypted: pulumi.Bool(true),
 * 				},
 * 				EncryptionAtRest: &glue.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs{
 * 					CatalogEncryptionMode:        pulumi.String("SSE-KMS"),
 * 					CatalogEncryptionServiceRole: pulumi.Any(role.Test.Arn),
 * 					SseAwsKmsKeyId:               pulumi.Any(test.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataCatalogEncryptionSettings;
 * import com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCatalogEncryptionSettings("example", DataCatalogEncryptionSettingsArgs.builder()
 *             .dataCatalogEncryptionSettings(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs.builder()
 *                 .connectionPasswordEncryption(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs.builder()
 *                     .awsKmsKeyId(test.arn())
 *                     .returnConnectionPasswordEncrypted(true)
 *                     .build())
 *                 .encryptionAtRest(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs.builder()
 *                     .catalogEncryptionMode("SSE-KMS")
 *                     .catalogEncryptionServiceRole(role.test().arn())
 *                     .sseAwsKmsKeyId(test.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:DataCatalogEncryptionSettings
 *     properties:
 *       dataCatalogEncryptionSettings:
 *         connectionPasswordEncryption:
 *           awsKmsKeyId: ${test.arn}
 *           returnConnectionPasswordEncrypted: true
 *         encryptionAtRest:
 *           catalogEncryptionMode: SSE-KMS
 *           catalogEncryptionServiceRole: ${role.test.arn}
 *           sseAwsKmsKeyId: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Data Catalog Encryption Settings using `CATALOG-ID` (AWS account ID if not custom). For example:
 * ```sh
 * $ pulumi import aws:glue/dataCatalogEncryptionSettings:DataCatalogEncryptionSettings example 123456789012
 * ```
 */
public class DataCatalogEncryptionSettings internal constructor(
    override val javaResource: com.pulumi.aws.glue.DataCatalogEncryptionSettings,
) : KotlinCustomResource(javaResource, DataCatalogEncryptionSettingsMapper) {
    /**
     * The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * The security configuration to set. see Data Catalog Encryption Settings.
     */
    public val dataCatalogEncryptionSettings:
        Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettings>
        get() = javaResource.dataCatalogEncryptionSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object DataCatalogEncryptionSettingsMapper : ResourceMapper<DataCatalogEncryptionSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.DataCatalogEncryptionSettings::class == javaResource::class

    override fun map(javaResource: Resource): DataCatalogEncryptionSettings =
        DataCatalogEncryptionSettings(
            javaResource as
                com.pulumi.aws.glue.DataCatalogEncryptionSettings,
        )
}

/**
 * @see [DataCatalogEncryptionSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataCatalogEncryptionSettings].
 */
public suspend fun dataCatalogEncryptionSettings(
    name: String,
    block: suspend DataCatalogEncryptionSettingsResourceBuilder.() -> Unit,
): DataCatalogEncryptionSettings {
    val builder = DataCatalogEncryptionSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataCatalogEncryptionSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataCatalogEncryptionSettings(name: String): DataCatalogEncryptionSettings {
    val builder = DataCatalogEncryptionSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
