@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs
import com.pulumi.aws.glue.kotlin.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Glue Data Catalog Encryption Settings resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.DataCatalogEncryptionSettings("example", {dataCatalogEncryptionSettings: {
 *     connectionPasswordEncryption: {
 *         awsKmsKeyId: test.arn,
 *         returnConnectionPasswordEncrypted: true,
 *     },
 *     encryptionAtRest: {
 *         catalogEncryptionMode: "SSE-KMS",
 *         catalogEncryptionServiceRole: role.test.arn,
 *         sseAwsKmsKeyId: test.arn,
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.DataCatalogEncryptionSettings("example", data_catalog_encryption_settings={
 *     "connection_password_encryption": {
 *         "aws_kms_key_id": test["arn"],
 *         "return_connection_password_encrypted": True,
 *     },
 *     "encryption_at_rest": {
 *         "catalog_encryption_mode": "SSE-KMS",
 *         "catalog_encryption_service_role": role["test"]["arn"],
 *         "sse_aws_kms_key_id": test["arn"],
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.DataCatalogEncryptionSettings("example", new()
 *     {
 *         DataCatalogEncryptionSettingsConfig = new Aws.Glue.Inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs
 *         {
 *             ConnectionPasswordEncryption = new Aws.Glue.Inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs
 *             {
 *                 AwsKmsKeyId = test.Arn,
 *                 ReturnConnectionPasswordEncrypted = true,
 *             },
 *             EncryptionAtRest = new Aws.Glue.Inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs
 *             {
 *                 CatalogEncryptionMode = "SSE-KMS",
 *                 CatalogEncryptionServiceRole = role.Test.Arn,
 *                 SseAwsKmsKeyId = test.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewDataCatalogEncryptionSettings(ctx, "example", &glue.DataCatalogEncryptionSettingsArgs{
 * 			DataCatalogEncryptionSettings: &glue.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs{
 * 				ConnectionPasswordEncryption: &glue.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs{
 * 					AwsKmsKeyId:                       pulumi.Any(test.Arn),
 * 					ReturnConnectionPasswordEncrypted: pulumi.Bool(true),
 * 				},
 * 				EncryptionAtRest: &glue.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs{
 * 					CatalogEncryptionMode:        pulumi.String("SSE-KMS"),
 * 					CatalogEncryptionServiceRole: pulumi.Any(role.Test.Arn),
 * 					SseAwsKmsKeyId:               pulumi.Any(test.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataCatalogEncryptionSettings;
 * import com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCatalogEncryptionSettings("example", DataCatalogEncryptionSettingsArgs.builder()
 *             .dataCatalogEncryptionSettings(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs.builder()
 *                 .connectionPasswordEncryption(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsConnectionPasswordEncryptionArgs.builder()
 *                     .awsKmsKeyId(test.arn())
 *                     .returnConnectionPasswordEncrypted(true)
 *                     .build())
 *                 .encryptionAtRest(DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs.builder()
 *                     .catalogEncryptionMode("SSE-KMS")
 *                     .catalogEncryptionServiceRole(role.test().arn())
 *                     .sseAwsKmsKeyId(test.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:DataCatalogEncryptionSettings
 *     properties:
 *       dataCatalogEncryptionSettings:
 *         connectionPasswordEncryption:
 *           awsKmsKeyId: ${test.arn}
 *           returnConnectionPasswordEncrypted: true
 *         encryptionAtRest:
 *           catalogEncryptionMode: SSE-KMS
 *           catalogEncryptionServiceRole: ${role.test.arn}
 *           sseAwsKmsKeyId: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Data Catalog Encryption Settings using `CATALOG-ID` (AWS account ID if not custom). For example:
 * ```sh
 * $ pulumi import aws:glue/dataCatalogEncryptionSettings:DataCatalogEncryptionSettings example 123456789012
 * ```
 * @property catalogId The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
 * @property dataCatalogEncryptionSettings The security configuration to set. see Data Catalog Encryption Settings.
 */
public data class DataCatalogEncryptionSettingsArgs(
    public val catalogId: Output<String>? = null,
    public val dataCatalogEncryptionSettings: Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs> {
    override fun toJava(): com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs =
        com.pulumi.aws.glue.DataCatalogEncryptionSettingsArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .dataCatalogEncryptionSettings(
                dataCatalogEncryptionSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [DataCatalogEncryptionSettingsArgs].
 */
@PulumiTagMarker
public class DataCatalogEncryptionSettingsArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var dataCatalogEncryptionSettings:
        Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs>? = null

    /**
     * @param value The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
     */
    @JvmName("jxrfixfginfupynq")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value The security configuration to set. see Data Catalog Encryption Settings.
     */
    @JvmName("vinwpcjuxcerkbdu")
    public suspend fun dataCatalogEncryptionSettings(`value`: Output<DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs>) {
        this.dataCatalogEncryptionSettings = value
    }

    /**
     * @param value The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
     */
    @JvmName("bqdjkjaascfyrthq")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value The security configuration to set. see Data Catalog Encryption Settings.
     */
    @JvmName("bmmgbjeuigassbdc")
    public suspend fun dataCatalogEncryptionSettings(`value`: DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCatalogEncryptionSettings = mapped
    }

    /**
     * @param argument The security configuration to set. see Data Catalog Encryption Settings.
     */
    @JvmName("jrqfvforwuukvcxf")
    public suspend fun dataCatalogEncryptionSettings(argument: suspend DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataCatalogEncryptionSettings = mapped
    }

    internal fun build(): DataCatalogEncryptionSettingsArgs = DataCatalogEncryptionSettingsArgs(
        catalogId = catalogId,
        dataCatalogEncryptionSettings = dataCatalogEncryptionSettings,
    )
}
