@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.DataQualityRulesetArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.DataQualityRulesetTargetTableArgs
import com.pulumi.aws.glue.kotlin.inputs.DataQualityRulesetTargetTableArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Data Quality Ruleset Resource. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/glue-data-quality.html) for a full explanation of the Glue Data Quality Ruleset functionality
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.DataQualityRuleset("example", {
 *     name: "example",
 *     ruleset: "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.DataQualityRuleset("example",
 *     name="example",
 *     ruleset="Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.DataQualityRuleset("example", new()
 *     {
 *         Name = "example",
 *         Ruleset = "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewDataQualityRuleset(ctx, "example", &glue.DataQualityRulesetArgs{
 * 			Name:    pulumi.String("example"),
 * 			Ruleset: pulumi.String("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .name("example")
 *             .ruleset("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:DataQualityRuleset
 *     properties:
 *       name: example
 *       ruleset: Rules = [Completeness "colA" between 0&#46;4 and 0&#46;8]
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With description
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.DataQualityRuleset("example", {
 *     name: "example",
 *     description: "example",
 *     ruleset: "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.DataQualityRuleset("example",
 *     name="example",
 *     description="example",
 *     ruleset="Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.DataQualityRuleset("example", new()
 *     {
 *         Name = "example",
 *         Description = "example",
 *         Ruleset = "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewDataQualityRuleset(ctx, "example", &glue.DataQualityRulesetArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("example"),
 * 			Ruleset:     pulumi.String("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .name("example")
 *             .description("example")
 *             .ruleset("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:DataQualityRuleset
 *     properties:
 *       name: example
 *       description: example
 *       ruleset: Rules = [Completeness "colA" between 0&#46;4 and 0&#46;8]
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.DataQualityRuleset("example", {
 *     name: "example",
 *     ruleset: "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *     tags: {
 *         hello: "world",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.DataQualityRuleset("example",
 *     name="example",
 *     ruleset="Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *     tags={
 *         "hello": "world",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.DataQualityRuleset("example", new()
 *     {
 *         Name = "example",
 *         Ruleset = "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *         Tags =
 *         {
 *             { "hello", "world" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewDataQualityRuleset(ctx, "example", &glue.DataQualityRulesetArgs{
 * 			Name:    pulumi.String("example"),
 * 			Ruleset: pulumi.String("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]"),
 * 			Tags: pulumi.StringMap{
 * 				"hello": pulumi.String("world"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .name("example")
 *             .ruleset("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]")
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:DataQualityRuleset
 *     properties:
 *       name: example
 *       ruleset: Rules = [Completeness "colA" between 0&#46;4 and 0&#46;8]
 *       tags:
 *         hello: world
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With target_table
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.DataQualityRuleset("example", {
 *     name: "example",
 *     ruleset: "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *     targetTable: {
 *         databaseName: exampleAwsGlueCatalogDatabase.name,
 *         tableName: exampleAwsGlueCatalogTable.name,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.DataQualityRuleset("example",
 *     name="example",
 *     ruleset="Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *     target_table={
 *         "database_name": example_aws_glue_catalog_database["name"],
 *         "table_name": example_aws_glue_catalog_table["name"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.DataQualityRuleset("example", new()
 *     {
 *         Name = "example",
 *         Ruleset = "Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]",
 *         TargetTable = new Aws.Glue.Inputs.DataQualityRulesetTargetTableArgs
 *         {
 *             DatabaseName = exampleAwsGlueCatalogDatabase.Name,
 *             TableName = exampleAwsGlueCatalogTable.Name,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewDataQualityRuleset(ctx, "example", &glue.DataQualityRulesetArgs{
 * 			Name:    pulumi.String("example"),
 * 			Ruleset: pulumi.String("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]"),
 * 			TargetTable: &glue.DataQualityRulesetTargetTableArgs{
 * 				DatabaseName: pulumi.Any(exampleAwsGlueCatalogDatabase.Name),
 * 				TableName:    pulumi.Any(exampleAwsGlueCatalogTable.Name),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.DataQualityRuleset;
 * import com.pulumi.aws.glue.DataQualityRulesetArgs;
 * import com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataQualityRuleset("example", DataQualityRulesetArgs.builder()
 *             .name("example")
 *             .ruleset("Rules = [Completeness \"colA\" between 0&#46;4 and 0&#46;8]")
 *             .targetTable(DataQualityRulesetTargetTableArgs.builder()
 *                 .databaseName(exampleAwsGlueCatalogDatabase.name())
 *                 .tableName(exampleAwsGlueCatalogTable.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:DataQualityRuleset
 *     properties:
 *       name: example
 *       ruleset: Rules = [Completeness "colA" between 0&#46;4 and 0&#46;8]
 *       targetTable:
 *         databaseName: ${exampleAwsGlueCatalogDatabase.name}
 *         tableName: ${exampleAwsGlueCatalogTable.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Data Quality Ruleset using the `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/dataQualityRuleset:DataQualityRuleset example exampleName
 * ```
 * @property description Description of the data quality ruleset.
 * @property name Name of the data quality ruleset.
 * @property ruleset A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetTable A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
 */
public data class DataQualityRulesetArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ruleset: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetTable: Output<DataQualityRulesetTargetTableArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.DataQualityRulesetArgs> {
    override fun toJava(): com.pulumi.aws.glue.DataQualityRulesetArgs =
        com.pulumi.aws.glue.DataQualityRulesetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleset(ruleset?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetTable(targetTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataQualityRulesetArgs].
 */
@PulumiTagMarker
public class DataQualityRulesetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var ruleset: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetTable: Output<DataQualityRulesetTargetTableArgs>? = null

    /**
     * @param value Description of the data quality ruleset.
     */
    @JvmName("ldrsjkqobrpfycnw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the data quality ruleset.
     */
    @JvmName("btihdtkmdvtvvsmn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
     */
    @JvmName("dandxfrlbileopdu")
    public suspend fun ruleset(`value`: Output<String>) {
        this.ruleset = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ojqqxomvmpbjisrs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     */
    @JvmName("urlsmlulotmuhrxo")
    public suspend fun targetTable(`value`: Output<DataQualityRulesetTargetTableArgs>) {
        this.targetTable = value
    }

    /**
     * @param value Description of the data quality ruleset.
     */
    @JvmName("onjtnapesoxchjdu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the data quality ruleset.
     */
    @JvmName("jgfsxnbeacvsdvaf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
     */
    @JvmName("jstxpbwbdnnhkagi")
    public suspend fun ruleset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleset = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cjqscvyyrrpsfpaw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jqqduvyrvsivakbt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     */
    @JvmName("hjogqwbcuifitbmt")
    public suspend fun targetTable(`value`: DataQualityRulesetTargetTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTable = mapped
    }

    /**
     * @param argument A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
     */
    @JvmName("yjynvedbotpflddi")
    public suspend fun targetTable(argument: suspend DataQualityRulesetTargetTableArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityRulesetTargetTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetTable = mapped
    }

    internal fun build(): DataQualityRulesetArgs = DataQualityRulesetArgs(
        description = description,
        name = name,
        ruleset = ruleset,
        tags = tags,
        targetTable = targetTable,
    )
}
