@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DevEndpoint].
 */
@PulumiTagMarker
public class DevEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevEndpointArgs = DevEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevEndpointArgsBuilder.() -> Unit) {
        val builder = DevEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DevEndpoint {
        val builtJavaResource = com.pulumi.aws.glue.DevEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DevEndpoint(builtJavaResource)
    }
}

/**
 * Provides a Glue Development Endpoint resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["glue&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "AWSGlueServiceRole-foo",
 *     assumeRolePolicy: example.then(example => example.json),
 * });
 * const exampleDevEndpoint = new aws.glue.DevEndpoint("example", {
 *     name: "foo",
 *     roleArn: exampleRole.arn,
 * });
 * const example_AWSGlueServiceRole = new aws.iam.RolePolicyAttachment("example-AWSGlueServiceRole", {
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole",
 *     role: exampleRole.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["glue&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="AWSGlueServiceRole-foo",
 *     assume_role_policy=example.json)
 * example_dev_endpoint = aws.glue.DevEndpoint("example",
 *     name="foo",
 *     role_arn=example_role.arn)
 * example__aws_glue_service_role = aws.iam.RolePolicyAttachment("example-AWSGlueServiceRole",
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole",
 *     role=example_role.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "glue.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "AWSGlueServiceRole-foo",
 *         AssumeRolePolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleDevEndpoint = new Aws.Glue.DevEndpoint("example", new()
 *     {
 *         Name = "foo",
 *         RoleArn = exampleRole.Arn,
 *     });
 *     var example_AWSGlueServiceRole = new Aws.Iam.RolePolicyAttachment("example-AWSGlueServiceRole", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole",
 *         Role = exampleRole.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"glue.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("AWSGlueServiceRole-foo"),
 * 			AssumeRolePolicy: pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = glue.NewDevEndpoint(ctx, "example", &glue.DevEndpointArgs{
 * 			Name:    pulumi.String("foo"),
 * 			RoleArn: exampleRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example-AWSGlueServiceRole", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole"),
 * 			Role:      exampleRole.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.glue.DevEndpoint;
 * import com.pulumi.aws.glue.DevEndpointArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("glue.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("AWSGlueServiceRole-foo")
 *             .assumeRolePolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDevEndpoint = new DevEndpoint("exampleDevEndpoint", DevEndpointArgs.builder()
 *             .name("foo")
 *             .roleArn(exampleRole.arn())
 *             .build());
 *         var example_AWSGlueServiceRole = new RolePolicyAttachment("example-AWSGlueServiceRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole")
 *             .role(exampleRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleDevEndpoint:
 *     type: aws:glue:DevEndpoint
 *     name: example
 *     properties:
 *       name: foo
 *       roleArn: ${exampleRole.arn}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: AWSGlueServiceRole-foo
 *       assumeRolePolicy: ${example.json}
 *   example-AWSGlueServiceRole:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole
 *       role: ${exampleRole.name}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - glue.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a Glue Development Endpoint using the `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/devEndpoint:DevEndpoint example foo
 * ```
 */
public class DevEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.glue.DevEndpoint,
) : KotlinCustomResource(javaResource, DevEndpointMapper) {
    /**
     * A map of arguments used to configure the endpoint.
     */
    public val arguments: Output<Map<String, String>>?
        get() = javaResource.arguments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ARN of the endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS availability zone where this endpoint is located.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
     */
    public val extraJarsS3Path: Output<String>?
        get() = javaResource.extraJarsS3Path().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
     */
    public val extraPythonLibsS3Path: Output<String>?
        get() = javaResource.extraPythonLibsS3Path().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The reason for a current failure in this endpoint.
     */
    public val failureReason: Output<String>
        get() = javaResource.failureReason().applyValue({ args0 -> args0 })

    /**
     * Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
     */
    public val glueVersion: Output<String>?
        get() = javaResource.glueVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of this endpoint. It must be unique in your account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
     */
    public val numberOfNodes: Output<Int>?
        get() = javaResource.numberOfNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
     */
    public val numberOfWorkers: Output<Int>?
        get() = javaResource.numberOfWorkers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A private IP address to access the endpoint within a VPC, if this endpoint is created within one.
     */
    public val privateAddress: Output<String>
        get() = javaResource.privateAddress().applyValue({ args0 -> args0 })

    /**
     * The public IP address used by this endpoint. The PublicAddress field is present only when you create a non-VPC endpoint.
     */
    public val publicAddress: Output<String>
        get() = javaResource.publicAddress().applyValue({ args0 -> args0 })

    /**
     * The public key to be used by this endpoint for authentication.
     */
    public val publicKey: Output<String>?
        get() = javaResource.publicKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of public keys to be used by this endpoint for authentication.
     */
    public val publicKeys: Output<List<String>>?
        get() = javaResource.publicKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The IAM role for this endpoint.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The name of the Security Configuration structure to be used with this endpoint.
     */
    public val securityConfiguration: Output<String>?
        get() = javaResource.securityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Security group IDs for the security groups to be used by this endpoint.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The current status of this endpoint.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The subnet ID for the new endpoint to use.
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * he ID of the VPC used by this endpoint.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
     */
    public val workerType: Output<String>?
        get() = javaResource.workerType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The YARN endpoint address used by this endpoint.
     */
    public val yarnEndpointAddress: Output<String>
        get() = javaResource.yarnEndpointAddress().applyValue({ args0 -> args0 })

    /**
     * The Apache Zeppelin port for the remote Apache Spark interpreter.
     */
    public val zeppelinRemoteSparkInterpreterPort: Output<Int>
        get() = javaResource.zeppelinRemoteSparkInterpreterPort().applyValue({ args0 -> args0 })
}

public object DevEndpointMapper : ResourceMapper<DevEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.DevEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): DevEndpoint = DevEndpoint(
        javaResource as
            com.pulumi.aws.glue.DevEndpoint,
    )
}

/**
 * @see [DevEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevEndpoint].
 */
public suspend fun devEndpoint(name: String, block: suspend DevEndpointResourceBuilder.() -> Unit): DevEndpoint {
    val builder = DevEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devEndpoint(name: String): DevEndpoint {
    val builder = DevEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
