@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.DevEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Development Endpoint resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["glue&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "AWSGlueServiceRole-foo",
 *     assumeRolePolicy: example.then(example => example.json),
 * });
 * const exampleDevEndpoint = new aws.glue.DevEndpoint("example", {
 *     name: "foo",
 *     roleArn: exampleRole.arn,
 * });
 * const example_AWSGlueServiceRole = new aws.iam.RolePolicyAttachment("example-AWSGlueServiceRole", {
 *     policyArn: "arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole",
 *     role: exampleRole.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["glue&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="AWSGlueServiceRole-foo",
 *     assume_role_policy=example.json)
 * example_dev_endpoint = aws.glue.DevEndpoint("example",
 *     name="foo",
 *     role_arn=example_role.arn)
 * example__aws_glue_service_role = aws.iam.RolePolicyAttachment("example-AWSGlueServiceRole",
 *     policy_arn="arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole",
 *     role=example_role.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "glue.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "AWSGlueServiceRole-foo",
 *         AssumeRolePolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleDevEndpoint = new Aws.Glue.DevEndpoint("example", new()
 *     {
 *         Name = "foo",
 *         RoleArn = exampleRole.Arn,
 *     });
 *     var example_AWSGlueServiceRole = new Aws.Iam.RolePolicyAttachment("example-AWSGlueServiceRole", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole",
 *         Role = exampleRole.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"glue.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("AWSGlueServiceRole-foo"),
 * 			AssumeRolePolicy: pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = glue.NewDevEndpoint(ctx, "example", &glue.DevEndpointArgs{
 * 			Name:    pulumi.String("foo"),
 * 			RoleArn: exampleRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example-AWSGlueServiceRole", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole"),
 * 			Role:      exampleRole.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.glue.DevEndpoint;
 * import com.pulumi.aws.glue.DevEndpointArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("glue.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("AWSGlueServiceRole-foo")
 *             .assumeRolePolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDevEndpoint = new DevEndpoint("exampleDevEndpoint", DevEndpointArgs.builder()
 *             .name("foo")
 *             .roleArn(exampleRole.arn())
 *             .build());
 *         var example_AWSGlueServiceRole = new RolePolicyAttachment("example-AWSGlueServiceRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole")
 *             .role(exampleRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleDevEndpoint:
 *     type: aws:glue:DevEndpoint
 *     name: example
 *     properties:
 *       name: foo
 *       roleArn: ${exampleRole.arn}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: AWSGlueServiceRole-foo
 *       assumeRolePolicy: ${example.json}
 *   example-AWSGlueServiceRole:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/service-role/AWSGlueServiceRole
 *       role: ${exampleRole.name}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - glue.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a Glue Development Endpoint using the `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/devEndpoint:DevEndpoint example foo
 * ```
 * @property arguments A map of arguments used to configure the endpoint.
 * @property extraJarsS3Path Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
 * @property extraPythonLibsS3Path Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
 * @property glueVersion Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
 * @property name The name of this endpoint. It must be unique in your account.
 * @property numberOfNodes The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
 * @property numberOfWorkers The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
 * @property publicKey The public key to be used by this endpoint for authentication.
 * @property publicKeys A list of public keys to be used by this endpoint for authentication.
 * @property roleArn The IAM role for this endpoint.
 * @property securityConfiguration The name of the Security Configuration structure to be used with this endpoint.
 * @property securityGroupIds Security group IDs for the security groups to be used by this endpoint.
 * @property subnetId The subnet ID for the new endpoint to use.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workerType The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
 */
public data class DevEndpointArgs(
    public val arguments: Output<Map<String, String>>? = null,
    public val extraJarsS3Path: Output<String>? = null,
    public val extraPythonLibsS3Path: Output<String>? = null,
    public val glueVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val numberOfNodes: Output<Int>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val publicKey: Output<String>? = null,
    public val publicKeys: Output<List<String>>? = null,
    public val roleArn: Output<String>? = null,
    public val securityConfiguration: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workerType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.DevEndpointArgs> {
    override fun toJava(): com.pulumi.aws.glue.DevEndpointArgs =
        com.pulumi.aws.glue.DevEndpointArgs.builder()
            .arguments(
                arguments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .extraJarsS3Path(extraJarsS3Path?.applyValue({ args0 -> args0 }))
            .extraPythonLibsS3Path(extraPythonLibsS3Path?.applyValue({ args0 -> args0 }))
            .glueVersion(glueVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .numberOfNodes(numberOfNodes?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .publicKeys(publicKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .securityConfiguration(securityConfiguration?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workerType(workerType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DevEndpointArgs].
 */
@PulumiTagMarker
public class DevEndpointArgsBuilder internal constructor() {
    private var arguments: Output<Map<String, String>>? = null

    private var extraJarsS3Path: Output<String>? = null

    private var extraPythonLibsS3Path: Output<String>? = null

    private var glueVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var numberOfNodes: Output<Int>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var publicKey: Output<String>? = null

    private var publicKeys: Output<List<String>>? = null

    private var roleArn: Output<String>? = null

    private var securityConfiguration: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workerType: Output<String>? = null

    /**
     * @param value A map of arguments used to configure the endpoint.
     */
    @JvmName("sloumdkrjxnycijc")
    public suspend fun arguments(`value`: Output<Map<String, String>>) {
        this.arguments = value
    }

    /**
     * @param value Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
     */
    @JvmName("ttxlicknjkapeavn")
    public suspend fun extraJarsS3Path(`value`: Output<String>) {
        this.extraJarsS3Path = value
    }

    /**
     * @param value Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
     */
    @JvmName("frfaijxhwktsvrpe")
    public suspend fun extraPythonLibsS3Path(`value`: Output<String>) {
        this.extraPythonLibsS3Path = value
    }

    /**
     * @param value Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
     */
    @JvmName("otgwudeudkykdvde")
    public suspend fun glueVersion(`value`: Output<String>) {
        this.glueVersion = value
    }

    /**
     * @param value The name of this endpoint. It must be unique in your account.
     */
    @JvmName("riovrlbanlubmlne")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
     */
    @JvmName("rhxerxcrtgvvtlhm")
    public suspend fun numberOfNodes(`value`: Output<Int>) {
        this.numberOfNodes = value
    }

    /**
     * @param value The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
     */
    @JvmName("vcngwhebdfwmsbcg")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value The public key to be used by this endpoint for authentication.
     */
    @JvmName("eaktwtmsjcnrhpqm")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("ixjsyxvycmhgghlj")
    public suspend fun publicKeys(`value`: Output<List<String>>) {
        this.publicKeys = value
    }

    @JvmName("acvdtoytnufkcdpj")
    public suspend fun publicKeys(vararg values: Output<String>) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("ryqudsmvgtkojpdt")
    public suspend fun publicKeys(values: List<Output<String>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value The IAM role for this endpoint.
     */
    @JvmName("uviyddkkjlbubtvf")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name of the Security Configuration structure to be used with this endpoint.
     */
    @JvmName("snonytofgkesfwpg")
    public suspend fun securityConfiguration(`value`: Output<String>) {
        this.securityConfiguration = value
    }

    /**
     * @param value Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("ihggcavfworfwvdx")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("jmfyfqvgeivsgqkh")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("jqmmpwatvefgbjkq")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The subnet ID for the new endpoint to use.
     */
    @JvmName("dvnfmbnkomrvjmtv")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("depxumnykotfhvji")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
     */
    @JvmName("dhuanjgjlwmuxvde")
    public suspend fun workerType(`value`: Output<String>) {
        this.workerType = value
    }

    /**
     * @param value A map of arguments used to configure the endpoint.
     */
    @JvmName("vcmvsdyklqsskyxx")
    public suspend fun arguments(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values A map of arguments used to configure the endpoint.
     */
    @JvmName("gatqxjrmetwjomyu")
    public fun arguments(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Path to one or more Java Jars in an S3 bucket that should be loaded in this endpoint.
     */
    @JvmName("qilujahtkvhfgiog")
    public suspend fun extraJarsS3Path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraJarsS3Path = mapped
    }

    /**
     * @param value Path(s) to one or more Python libraries in an S3 bucket that should be loaded in this endpoint. Multiple values must be complete paths separated by a comma.
     */
    @JvmName("amnahfmrrtjghsrk")
    public suspend fun extraPythonLibsS3Path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extraPythonLibsS3Path = mapped
    }

    /**
     * @param value Specifies the versions of Python and Apache Spark to use. Defaults to AWS Glue version 0.9.
     */
    @JvmName("mtsalkvnsfbjmoap")
    public suspend fun glueVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueVersion = mapped
    }

    /**
     * @param value The name of this endpoint. It must be unique in your account.
     */
    @JvmName("pvqeddtfbxdyrpng")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The number of AWS Glue Data Processing Units (DPUs) to allocate to this endpoint. Conflicts with `worker_type`.
     */
    @JvmName("efhlgwvlmbvghaic")
    public suspend fun numberOfNodes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfNodes = mapped
    }

    /**
     * @param value The number of workers of a defined worker type that are allocated to this endpoint. This field is available only when you choose worker type G.1X or G.2X.
     */
    @JvmName("jejlguvhvacvlqvo")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value The public key to be used by this endpoint for authentication.
     */
    @JvmName("pmsvrtbsvhdtoqfg")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("liaemfvyxsdwqbmv")
    public suspend fun publicKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param values A list of public keys to be used by this endpoint for authentication.
     */
    @JvmName("xsvsrsklykdwsegx")
    public suspend fun publicKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param value The IAM role for this endpoint.
     */
    @JvmName("ixisfqpbdegoflrg")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name of the Security Configuration structure to be used with this endpoint.
     */
    @JvmName("kublnejedaguxgle")
    public suspend fun securityConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfiguration = mapped
    }

    /**
     * @param value Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("twpyqbtwlupgaicg")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Security group IDs for the security groups to be used by this endpoint.
     */
    @JvmName("brsgrxjvbwvhaljt")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The subnet ID for the new endpoint to use.
     */
    @JvmName("lhwrykeijwivsxhs")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("evadlpbgxrjdwnsu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wkgvevnepcmxpchn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of predefined worker that is allocated to this endpoint. Accepts a value of Standard, G.1X, or G.2X.
     */
    @JvmName("fnqxwpvitrdbcfmj")
    public suspend fun workerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerType = mapped
    }

    internal fun build(): DevEndpointArgs = DevEndpointArgs(
        arguments = arguments,
        extraJarsS3Path = extraJarsS3Path,
        extraPythonLibsS3Path = extraPythonLibsS3Path,
        glueVersion = glueVersion,
        name = name,
        numberOfNodes = numberOfNodes,
        numberOfWorkers = numberOfWorkers,
        publicKey = publicKey,
        publicKeys = publicKeys,
        roleArn = roleArn,
        securityConfiguration = securityConfiguration,
        securityGroupIds = securityGroupIds,
        subnetId = subnetId,
        tags = tags,
        workerType = workerType,
    )
}
