@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.JobCommand
import com.pulumi.aws.glue.kotlin.outputs.JobExecutionProperty
import com.pulumi.aws.glue.kotlin.outputs.JobNotificationProperty
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.glue.kotlin.outputs.JobCommand.Companion.toKotlin as jobCommandToKotlin
import com.pulumi.aws.glue.kotlin.outputs.JobExecutionProperty.Companion.toKotlin as jobExecutionPropertyToKotlin
import com.pulumi.aws.glue.kotlin.outputs.JobNotificationProperty.Companion.toKotlin as jobNotificationPropertyToKotlin

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.aws.glue.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * Provides a Glue Job resource.
 * > Glue functionality, such as monitoring and logging of jobs, is typically managed with the `default_arguments` argument. See the [Special Parameters Used by AWS Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html) topic in the Glue developer guide for additional information.
 * ## Example Usage
 * ### Python Job
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Job("example", {
 *     name: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     command: {
 *         scriptLocation: `s3://${exampleAwsS3Bucket.bucket}/example.py`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Job("example",
 *     name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     command={
 *         "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.py",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Job("example", new()
 *     {
 *         Name = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Command = new Aws.Glue.Inputs.JobCommandArgs
 *         {
 *             ScriptLocation = $"s3://{exampleAwsS3Bucket.Bucket}/example.py",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewJob(ctx, "example", &glue.JobArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			Command: &glue.JobCommandArgs{
 * 				ScriptLocation: pulumi.Sprintf("s3://%v/example.py", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .name("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format("s3://%s/example.py", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Job
 *     properties:
 *       name: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       command:
 *         scriptLocation: s3://${exampleAwsS3Bucket.bucket}/example.py
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Ray Job
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Job("example", {
 *     name: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     glueVersion: "4.0",
 *     workerType: "Z.2X",
 *     command: {
 *         name: "glueray",
 *         pythonVersion: "3.9",
 *         runtime: "Ray2.4",
 *         scriptLocation: `s3://${exampleAwsS3Bucket.bucket}/example.py`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Job("example",
 *     name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     glue_version="4.0",
 *     worker_type="Z.2X",
 *     command={
 *         "name": "glueray",
 *         "python_version": "3.9",
 *         "runtime": "Ray2.4",
 *         "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.py",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Job("example", new()
 *     {
 *         Name = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         GlueVersion = "4.0",
 *         WorkerType = "Z.2X",
 *         Command = new Aws.Glue.Inputs.JobCommandArgs
 *         {
 *             Name = "glueray",
 *             PythonVersion = "3.9",
 *             Runtime = "Ray2.4",
 *             ScriptLocation = $"s3://{exampleAwsS3Bucket.Bucket}/example.py",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewJob(ctx, "example", &glue.JobArgs{
 * 			Name:        pulumi.String("example"),
 * 			RoleArn:     pulumi.Any(exampleAwsIamRole.Arn),
 * 			GlueVersion: pulumi.String("4.0"),
 * 			WorkerType:  pulumi.String("Z.2X"),
 * 			Command: &glue.JobCommandArgs{
 * 				Name:           pulumi.String("glueray"),
 * 				PythonVersion:  pulumi.String("3.9"),
 * 				Runtime:        pulumi.String("Ray2.4"),
 * 				ScriptLocation: pulumi.Sprintf("s3://%v/example.py", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .name("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .glueVersion("4.0")
 *             .workerType("Z.2X")
 *             .command(JobCommandArgs.builder()
 *                 .name("glueray")
 *                 .pythonVersion("3.9")
 *                 .runtime("Ray2.4")
 *                 .scriptLocation(String.format("s3://%s/example.py", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Job
 *     properties:
 *       name: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       glueVersion: '4.0'
 *       workerType: Z.2X
 *       command:
 *         name: glueray
 *         pythonVersion: '3.9'
 *         runtime: Ray2.4
 *         scriptLocation: s3://${exampleAwsS3Bucket.bucket}/example.py
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Scala Job
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Job("example", {
 *     name: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     command: {
 *         scriptLocation: `s3://${exampleAwsS3Bucket.bucket}/example.scala`,
 *     },
 *     defaultArguments: {
 *         "--job-language": "scala",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Job("example",
 *     name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     command={
 *         "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.scala",
 *     },
 *     default_arguments={
 *         "--job-language": "scala",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Job("example", new()
 *     {
 *         Name = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Command = new Aws.Glue.Inputs.JobCommandArgs
 *         {
 *             ScriptLocation = $"s3://{exampleAwsS3Bucket.Bucket}/example.scala",
 *         },
 *         DefaultArguments =
 *         {
 *             { "--job-language", "scala" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewJob(ctx, "example", &glue.JobArgs{
 * 			Name:    pulumi.String("example"),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			Command: &glue.JobCommandArgs{
 * 				ScriptLocation: pulumi.Sprintf("s3://%v/example.scala", exampleAwsS3Bucket.Bucket),
 * 			},
 * 			DefaultArguments: pulumi.StringMap{
 * 				"--job-language": pulumi.String("scala"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .name("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .command(JobCommandArgs.builder()
 *                 .scriptLocation(String.format("s3://%s/example.scala", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .defaultArguments(Map.of("--job-language", "scala"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Job
 *     properties:
 *       name: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       command:
 *         scriptLocation: s3://${exampleAwsS3Bucket.bucket}/example.scala
 *       defaultArguments:
 *         --job-language: scala
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Streaming Job
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Job("example", {
 *     name: "example streaming job",
 *     roleArn: exampleAwsIamRole.arn,
 *     command: {
 *         name: "gluestreaming",
 *         scriptLocation: `s3://${exampleAwsS3Bucket.bucket}/example.script`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Job("example",
 *     name="example streaming job",
 *     role_arn=example_aws_iam_role["arn"],
 *     command={
 *         "name": "gluestreaming",
 *         "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.script",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Job("example", new()
 *     {
 *         Name = "example streaming job",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         Command = new Aws.Glue.Inputs.JobCommandArgs
 *         {
 *             Name = "gluestreaming",
 *             ScriptLocation = $"s3://{exampleAwsS3Bucket.Bucket}/example.script",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewJob(ctx, "example", &glue.JobArgs{
 * 			Name:    pulumi.String("example streaming job"),
 * 			RoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			Command: &glue.JobCommandArgs{
 * 				Name:           pulumi.String("gluestreaming"),
 * 				ScriptLocation: pulumi.Sprintf("s3://%v/example.script", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import com.pulumi.aws.glue.inputs.JobCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Job("example", JobArgs.builder()
 *             .name("example streaming job")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .command(JobCommandArgs.builder()
 *                 .name("gluestreaming")
 *                 .scriptLocation(String.format("s3://%s/example.script", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Job
 *     properties:
 *       name: example streaming job
 *       roleArn: ${exampleAwsIamRole.arn}
 *       command:
 *         name: gluestreaming
 *         scriptLocation: s3://${exampleAwsS3Bucket.bucket}/example.script
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Enabling CloudWatch Logs and Metrics
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.cloudwatch.LogGroup("example", {
 *     name: "example",
 *     retentionInDays: 14,
 * });
 * const exampleJob = new aws.glue.Job("example", {defaultArguments: {
 *     "--continuous-log-logGroup": example.name,
 *     "--enable-continuous-cloudwatch-log": "true",
 *     "--enable-continuous-log-filter": "true",
 *     "--enable-metrics": "",
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.cloudwatch.LogGroup("example",
 *     name="example",
 *     retention_in_days=14)
 * example_job = aws.glue.Job("example", default_arguments={
 *     "--continuous-log-logGroup": example.name,
 *     "--enable-continuous-cloudwatch-log": "true",
 *     "--enable-continuous-log-filter": "true",
 *     "--enable-metrics": "",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         Name = "example",
 *         RetentionInDays = 14,
 *     });
 *     var exampleJob = new Aws.Glue.Job("example", new()
 *     {
 *         DefaultArguments =
 *         {
 *             { "--continuous-log-logGroup", example.Name },
 *             { "--enable-continuous-cloudwatch-log", "true" },
 *             { "--enable-continuous-log-filter", "true" },
 *             { "--enable-metrics", "" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			Name:            pulumi.String("example"),
 * 			RetentionInDays: pulumi.Int(14),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = glue.NewJob(ctx, "example", &glue.JobArgs{
 * 			DefaultArguments: pulumi.StringMap{
 * 				"--continuous-log-logGroup":          example.Name,
 * 				"--enable-continuous-cloudwatch-log": pulumi.String("true"),
 * 				"--enable-continuous-log-filter":     pulumi.String("true"),
 * 				"--enable-metrics":                   pulumi.String(""),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.glue.Job;
 * import com.pulumi.aws.glue.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LogGroup("example", LogGroupArgs.builder()
 *             .name("example")
 *             .retentionInDays(14)
 *             .build());
 *         var exampleJob = new Job("exampleJob", JobArgs.builder()
 *             .defaultArguments(Map.ofEntries(
 *                 Map.entry("--continuous-log-logGroup", example.name()),
 *                 Map.entry("--enable-continuous-cloudwatch-log", "true"),
 *                 Map.entry("--enable-continuous-log-filter", "true"),
 *                 Map.entry("--enable-metrics", "")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       name: example
 *       retentionInDays: 14
 *   exampleJob:
 *     type: aws:glue:Job
 *     name: example
 *     properties:
 *       defaultArguments:
 *         --continuous-log-logGroup: ${example.name}
 *         --enable-continuous-cloudwatch-log: 'true'
 *         --enable-continuous-log-filter: 'true'
 *         --enable-metrics:
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Jobs using `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/job:Job MyJob MyJob
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.aws.glue.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * Amazon Resource Name (ARN) of Glue Job
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The command of the job. Defined below.
     */
    public val command: Output<JobCommand>
        get() = javaResource.command().applyValue({ args0 ->
            args0.let({ args0 ->
                jobCommandToKotlin(args0)
            })
        })

    /**
     * The list of connections used for this job.
     */
    public val connections: Output<List<String>>?
        get() = javaResource.connections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs&#46;aws&#46;amazon&#46;com/glue/latest/dg/aws-glue-programming-python-calling&#46;html) topic in the developer guide&#46; For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
     */
    public val defaultArguments: Output<Map<String, String>>?
        get() = javaResource.defaultArguments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Description of the job.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
     */
    public val executionClass: Output<String>?
        get() = javaResource.executionClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Execution property of the job. Defined below.
     */
    public val executionProperty: Output<JobExecutionProperty>
        get() = javaResource.executionProperty().applyValue({ args0 ->
            args0.let({ args0 ->
                jobExecutionPropertyToKotlin(args0)
            })
        })

    /**
     * The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
     */
    public val glueVersion: Output<String>
        get() = javaResource.glueVersion().applyValue({ args0 -> args0 })

    /**
     * Specifies the day of the week and hour for the maintenance window for streaming jobs.
     */
    public val maintenanceWindow: Output<String>?
        get() = javaResource.maintenanceWindow().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
     */
    public val maxCapacity: Output<Double>
        get() = javaResource.maxCapacity().applyValue({ args0 -> args0 })

    /**
     * The maximum number of times to retry this job if it fails.
     */
    public val maxRetries: Output<Int>?
        get() = javaResource.maxRetries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name you assign to this job. It must be unique in your account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Non-overridable arguments for this job, specified as name-value pairs.
     */
    public val nonOverridableArguments: Output<Map<String, String>>?
        get() = javaResource.nonOverridableArguments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Notification property of the job. Defined below.
     */
    public val notificationProperty: Output<JobNotificationProperty>
        get() = javaResource.notificationProperty().applyValue({ args0 ->
            args0.let({ args0 ->
                jobNotificationPropertyToKotlin(args0)
            })
        })

    /**
     * The number of workers of a defined workerType that are allocated when a job runs.
     */
    public val numberOfWorkers: Output<Int>
        get() = javaResource.numberOfWorkers().applyValue({ args0 -> args0 })

    /**
     * The ARN of the IAM role associated with this job.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The name of the Security Configuration to be associated with the job.
     */
    public val securityConfiguration: Output<String>?
        get() = javaResource.securityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
     */
    public val timeout: Output<Int>
        get() = javaResource.timeout().applyValue({ args0 -> args0 })

    /**
     * The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
     * * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     * * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
     * * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
     * * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
     * * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
     * * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
     */
    public val workerType: Output<String>
        get() = javaResource.workerType().applyValue({ args0 -> args0 })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(javaResource as com.pulumi.aws.glue.Job)
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
