@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.PartitionArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.PartitionStorageDescriptorArgs
import com.pulumi.aws.glue.kotlin.inputs.PartitionStorageDescriptorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Partition Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Partition
 *     properties:
 *       databaseName: some-database
 *       tableName: some-table
 *       values:
 *         - some-value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Partitions using the catalog ID (usually AWS account ID), database name, table name and partition values. For example:
 * ```sh
 * $ pulumi import aws:glue/partition:Partition part 123456789012:MyDatabase:MyTable:val1#val2
 * ```
 * @property catalogId ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
 * @property databaseName Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
 * @property parameters Properties associated with this table, as a list of key-value pairs.
 * @property partitionValues The values that define the partition.
 * @property storageDescriptor A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
 * @property tableName
 */
public data class PartitionArgs(
    public val catalogId: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val partitionValues: Output<List<String>>? = null,
    public val storageDescriptor: Output<PartitionStorageDescriptorArgs>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.PartitionArgs> {
    override fun toJava(): com.pulumi.aws.glue.PartitionArgs =
        com.pulumi.aws.glue.PartitionArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .partitionValues(partitionValues?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageDescriptor(storageDescriptor?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartitionArgs].
 */
@PulumiTagMarker
public class PartitionArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var partitionValues: Output<List<String>>? = null

    private var storageDescriptor: Output<PartitionStorageDescriptorArgs>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    @JvmName("omycmoybdxgqgsjp")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     */
    @JvmName("ktkbsixaumeqhphh")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("xyfifsmlopctfogv")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The values that define the partition.
     */
    @JvmName("hqonwqciiwbmdjhv")
    public suspend fun partitionValues(`value`: Output<List<String>>) {
        this.partitionValues = value
    }

    @JvmName("ygxhtmepgqoshwkh")
    public suspend fun partitionValues(vararg values: Output<String>) {
        this.partitionValues = Output.all(values.asList())
    }

    /**
     * @param values The values that define the partition.
     */
    @JvmName("pucwsjxqssbiwgyx")
    public suspend fun partitionValues(values: List<Output<String>>) {
        this.partitionValues = Output.all(values)
    }

    /**
     * @param value A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     */
    @JvmName("uxouixdmdxyulalt")
    public suspend fun storageDescriptor(`value`: Output<PartitionStorageDescriptorArgs>) {
        this.storageDescriptor = value
    }

    /**
     * @param value
     */
    @JvmName("yevoifrqtdfhslbi")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
     */
    @JvmName("vtojyaaepjsfwjqt")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
     */
    @JvmName("wilfbejkuoaxbumi")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("bvrbtxpopltdjdlv")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Properties associated with this table, as a list of key-value pairs.
     */
    @JvmName("alwxvkvqgesorkel")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The values that define the partition.
     */
    @JvmName("bbscdjahqkpvgoys")
    public suspend fun partitionValues(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionValues = mapped
    }

    /**
     * @param values The values that define the partition.
     */
    @JvmName("vfeutwdscvmlecnk")
    public suspend fun partitionValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionValues = mapped
    }

    /**
     * @param value A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     */
    @JvmName("hxyniwvgmawttprj")
    public suspend fun storageDescriptor(`value`: PartitionStorageDescriptorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageDescriptor = mapped
    }

    /**
     * @param argument A storage descriptor object containing information about the physical storage of this table. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor) for a full explanation of this object.
     */
    @JvmName("lwcvngffftapmlcw")
    public suspend fun storageDescriptor(argument: suspend PartitionStorageDescriptorArgsBuilder.() -> Unit) {
        val toBeMapped = PartitionStorageDescriptorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageDescriptor = mapped
    }

    /**
     * @param value
     */
    @JvmName("lufxabokdqjyyfwc")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): PartitionArgs = PartitionArgs(
        catalogId = catalogId,
        databaseName = databaseName,
        parameters = parameters,
        partitionValues = partitionValues,
        storageDescriptor = storageDescriptor,
        tableName = tableName,
    )
}
