@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Schema].
 */
@PulumiTagMarker
public class SchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SchemaArgs = SchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SchemaArgsBuilder.() -> Unit) {
        val builder = SchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Schema {
        val builtJavaResource = com.pulumi.aws.glue.Schema(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schema(builtJavaResource)
    }
}

/**
 * Provides a Glue Schema resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Schema("example", {
 *     schemaName: "example",
 *     registryArn: test.arn,
 *     dataFormat: "AVRO",
 *     compatibility: "NONE",
 *     schemaDefinition: "{\"type\": \"record\", \"name\": \"r1\", \"fields\": [ {\"name\": \"f1\", \"type\": \"int\"}, {\"name\": \"f2\", \"type\": \"string\"} ]}",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Schema("example",
 *     schema_name="example",
 *     registry_arn=test["arn"],
 *     data_format="AVRO",
 *     compatibility="NONE",
 *     schema_definition="{\"type\": \"record\", \"name\": \"r1\", \"fields\": [ {\"name\": \"f1\", \"type\": \"int\"}, {\"name\": \"f2\", \"type\": \"string\"} ]}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Schema("example", new()
 *     {
 *         SchemaName = "example",
 *         RegistryArn = test.Arn,
 *         DataFormat = "AVRO",
 *         Compatibility = "NONE",
 *         SchemaDefinition = "{\"type\": \"record\", \"name\": \"r1\", \"fields\": [ {\"name\": \"f1\", \"type\": \"int\"}, {\"name\": \"f2\", \"type\": \"string\"} ]}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewSchema(ctx, "example", &glue.SchemaArgs{
 * 			SchemaName:       pulumi.String("example"),
 * 			RegistryArn:      pulumi.Any(test.Arn),
 * 			DataFormat:       pulumi.String("AVRO"),
 * 			Compatibility:    pulumi.String("NONE"),
 * 			SchemaDefinition: pulumi.String("{\"type\": \"record\", \"name\": \"r1\", \"fields\": [ {\"name\": \"f1\", \"type\": \"int\"}, {\"name\": \"f2\", \"type\": \"string\"} ]}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Schema;
 * import com.pulumi.aws.glue.SchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Schema("example", SchemaArgs.builder()
 *             .schemaName("example")
 *             .registryArn(test.arn())
 *             .dataFormat("AVRO")
 *             .compatibility("NONE")
 *             .schemaDefinition("{\"type\": \"record\", \"name\": \"r1\", \"fields\": [ {\"name\": \"f1\", \"type\": \"int\"}, {\"name\": \"f2\", \"type\": \"string\"} ]}")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Schema
 *     properties:
 *       schemaName: example
 *       registryArn: ${test.arn}
 *       dataFormat: AVRO
 *       compatibility: NONE
 *       schemaDefinition: '{"type": "record", "name": "r1", "fields": [ {"name": "f1", "type": "int"}, {"name": "f2", "type": "string"} ]}'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Registries using `arn`. For example:
 * ```sh
 * $ pulumi import aws:glue/schema:Schema example arn:aws:glue:us-west-2:123456789012:schema/example/example
 * ```
 */
public class Schema internal constructor(
    override val javaResource: com.pulumi.aws.glue.Schema,
) : KotlinCustomResource(javaResource, SchemaMapper) {
    /**
     * Amazon Resource Name (ARN) of the schema.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The compatibility mode of the schema. Values values are: `NONE`, `DISABLED`, `BACKWARD`, `BACKWARD_ALL`, `FORWARD`, `FORWARD_ALL`, `FULL`, and `FULL_ALL`.
     */
    public val compatibility: Output<String>
        get() = javaResource.compatibility().applyValue({ args0 -> args0 })

    /**
     * The data format of the schema definition. Valid values are `AVRO`, `JSON` and `PROTOBUF`.
     */
    public val dataFormat: Output<String>
        get() = javaResource.dataFormat().applyValue({ args0 -> args0 })

    /**
     * A description of the schema.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The latest version of the schema associated with the returned schema definition.
     */
    public val latestSchemaVersion: Output<Int>
        get() = javaResource.latestSchemaVersion().applyValue({ args0 -> args0 })

    /**
     * The next version of the schema associated with the returned schema definition.
     */
    public val nextSchemaVersion: Output<Int>
        get() = javaResource.nextSchemaVersion().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Glue Registry to create the schema in.
     */
    public val registryArn: Output<String>
        get() = javaResource.registryArn().applyValue({ args0 -> args0 })

    /**
     * The name of the Glue Registry.
     */
    public val registryName: Output<String>
        get() = javaResource.registryName().applyValue({ args0 -> args0 })

    /**
     * The version number of the checkpoint (the last time the compatibility mode was changed).
     */
    public val schemaCheckpoint: Output<Int>
        get() = javaResource.schemaCheckpoint().applyValue({ args0 -> args0 })

    /**
     * The schema definition using the `data_format` setting for `schema_name`.
     */
    public val schemaDefinition: Output<String>
        get() = javaResource.schemaDefinition().applyValue({ args0 -> args0 })

    /**
     * The Name of the schema.
     */
    public val schemaName: Output<String>
        get() = javaResource.schemaName().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SchemaMapper : ResourceMapper<Schema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.Schema::class == javaResource::class

    override fun map(javaResource: Resource): Schema = Schema(
        javaResource as
            com.pulumi.aws.glue.Schema,
    )
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schema].
 */
public suspend fun schema(name: String, block: suspend SchemaResourceBuilder.() -> Unit): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schema(name: String): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
