@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.kotlin.outputs.SecurityConfigurationEncryptionConfiguration
import com.pulumi.aws.glue.kotlin.outputs.SecurityConfigurationEncryptionConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityConfiguration].
 */
@PulumiTagMarker
public class SecurityConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityConfigurationArgs = SecurityConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityConfigurationArgsBuilder.() -> Unit) {
        val builder = SecurityConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityConfiguration {
        val builtJavaResource = com.pulumi.aws.glue.SecurityConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityConfiguration(builtJavaResource)
    }
}

/**
 * Manages a Glue Security Configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.SecurityConfiguration("example", {
 *     name: "example",
 *     encryptionConfiguration: {
 *         cloudwatchEncryption: {
 *             cloudwatchEncryptionMode: "DISABLED",
 *         },
 *         jobBookmarksEncryption: {
 *             jobBookmarksEncryptionMode: "DISABLED",
 *         },
 *         s3Encryption: {
 *             kmsKeyArn: exampleAwsKmsKey.arn,
 *             s3EncryptionMode: "SSE-KMS",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.SecurityConfiguration("example",
 *     name="example",
 *     encryption_configuration={
 *         "cloudwatch_encryption": {
 *             "cloudwatch_encryption_mode": "DISABLED",
 *         },
 *         "job_bookmarks_encryption": {
 *             "job_bookmarks_encryption_mode": "DISABLED",
 *         },
 *         "s3_encryption": {
 *             "kms_key_arn": example_aws_kms_key["arn"],
 *             "s3_encryption_mode": "SSE-KMS",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.SecurityConfiguration("example", new()
 *     {
 *         Name = "example",
 *         EncryptionConfiguration = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationArgs
 *         {
 *             CloudwatchEncryption = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs
 *             {
 *                 CloudwatchEncryptionMode = "DISABLED",
 *             },
 *             JobBookmarksEncryption = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs
 *             {
 *                 JobBookmarksEncryptionMode = "DISABLED",
 *             },
 *             S3Encryption = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs
 *             {
 *                 KmsKeyArn = exampleAwsKmsKey.Arn,
 *                 S3EncryptionMode = "SSE-KMS",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewSecurityConfiguration(ctx, "example", &glue.SecurityConfigurationArgs{
 * 			Name: pulumi.String("example"),
 * 			EncryptionConfiguration: &glue.SecurityConfigurationEncryptionConfigurationArgs{
 * 				CloudwatchEncryption: &glue.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs{
 * 					CloudwatchEncryptionMode: pulumi.String("DISABLED"),
 * 				},
 * 				JobBookmarksEncryption: &glue.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs{
 * 					JobBookmarksEncryptionMode: pulumi.String("DISABLED"),
 * 				},
 * 				S3Encryption: &glue.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs{
 * 					KmsKeyArn:        pulumi.Any(exampleAwsKmsKey.Arn),
 * 					S3EncryptionMode: pulumi.String("SSE-KMS"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.SecurityConfiguration;
 * import com.pulumi.aws.glue.SecurityConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityConfiguration("example", SecurityConfigurationArgs.builder()
 *             .name("example")
 *             .encryptionConfiguration(SecurityConfigurationEncryptionConfigurationArgs.builder()
 *                 .cloudwatchEncryption(SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs.builder()
 *                     .cloudwatchEncryptionMode("DISABLED")
 *                     .build())
 *                 .jobBookmarksEncryption(SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs.builder()
 *                     .jobBookmarksEncryptionMode("DISABLED")
 *                     .build())
 *                 .s3Encryption(SecurityConfigurationEncryptionConfigurationS3EncryptionArgs.builder()
 *                     .kmsKeyArn(exampleAwsKmsKey.arn())
 *                     .s3EncryptionMode("SSE-KMS")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:SecurityConfiguration
 *     properties:
 *       name: example
 *       encryptionConfiguration:
 *         cloudwatchEncryption:
 *           cloudwatchEncryptionMode: DISABLED
 *         jobBookmarksEncryption:
 *           jobBookmarksEncryptionMode: DISABLED
 *         s3Encryption:
 *           kmsKeyArn: ${exampleAwsKmsKey.arn}
 *           s3EncryptionMode: SSE-KMS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Security Configurations using `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/securityConfiguration:SecurityConfiguration example example
 * ```
 */
public class SecurityConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.glue.SecurityConfiguration,
) : KotlinCustomResource(javaResource, SecurityConfigurationMapper) {
    /**
     * Configuration block containing encryption configuration. Detailed below.
     */
    public val encryptionConfiguration: Output<SecurityConfigurationEncryptionConfiguration>
        get() = javaResource.encryptionConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Name of the security configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object SecurityConfigurationMapper : ResourceMapper<SecurityConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.glue.SecurityConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): SecurityConfiguration =
        SecurityConfiguration(javaResource as com.pulumi.aws.glue.SecurityConfiguration)
}

/**
 * @see [SecurityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityConfiguration].
 */
public suspend fun securityConfiguration(
    name: String,
    block: suspend SecurityConfigurationResourceBuilder.() -> Unit,
): SecurityConfiguration {
    val builder = SecurityConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityConfiguration(name: String): SecurityConfiguration {
    val builder = SecurityConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
