@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.SecurityConfigurationArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.SecurityConfigurationEncryptionConfigurationArgs
import com.pulumi.aws.glue.kotlin.inputs.SecurityConfigurationEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages a Glue Security Configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.SecurityConfiguration("example", {
 *     name: "example",
 *     encryptionConfiguration: {
 *         cloudwatchEncryption: {
 *             cloudwatchEncryptionMode: "DISABLED",
 *         },
 *         jobBookmarksEncryption: {
 *             jobBookmarksEncryptionMode: "DISABLED",
 *         },
 *         s3Encryption: {
 *             kmsKeyArn: exampleAwsKmsKey.arn,
 *             s3EncryptionMode: "SSE-KMS",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.SecurityConfiguration("example",
 *     name="example",
 *     encryption_configuration={
 *         "cloudwatch_encryption": {
 *             "cloudwatch_encryption_mode": "DISABLED",
 *         },
 *         "job_bookmarks_encryption": {
 *             "job_bookmarks_encryption_mode": "DISABLED",
 *         },
 *         "s3_encryption": {
 *             "kms_key_arn": example_aws_kms_key["arn"],
 *             "s3_encryption_mode": "SSE-KMS",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.SecurityConfiguration("example", new()
 *     {
 *         Name = "example",
 *         EncryptionConfiguration = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationArgs
 *         {
 *             CloudwatchEncryption = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs
 *             {
 *                 CloudwatchEncryptionMode = "DISABLED",
 *             },
 *             JobBookmarksEncryption = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs
 *             {
 *                 JobBookmarksEncryptionMode = "DISABLED",
 *             },
 *             S3Encryption = new Aws.Glue.Inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs
 *             {
 *                 KmsKeyArn = exampleAwsKmsKey.Arn,
 *                 S3EncryptionMode = "SSE-KMS",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewSecurityConfiguration(ctx, "example", &glue.SecurityConfigurationArgs{
 * 			Name: pulumi.String("example"),
 * 			EncryptionConfiguration: &glue.SecurityConfigurationEncryptionConfigurationArgs{
 * 				CloudwatchEncryption: &glue.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs{
 * 					CloudwatchEncryptionMode: pulumi.String("DISABLED"),
 * 				},
 * 				JobBookmarksEncryption: &glue.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs{
 * 					JobBookmarksEncryptionMode: pulumi.String("DISABLED"),
 * 				},
 * 				S3Encryption: &glue.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs{
 * 					KmsKeyArn:        pulumi.Any(exampleAwsKmsKey.Arn),
 * 					S3EncryptionMode: pulumi.String("SSE-KMS"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.SecurityConfiguration;
 * import com.pulumi.aws.glue.SecurityConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs;
 * import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationS3EncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityConfiguration("example", SecurityConfigurationArgs.builder()
 *             .name("example")
 *             .encryptionConfiguration(SecurityConfigurationEncryptionConfigurationArgs.builder()
 *                 .cloudwatchEncryption(SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs.builder()
 *                     .cloudwatchEncryptionMode("DISABLED")
 *                     .build())
 *                 .jobBookmarksEncryption(SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs.builder()
 *                     .jobBookmarksEncryptionMode("DISABLED")
 *                     .build())
 *                 .s3Encryption(SecurityConfigurationEncryptionConfigurationS3EncryptionArgs.builder()
 *                     .kmsKeyArn(exampleAwsKmsKey.arn())
 *                     .s3EncryptionMode("SSE-KMS")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:SecurityConfiguration
 *     properties:
 *       name: example
 *       encryptionConfiguration:
 *         cloudwatchEncryption:
 *           cloudwatchEncryptionMode: DISABLED
 *         jobBookmarksEncryption:
 *           jobBookmarksEncryptionMode: DISABLED
 *         s3Encryption:
 *           kmsKeyArn: ${exampleAwsKmsKey.arn}
 *           s3EncryptionMode: SSE-KMS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Security Configurations using `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/securityConfiguration:SecurityConfiguration example example
 * ```
 * @property encryptionConfiguration Configuration block containing encryption configuration. Detailed below.
 * @property name Name of the security configuration.
 */
public data class SecurityConfigurationArgs(
    public val encryptionConfiguration: Output<SecurityConfigurationEncryptionConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.SecurityConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.glue.SecurityConfigurationArgs =
        com.pulumi.aws.glue.SecurityConfigurationArgs.builder()
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityConfigurationArgs].
 */
@PulumiTagMarker
public class SecurityConfigurationArgsBuilder internal constructor() {
    private var encryptionConfiguration: Output<SecurityConfigurationEncryptionConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    /**
     * @param value Configuration block containing encryption configuration. Detailed below.
     */
    @JvmName("vbskxmpjepblquwp")
    public suspend fun encryptionConfiguration(`value`: Output<SecurityConfigurationEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value Name of the security configuration.
     */
    @JvmName("ayhcwmfqwnrfdvrn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block containing encryption configuration. Detailed below.
     */
    @JvmName("mjscmmwoxbcvbnva")
    public suspend fun encryptionConfiguration(`value`: SecurityConfigurationEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Configuration block containing encryption configuration. Detailed below.
     */
    @JvmName("ealaptmocyywnvuv")
    public suspend fun encryptionConfiguration(argument: suspend SecurityConfigurationEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityConfigurationEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value Name of the security configuration.
     */
    @JvmName("mmsjiedbfitgpbyc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SecurityConfigurationArgs = SecurityConfigurationArgs(
        encryptionConfiguration = encryptionConfiguration,
        name = name,
    )
}
