@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.TriggerArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.TriggerActionArgs
import com.pulumi.aws.glue.kotlin.inputs.TriggerActionArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.TriggerEventBatchingConditionArgs
import com.pulumi.aws.glue.kotlin.inputs.TriggerEventBatchingConditionArgsBuilder
import com.pulumi.aws.glue.kotlin.inputs.TriggerPredicateArgs
import com.pulumi.aws.glue.kotlin.inputs.TriggerPredicateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Glue Trigger resource.
 * ## Example Usage
 * ### Conditional Trigger
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Trigger("example", {
 *     name: "example",
 *     type: "CONDITIONAL",
 *     actions: [{
 *         jobName: example1.name,
 *     }],
 *     predicate: {
 *         conditions: [{
 *             jobName: example2.name,
 *             state: "SUCCEEDED",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Trigger("example",
 *     name="example",
 *     type="CONDITIONAL",
 *     actions=[{
 *         "job_name": example1["name"],
 *     }],
 *     predicate={
 *         "conditions": [{
 *             "job_name": example2["name"],
 *             "state": "SUCCEEDED",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Trigger("example", new()
 *     {
 *         Name = "example",
 *         Type = "CONDITIONAL",
 *         Actions = new[]
 *         {
 *             new Aws.Glue.Inputs.TriggerActionArgs
 *             {
 *                 JobName = example1.Name,
 *             },
 *         },
 *         Predicate = new Aws.Glue.Inputs.TriggerPredicateArgs
 *         {
 *             Conditions = new[]
 *             {
 *                 new Aws.Glue.Inputs.TriggerPredicateConditionArgs
 *                 {
 *                     JobName = example2.Name,
 *                     State = "SUCCEEDED",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewTrigger(ctx, "example", &glue.TriggerArgs{
 * 			Name: pulumi.String("example"),
 * 			Type: pulumi.String("CONDITIONAL"),
 * 			Actions: glue.TriggerActionArray{
 * 				&glue.TriggerActionArgs{
 * 					JobName: pulumi.Any(example1.Name),
 * 				},
 * 			},
 * 			Predicate: &glue.TriggerPredicateArgs{
 * 				Conditions: glue.TriggerPredicateConditionArray{
 * 					&glue.TriggerPredicateConditionArgs{
 * 						JobName: pulumi.Any(example2.Name),
 * 						State:   pulumi.String("SUCCEEDED"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .name("example")
 *             .type("CONDITIONAL")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(example1.name())
 *                 .build())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .jobName(example2.name())
 *                     .state("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Trigger
 *     properties:
 *       name: example
 *       type: CONDITIONAL
 *       actions:
 *         - jobName: ${example1.name}
 *       predicate:
 *         conditions:
 *           - jobName: ${example2.name}
 *             state: SUCCEEDED
 * ```
 * <!--End PulumiCodeChooser -->
 * ### On-Demand Trigger
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Trigger("example", {
 *     name: "example",
 *     type: "ON_DEMAND",
 *     actions: [{
 *         jobName: exampleAwsGlueJob.name,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Trigger("example",
 *     name="example",
 *     type="ON_DEMAND",
 *     actions=[{
 *         "job_name": example_aws_glue_job["name"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Trigger("example", new()
 *     {
 *         Name = "example",
 *         Type = "ON_DEMAND",
 *         Actions = new[]
 *         {
 *             new Aws.Glue.Inputs.TriggerActionArgs
 *             {
 *                 JobName = exampleAwsGlueJob.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewTrigger(ctx, "example", &glue.TriggerArgs{
 * 			Name: pulumi.String("example"),
 * 			Type: pulumi.String("ON_DEMAND"),
 * 			Actions: glue.TriggerActionArray{
 * 				&glue.TriggerActionArgs{
 * 					JobName: pulumi.Any(exampleAwsGlueJob.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .name("example")
 *             .type("ON_DEMAND")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(exampleAwsGlueJob.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Trigger
 *     properties:
 *       name: example
 *       type: ON_DEMAND
 *       actions:
 *         - jobName: ${exampleAwsGlueJob.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Scheduled Trigger
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Trigger("example", {
 *     name: "example",
 *     schedule: "cron(15 12 * * ? *)",
 *     type: "SCHEDULED",
 *     actions: [{
 *         jobName: exampleAwsGlueJob.name,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Trigger("example",
 *     name="example",
 *     schedule="cron(15 12 * * ? *)",
 *     type="SCHEDULED",
 *     actions=[{
 *         "job_name": example_aws_glue_job["name"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Trigger("example", new()
 *     {
 *         Name = "example",
 *         Schedule = "cron(15 12 * * ? *)",
 *         Type = "SCHEDULED",
 *         Actions = new[]
 *         {
 *             new Aws.Glue.Inputs.TriggerActionArgs
 *             {
 *                 JobName = exampleAwsGlueJob.Name,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewTrigger(ctx, "example", &glue.TriggerArgs{
 * 			Name:     pulumi.String("example"),
 * 			Schedule: pulumi.String("cron(15 12 * * ? *)"),
 * 			Type:     pulumi.String("SCHEDULED"),
 * 			Actions: glue.TriggerActionArray{
 * 				&glue.TriggerActionArgs{
 * 					JobName: pulumi.Any(exampleAwsGlueJob.Name),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .name("example")
 *             .schedule("cron(15 12 * * ? *)")
 *             .type("SCHEDULED")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(exampleAwsGlueJob.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Trigger
 *     properties:
 *       name: example
 *       schedule: cron(15 12 * * ? *)
 *       type: SCHEDULED
 *       actions:
 *         - jobName: ${exampleAwsGlueJob.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Conditional Trigger with Crawler Action
 * **Note:** Triggers can have both a crawler action and a crawler condition, just no example provided.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Trigger("example", {
 *     name: "example",
 *     type: "CONDITIONAL",
 *     actions: [{
 *         crawlerName: example1.name,
 *     }],
 *     predicate: {
 *         conditions: [{
 *             jobName: example2.name,
 *             state: "SUCCEEDED",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Trigger("example",
 *     name="example",
 *     type="CONDITIONAL",
 *     actions=[{
 *         "crawler_name": example1["name"],
 *     }],
 *     predicate={
 *         "conditions": [{
 *             "job_name": example2["name"],
 *             "state": "SUCCEEDED",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Trigger("example", new()
 *     {
 *         Name = "example",
 *         Type = "CONDITIONAL",
 *         Actions = new[]
 *         {
 *             new Aws.Glue.Inputs.TriggerActionArgs
 *             {
 *                 CrawlerName = example1.Name,
 *             },
 *         },
 *         Predicate = new Aws.Glue.Inputs.TriggerPredicateArgs
 *         {
 *             Conditions = new[]
 *             {
 *                 new Aws.Glue.Inputs.TriggerPredicateConditionArgs
 *                 {
 *                     JobName = example2.Name,
 *                     State = "SUCCEEDED",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewTrigger(ctx, "example", &glue.TriggerArgs{
 * 			Name: pulumi.String("example"),
 * 			Type: pulumi.String("CONDITIONAL"),
 * 			Actions: glue.TriggerActionArray{
 * 				&glue.TriggerActionArgs{
 * 					CrawlerName: pulumi.Any(example1.Name),
 * 				},
 * 			},
 * 			Predicate: &glue.TriggerPredicateArgs{
 * 				Conditions: glue.TriggerPredicateConditionArray{
 * 					&glue.TriggerPredicateConditionArgs{
 * 						JobName: pulumi.Any(example2.Name),
 * 						State:   pulumi.String("SUCCEEDED"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .name("example")
 *             .type("CONDITIONAL")
 *             .actions(TriggerActionArgs.builder()
 *                 .crawlerName(example1.name())
 *                 .build())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .jobName(example2.name())
 *                     .state("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Trigger
 *     properties:
 *       name: example
 *       type: CONDITIONAL
 *       actions:
 *         - crawlerName: ${example1.name}
 *       predicate:
 *         conditions:
 *           - jobName: ${example2.name}
 *             state: SUCCEEDED
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Conditional Trigger with Crawler Condition
 * **Note:** Triggers can have both a crawler action and a crawler condition, just no example provided.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Trigger("example", {
 *     name: "example",
 *     type: "CONDITIONAL",
 *     actions: [{
 *         jobName: example1.name,
 *     }],
 *     predicate: {
 *         conditions: [{
 *             crawlerName: example2.name,
 *             crawlState: "SUCCEEDED",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Trigger("example",
 *     name="example",
 *     type="CONDITIONAL",
 *     actions=[{
 *         "job_name": example1["name"],
 *     }],
 *     predicate={
 *         "conditions": [{
 *             "crawler_name": example2["name"],
 *             "crawl_state": "SUCCEEDED",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Trigger("example", new()
 *     {
 *         Name = "example",
 *         Type = "CONDITIONAL",
 *         Actions = new[]
 *         {
 *             new Aws.Glue.Inputs.TriggerActionArgs
 *             {
 *                 JobName = example1.Name,
 *             },
 *         },
 *         Predicate = new Aws.Glue.Inputs.TriggerPredicateArgs
 *         {
 *             Conditions = new[]
 *             {
 *                 new Aws.Glue.Inputs.TriggerPredicateConditionArgs
 *                 {
 *                     CrawlerName = example2.Name,
 *                     CrawlState = "SUCCEEDED",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := glue.NewTrigger(ctx, "example", &glue.TriggerArgs{
 * 			Name: pulumi.String("example"),
 * 			Type: pulumi.String("CONDITIONAL"),
 * 			Actions: glue.TriggerActionArray{
 * 				&glue.TriggerActionArgs{
 * 					JobName: pulumi.Any(example1.Name),
 * 				},
 * 			},
 * 			Predicate: &glue.TriggerPredicateArgs{
 * 				Conditions: glue.TriggerPredicateConditionArray{
 * 					&glue.TriggerPredicateConditionArgs{
 * 						CrawlerName: pulumi.Any(example2.Name),
 * 						CrawlState:  pulumi.String("SUCCEEDED"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Trigger("example", TriggerArgs.builder()
 *             .name("example")
 *             .type("CONDITIONAL")
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName(example1.name())
 *                 .build())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .crawlerName(example2.name())
 *                     .crawlState("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Trigger
 *     properties:
 *       name: example
 *       type: CONDITIONAL
 *       actions:
 *         - jobName: ${example1.name}
 *       predicate:
 *         conditions:
 *           - crawlerName: ${example2.name}
 *             crawlState: SUCCEEDED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Triggers using `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/trigger:Trigger MyTrigger MyTrigger
 * ```
 * @property actions List of actions initiated by this trigger when it fires. See Actions Below.
 * @property description A description of the new trigger.
 * @property enabled Start the trigger. Defaults to `true`.
 * @property eventBatchingConditions Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
 * @property name The name of the trigger.
 * @property predicate A predicate to specify when the new trigger should fire. Required when trigger type is `CONDITIONAL`. See Predicate Below.
 * @property schedule A cron expression used to specify the schedule. [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html)
 * @property startOnCreation Set to true to start `SCHEDULED` and `CONDITIONAL` triggers when created. True is not supported for `ON_DEMAND` triggers.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of trigger. Valid values are `CONDITIONAL`, `EVENT`, `ON_DEMAND`, and `SCHEDULED`.
 * @property workflowName A workflow to which the trigger should be associated to. Every workflow graph (DAG) needs a starting trigger (`ON_DEMAND` or `SCHEDULED` type) and can contain multiple additional `CONDITIONAL` triggers.
 */
public data class TriggerArgs(
    public val actions: Output<List<TriggerActionArgs>>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val eventBatchingConditions: Output<List<TriggerEventBatchingConditionArgs>>? = null,
    public val name: Output<String>? = null,
    public val predicate: Output<TriggerPredicateArgs>? = null,
    public val schedule: Output<String>? = null,
    public val startOnCreation: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val workflowName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.TriggerArgs> {
    override fun toJava(): com.pulumi.aws.glue.TriggerArgs = com.pulumi.aws.glue.TriggerArgs.builder()
        .actions(
            actions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .description(description?.applyValue({ args0 -> args0 }))
        .enabled(enabled?.applyValue({ args0 -> args0 }))
        .eventBatchingConditions(
            eventBatchingConditions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .predicate(predicate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .schedule(schedule?.applyValue({ args0 -> args0 }))
        .startOnCreation(startOnCreation?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .type(type?.applyValue({ args0 -> args0 }))
        .workflowName(workflowName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerArgs].
 */
@PulumiTagMarker
public class TriggerArgsBuilder internal constructor() {
    private var actions: Output<List<TriggerActionArgs>>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var eventBatchingConditions: Output<List<TriggerEventBatchingConditionArgs>>? = null

    private var name: Output<String>? = null

    private var predicate: Output<TriggerPredicateArgs>? = null

    private var schedule: Output<String>? = null

    private var startOnCreation: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var workflowName: Output<String>? = null

    /**
     * @param value List of actions initiated by this trigger when it fires. See Actions Below.
     */
    @JvmName("pgdxcfnlpmcyascg")
    public suspend fun actions(`value`: Output<List<TriggerActionArgs>>) {
        this.actions = value
    }

    @JvmName("cclehpkgcsdnegdp")
    public suspend fun actions(vararg values: Output<TriggerActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values List of actions initiated by this trigger when it fires. See Actions Below.
     */
    @JvmName("qbwnxtownirebrcg")
    public suspend fun actions(values: List<Output<TriggerActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value A description of the new trigger.
     */
    @JvmName("gcocuevdqibtlgap")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Start the trigger. Defaults to `true`.
     */
    @JvmName("vnhqfxrlaghfewdb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    @JvmName("fhofomgbajwbqmqu")
    public suspend fun eventBatchingConditions(`value`: Output<List<TriggerEventBatchingConditionArgs>>) {
        this.eventBatchingConditions = value
    }

    @JvmName("wipphsretwmxfucd")
    public suspend fun eventBatchingConditions(vararg values: Output<TriggerEventBatchingConditionArgs>) {
        this.eventBatchingConditions = Output.all(values.asList())
    }

    /**
     * @param values Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    @JvmName("lnkjnauxkohfropv")
    public suspend fun eventBatchingConditions(values: List<Output<TriggerEventBatchingConditionArgs>>) {
        this.eventBatchingConditions = Output.all(values)
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("vhmhlcejkuxjdmgo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A predicate to specify when the new trigger should fire. Required when trigger type is `CONDITIONAL`. See Predicate Below.
     */
    @JvmName("ebnhfqmcvwfwvwvj")
    public suspend fun predicate(`value`: Output<TriggerPredicateArgs>) {
        this.predicate = value
    }

    /**
     * @param value A cron expression used to specify the schedule. [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html)
     */
    @JvmName("ieedntucunpqhgiv")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Set to true to start `SCHEDULED` and `CONDITIONAL` triggers when created. True is not supported for `ON_DEMAND` triggers.
     */
    @JvmName("cwwhpdiuiknqiijw")
    public suspend fun startOnCreation(`value`: Output<Boolean>) {
        this.startOnCreation = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ukckxhricwmdykbm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of trigger. Valid values are `CONDITIONAL`, `EVENT`, `ON_DEMAND`, and `SCHEDULED`.
     */
    @JvmName("vgowcqcfpwrpqmdw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A workflow to which the trigger should be associated to. Every workflow graph (DAG) needs a starting trigger (`ON_DEMAND` or `SCHEDULED` type) and can contain multiple additional `CONDITIONAL` triggers.
     */
    @JvmName("dkdxnijjmoljqfrk")
    public suspend fun workflowName(`value`: Output<String>) {
        this.workflowName = value
    }

    /**
     * @param value List of actions initiated by this trigger when it fires. See Actions Below.
     */
    @JvmName("qbymorwflhwagyrn")
    public suspend fun actions(`value`: List<TriggerActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument List of actions initiated by this trigger when it fires. See Actions Below.
     */
    @JvmName("hpblngvqsustthaa")
    public suspend fun actions(argument: List<suspend TriggerActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument List of actions initiated by this trigger when it fires. See Actions Below.
     */
    @JvmName("shabtiwiyixcwmph")
    public suspend fun actions(vararg argument: suspend TriggerActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TriggerActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument List of actions initiated by this trigger when it fires. See Actions Below.
     */
    @JvmName("yqrpfihlvblidwnn")
    public suspend fun actions(argument: suspend TriggerActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TriggerActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values List of actions initiated by this trigger when it fires. See Actions Below.
     */
    @JvmName("witeqsvkmjntsqmh")
    public suspend fun actions(vararg values: TriggerActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value A description of the new trigger.
     */
    @JvmName("soqnvkqhisgtjdhh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Start the trigger. Defaults to `true`.
     */
    @JvmName("mnyclhwdnonhuxxn")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    @JvmName("wlikhflpsgjcgmvb")
    public suspend fun eventBatchingConditions(`value`: List<TriggerEventBatchingConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventBatchingConditions = mapped
    }

    /**
     * @param argument Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    @JvmName("yvhlqvkflgfbxdsv")
    public suspend fun eventBatchingConditions(argument: List<suspend TriggerEventBatchingConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerEventBatchingConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventBatchingConditions = mapped
    }

    /**
     * @param argument Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    @JvmName("xjwovhvhyjpwkfna")
    public suspend fun eventBatchingConditions(vararg argument: suspend TriggerEventBatchingConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TriggerEventBatchingConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventBatchingConditions = mapped
    }

    /**
     * @param argument Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    @JvmName("dhjceyqhujtdabqi")
    public suspend fun eventBatchingConditions(argument: suspend TriggerEventBatchingConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TriggerEventBatchingConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eventBatchingConditions = mapped
    }

    /**
     * @param values Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. See Event Batching Condition.
     */
    @JvmName("qoprmyjmxxgyusnw")
    public suspend fun eventBatchingConditions(vararg values: TriggerEventBatchingConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventBatchingConditions = mapped
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("vcnjfoewxrvkorxh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A predicate to specify when the new trigger should fire. Required when trigger type is `CONDITIONAL`. See Predicate Below.
     */
    @JvmName("arofxkkkeigadtqc")
    public suspend fun predicate(`value`: TriggerPredicateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predicate = mapped
    }

    /**
     * @param argument A predicate to specify when the new trigger should fire. Required when trigger type is `CONDITIONAL`. See Predicate Below.
     */
    @JvmName("putayviqytatmnnb")
    public suspend fun predicate(argument: suspend TriggerPredicateArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerPredicateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.predicate = mapped
    }

    /**
     * @param value A cron expression used to specify the schedule. [Time-Based Schedules for Jobs and Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html)
     */
    @JvmName("bbrvapgnwgninuts")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value Set to true to start `SCHEDULED` and `CONDITIONAL` triggers when created. True is not supported for `ON_DEMAND` triggers.
     */
    @JvmName("eexsydruxbwsxkds")
    public suspend fun startOnCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startOnCreation = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nhtkwysvdtgurvmu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("roobhuepnfofslut")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of trigger. Valid values are `CONDITIONAL`, `EVENT`, `ON_DEMAND`, and `SCHEDULED`.
     */
    @JvmName("lsdeqbwbxciidtyc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value A workflow to which the trigger should be associated to. Every workflow graph (DAG) needs a starting trigger (`ON_DEMAND` or `SCHEDULED` type) and can contain multiple additional `CONDITIONAL` triggers.
     */
    @JvmName("vukpukmawyyrgddb")
    public suspend fun workflowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowName = mapped
    }

    internal fun build(): TriggerArgs = TriggerArgs(
        actions = actions,
        description = description,
        enabled = enabled,
        eventBatchingConditions = eventBatchingConditions,
        name = name,
        predicate = predicate,
        schedule = schedule,
        startOnCreation = startOnCreation,
        tags = tags,
        type = type,
        workflowName = workflowName,
    )
}
