@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.UserDefinedFunctionArgs.builder
import com.pulumi.aws.glue.kotlin.inputs.UserDefinedFunctionResourceUriArgs
import com.pulumi.aws.glue.kotlin.inputs.UserDefinedFunctionResourceUriArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Glue User Defined Function Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.CatalogDatabase("example", {name: "my_database"});
 * const exampleUserDefinedFunction = new aws.glue.UserDefinedFunction("example", {
 *     name: "my_func",
 *     catalogId: example.catalogId,
 *     databaseName: example.name,
 *     className: "class",
 *     ownerName: "owner",
 *     ownerType: "GROUP",
 *     resourceUris: [{
 *         resourceType: "ARCHIVE",
 *         uri: "uri",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.CatalogDatabase("example", name="my_database")
 * example_user_defined_function = aws.glue.UserDefinedFunction("example",
 *     name="my_func",
 *     catalog_id=example.catalog_id,
 *     database_name=example.name,
 *     class_name="class",
 *     owner_name="owner",
 *     owner_type="GROUP",
 *     resource_uris=[{
 *         "resource_type": "ARCHIVE",
 *         "uri": "uri",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.CatalogDatabase("example", new()
 *     {
 *         Name = "my_database",
 *     });
 *     var exampleUserDefinedFunction = new Aws.Glue.UserDefinedFunction("example", new()
 *     {
 *         Name = "my_func",
 *         CatalogId = example.CatalogId,
 *         DatabaseName = example.Name,
 *         ClassName = "class",
 *         OwnerName = "owner",
 *         OwnerType = "GROUP",
 *         ResourceUris = new[]
 *         {
 *             new Aws.Glue.Inputs.UserDefinedFunctionResourceUriArgs
 *             {
 *                 ResourceType = "ARCHIVE",
 *                 Uri = "uri",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := glue.NewCatalogDatabase(ctx, "example", &glue.CatalogDatabaseArgs{
 * 			Name: pulumi.String("my_database"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = glue.NewUserDefinedFunction(ctx, "example", &glue.UserDefinedFunctionArgs{
 * 			Name:         pulumi.String("my_func"),
 * 			CatalogId:    example.CatalogId,
 * 			DatabaseName: example.Name,
 * 			ClassName:    pulumi.String("class"),
 * 			OwnerName:    pulumi.String("owner"),
 * 			OwnerType:    pulumi.String("GROUP"),
 * 			ResourceUris: glue.UserDefinedFunctionResourceUriArray{
 * 				&glue.UserDefinedFunctionResourceUriArgs{
 * 					ResourceType: pulumi.String("ARCHIVE"),
 * 					Uri:          pulumi.String("uri"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.CatalogDatabase;
 * import com.pulumi.aws.glue.CatalogDatabaseArgs;
 * import com.pulumi.aws.glue.UserDefinedFunction;
 * import com.pulumi.aws.glue.UserDefinedFunctionArgs;
 * import com.pulumi.aws.glue.inputs.UserDefinedFunctionResourceUriArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CatalogDatabase("example", CatalogDatabaseArgs.builder()
 *             .name("my_database")
 *             .build());
 *         var exampleUserDefinedFunction = new UserDefinedFunction("exampleUserDefinedFunction", UserDefinedFunctionArgs.builder()
 *             .name("my_func")
 *             .catalogId(example.catalogId())
 *             .databaseName(example.name())
 *             .className("class")
 *             .ownerName("owner")
 *             .ownerType("GROUP")
 *             .resourceUris(UserDefinedFunctionResourceUriArgs.builder()
 *                 .resourceType("ARCHIVE")
 *                 .uri("uri")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:CatalogDatabase
 *     properties:
 *       name: my_database
 *   exampleUserDefinedFunction:
 *     type: aws:glue:UserDefinedFunction
 *     name: example
 *     properties:
 *       name: my_func
 *       catalogId: ${example.catalogId}
 *       databaseName: ${example.name}
 *       className: class
 *       ownerName: owner
 *       ownerType: GROUP
 *       resourceUris:
 *         - resourceType: ARCHIVE
 *           uri: uri
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue User Defined Functions using the `catalog_id:database_name:function_name`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 * $ pulumi import aws:glue/userDefinedFunction:UserDefinedFunction func 123456789012:my_database:my_func
 * ```
 * @property catalogId ID of the Glue Catalog to create the function in. If omitted, this defaults to the AWS Account ID.
 * @property className The Java class that contains the function code.
 * @property databaseName The name of the Database to create the Function.
 * @property name The name of the function.
 * @property ownerName The owner of the function.
 * @property ownerType The owner type. can be one of `USER`, `ROLE`, and `GROUP`.
 * @property resourceUris The configuration block for Resource URIs. See resource uris below for more details.
 */
public data class UserDefinedFunctionArgs(
    public val catalogId: Output<String>? = null,
    public val className: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ownerName: Output<String>? = null,
    public val ownerType: Output<String>? = null,
    public val resourceUris: Output<List<UserDefinedFunctionResourceUriArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.UserDefinedFunctionArgs> {
    override fun toJava(): com.pulumi.aws.glue.UserDefinedFunctionArgs =
        com.pulumi.aws.glue.UserDefinedFunctionArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .className(className?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerName(ownerName?.applyValue({ args0 -> args0 }))
            .ownerType(ownerType?.applyValue({ args0 -> args0 }))
            .resourceUris(
                resourceUris?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UserDefinedFunctionArgs].
 */
@PulumiTagMarker
public class UserDefinedFunctionArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var className: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var name: Output<String>? = null

    private var ownerName: Output<String>? = null

    private var ownerType: Output<String>? = null

    private var resourceUris: Output<List<UserDefinedFunctionResourceUriArgs>>? = null

    /**
     * @param value ID of the Glue Catalog to create the function in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("kxgibrypxalqekdw")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value The Java class that contains the function code.
     */
    @JvmName("wdkrxdxmecofekkk")
    public suspend fun className(`value`: Output<String>) {
        this.className = value
    }

    /**
     * @param value The name of the Database to create the Function.
     */
    @JvmName("kedlxowbycjfdbqc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the function.
     */
    @JvmName("pxhxluuhonsrgydp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The owner of the function.
     */
    @JvmName("oalttuvjciwjwmwk")
    public suspend fun ownerName(`value`: Output<String>) {
        this.ownerName = value
    }

    /**
     * @param value The owner type. can be one of `USER`, `ROLE`, and `GROUP`.
     */
    @JvmName("qktvhjolukwsdcwg")
    public suspend fun ownerType(`value`: Output<String>) {
        this.ownerType = value
    }

    /**
     * @param value The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("pnmcaxkvykfxtuve")
    public suspend fun resourceUris(`value`: Output<List<UserDefinedFunctionResourceUriArgs>>) {
        this.resourceUris = value
    }

    @JvmName("ojututypsnfxingf")
    public suspend fun resourceUris(vararg values: Output<UserDefinedFunctionResourceUriArgs>) {
        this.resourceUris = Output.all(values.asList())
    }

    /**
     * @param values The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("rtwrprvfmfdlbcqk")
    public suspend fun resourceUris(values: List<Output<UserDefinedFunctionResourceUriArgs>>) {
        this.resourceUris = Output.all(values)
    }

    /**
     * @param value ID of the Glue Catalog to create the function in. If omitted, this defaults to the AWS Account ID.
     */
    @JvmName("tlghrchaxfgnjbio")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value The Java class that contains the function code.
     */
    @JvmName("ekpjgsnejfbcfysk")
    public suspend fun className(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.className = mapped
    }

    /**
     * @param value The name of the Database to create the Function.
     */
    @JvmName("scinbwufuowvkdsu")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the function.
     */
    @JvmName("hopvbipwrexnivyf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The owner of the function.
     */
    @JvmName("yspfyypxembxtfrc")
    public suspend fun ownerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerName = mapped
    }

    /**
     * @param value The owner type. can be one of `USER`, `ROLE`, and `GROUP`.
     */
    @JvmName("cowdgxmjgivnyjgd")
    public suspend fun ownerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerType = mapped
    }

    /**
     * @param value The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("bsxcrkdvtukinmjc")
    public suspend fun resourceUris(`value`: List<UserDefinedFunctionResourceUriArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUris = mapped
    }

    /**
     * @param argument The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("thcpkupcqecqjwss")
    public suspend fun resourceUris(argument: List<suspend UserDefinedFunctionResourceUriArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserDefinedFunctionResourceUriArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceUris = mapped
    }

    /**
     * @param argument The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("cammpxihpldekixh")
    public suspend fun resourceUris(vararg argument: suspend UserDefinedFunctionResourceUriArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserDefinedFunctionResourceUriArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceUris = mapped
    }

    /**
     * @param argument The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("hyescglybfkxncgt")
    public suspend fun resourceUris(argument: suspend UserDefinedFunctionResourceUriArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            UserDefinedFunctionResourceUriArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceUris = mapped
    }

    /**
     * @param values The configuration block for Resource URIs. See resource uris below for more details.
     */
    @JvmName("qdxligmbgnypjxvj")
    public suspend fun resourceUris(vararg values: UserDefinedFunctionResourceUriArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceUris = mapped
    }

    internal fun build(): UserDefinedFunctionArgs = UserDefinedFunctionArgs(
        catalogId = catalogId,
        className = className,
        databaseName = databaseName,
        name = name,
        ownerName = ownerName,
        ownerType = ownerType,
        resourceUris = resourceUris,
    )
}
