@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin

import com.pulumi.aws.glue.WorkflowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Glue Workflow resource.
 * The workflow graph (DAG) can be build using the `aws.glue.Trigger` resource.
 * See the example below for creating a graph with four nodes (two triggers and two jobs).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.glue.Workflow("example", {name: "example"});
 * const example_start = new aws.glue.Trigger("example-start", {
 *     name: "trigger-start",
 *     type: "ON_DEMAND",
 *     workflowName: example.name,
 *     actions: [{
 *         jobName: "example-job",
 *     }],
 * });
 * const example_inner = new aws.glue.Trigger("example-inner", {
 *     name: "trigger-inner",
 *     type: "CONDITIONAL",
 *     workflowName: example.name,
 *     predicate: {
 *         conditions: [{
 *             jobName: "example-job",
 *             state: "SUCCEEDED",
 *         }],
 *     },
 *     actions: [{
 *         jobName: "another-example-job",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.glue.Workflow("example", name="example")
 * example_start = aws.glue.Trigger("example-start",
 *     name="trigger-start",
 *     type="ON_DEMAND",
 *     workflow_name=example.name,
 *     actions=[{
 *         "job_name": "example-job",
 *     }])
 * example_inner = aws.glue.Trigger("example-inner",
 *     name="trigger-inner",
 *     type="CONDITIONAL",
 *     workflow_name=example.name,
 *     predicate={
 *         "conditions": [{
 *             "job_name": "example-job",
 *             "state": "SUCCEEDED",
 *         }],
 *     },
 *     actions=[{
 *         "job_name": "another-example-job",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Glue.Workflow("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var example_start = new Aws.Glue.Trigger("example-start", new()
 *     {
 *         Name = "trigger-start",
 *         Type = "ON_DEMAND",
 *         WorkflowName = example.Name,
 *         Actions = new[]
 *         {
 *             new Aws.Glue.Inputs.TriggerActionArgs
 *             {
 *                 JobName = "example-job",
 *             },
 *         },
 *     });
 *     var example_inner = new Aws.Glue.Trigger("example-inner", new()
 *     {
 *         Name = "trigger-inner",
 *         Type = "CONDITIONAL",
 *         WorkflowName = example.Name,
 *         Predicate = new Aws.Glue.Inputs.TriggerPredicateArgs
 *         {
 *             Conditions = new[]
 *             {
 *                 new Aws.Glue.Inputs.TriggerPredicateConditionArgs
 *                 {
 *                     JobName = "example-job",
 *                     State = "SUCCEEDED",
 *                 },
 *             },
 *         },
 *         Actions = new[]
 *         {
 *             new Aws.Glue.Inputs.TriggerActionArgs
 *             {
 *                 JobName = "another-example-job",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/glue"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := glue.NewWorkflow(ctx, "example", &glue.WorkflowArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = glue.NewTrigger(ctx, "example-start", &glue.TriggerArgs{
 * 			Name:         pulumi.String("trigger-start"),
 * 			Type:         pulumi.String("ON_DEMAND"),
 * 			WorkflowName: example.Name,
 * 			Actions: glue.TriggerActionArray{
 * 				&glue.TriggerActionArgs{
 * 					JobName: pulumi.String("example-job"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = glue.NewTrigger(ctx, "example-inner", &glue.TriggerArgs{
 * 			Name:         pulumi.String("trigger-inner"),
 * 			Type:         pulumi.String("CONDITIONAL"),
 * 			WorkflowName: example.Name,
 * 			Predicate: &glue.TriggerPredicateArgs{
 * 				Conditions: glue.TriggerPredicateConditionArray{
 * 					&glue.TriggerPredicateConditionArgs{
 * 						JobName: pulumi.String("example-job"),
 * 						State:   pulumi.String("SUCCEEDED"),
 * 					},
 * 				},
 * 			},
 * 			Actions: glue.TriggerActionArray{
 * 				&glue.TriggerActionArgs{
 * 					JobName: pulumi.String("another-example-job"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.glue.Workflow;
 * import com.pulumi.aws.glue.WorkflowArgs;
 * import com.pulumi.aws.glue.Trigger;
 * import com.pulumi.aws.glue.TriggerArgs;
 * import com.pulumi.aws.glue.inputs.TriggerActionArgs;
 * import com.pulumi.aws.glue.inputs.TriggerPredicateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example", WorkflowArgs.builder()
 *             .name("example")
 *             .build());
 *         var example_start = new Trigger("example-start", TriggerArgs.builder()
 *             .name("trigger-start")
 *             .type("ON_DEMAND")
 *             .workflowName(example.name())
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName("example-job")
 *                 .build())
 *             .build());
 *         var example_inner = new Trigger("example-inner", TriggerArgs.builder()
 *             .name("trigger-inner")
 *             .type("CONDITIONAL")
 *             .workflowName(example.name())
 *             .predicate(TriggerPredicateArgs.builder()
 *                 .conditions(TriggerPredicateConditionArgs.builder()
 *                     .jobName("example-job")
 *                     .state("SUCCEEDED")
 *                     .build())
 *                 .build())
 *             .actions(TriggerActionArgs.builder()
 *                 .jobName("another-example-job")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:glue:Workflow
 *     properties:
 *       name: example
 *   example-start:
 *     type: aws:glue:Trigger
 *     properties:
 *       name: trigger-start
 *       type: ON_DEMAND
 *       workflowName: ${example.name}
 *       actions:
 *         - jobName: example-job
 *   example-inner:
 *     type: aws:glue:Trigger
 *     properties:
 *       name: trigger-inner
 *       type: CONDITIONAL
 *       workflowName: ${example.name}
 *       predicate:
 *         conditions:
 *           - jobName: example-job
 *             state: SUCCEEDED
 *       actions:
 *         - jobName: another-example-job
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Glue Workflows using `name`. For example:
 * ```sh
 * $ pulumi import aws:glue/workflow:Workflow MyWorkflow MyWorkflow
 * ```
 * @property defaultRunProperties A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
 * @property description Description of the workflow.
 * @property maxConcurrentRuns Prevents exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.
 * @property name The name you assign to this workflow.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WorkflowArgs(
    public val defaultRunProperties: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val maxConcurrentRuns: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.WorkflowArgs> {
    override fun toJava(): com.pulumi.aws.glue.WorkflowArgs =
        com.pulumi.aws.glue.WorkflowArgs.builder()
            .defaultRunProperties(
                defaultRunProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .maxConcurrentRuns(maxConcurrentRuns?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WorkflowArgs].
 */
@PulumiTagMarker
public class WorkflowArgsBuilder internal constructor() {
    private var defaultRunProperties: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var maxConcurrentRuns: Output<Int>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
     */
    @JvmName("xpxxrhmawfwlbobv")
    public suspend fun defaultRunProperties(`value`: Output<Map<String, String>>) {
        this.defaultRunProperties = value
    }

    /**
     * @param value Description of the workflow.
     */
    @JvmName("mxceitagudipgmyx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Prevents exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.
     */
    @JvmName("xvunfydkfqrvjxhf")
    public suspend fun maxConcurrentRuns(`value`: Output<Int>) {
        this.maxConcurrentRuns = value
    }

    /**
     * @param value The name you assign to this workflow.
     */
    @JvmName("ivtiathmybsbiwew")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("miwlrpdxbctxjnuf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
     */
    @JvmName("avlnnvtrluotowqr")
    public suspend fun defaultRunProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRunProperties = mapped
    }

    /**
     * @param values A map of default run properties for this workflow. These properties are passed to all jobs associated to the workflow.
     */
    @JvmName("iwuwjnxtijiqtbip")
    public fun defaultRunProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRunProperties = mapped
    }

    /**
     * @param value Description of the workflow.
     */
    @JvmName("mqyyorjhotbhqddp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Prevents exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.
     */
    @JvmName("ktslmnmujcgsslia")
    public suspend fun maxConcurrentRuns(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentRuns = mapped
    }

    /**
     * @param value The name you assign to this workflow.
     */
    @JvmName("wndeeoigljwrverq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kajjdsxveowkvhnd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqdtsjlxynbflrbg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkflowArgs = WorkflowArgs(
        defaultRunProperties = defaultRunProperties,
        description = description,
        maxConcurrentRuns = maxConcurrentRuns,
        name = name,
        tags = tags,
    )
}
