@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property permissions The permissions that are granted to the principal.
 * @property principal The principal who is granted permissions.. See `principal` below.
 */
public data class CatalogDatabaseCreateTableDefaultPermissionArgs(
    public val permissions: Output<List<String>>? = null,
    public val principal: Output<CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs = com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionArgs.builder()
        .permissions(permissions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .principal(principal?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CatalogDatabaseCreateTableDefaultPermissionArgs].
 */
@PulumiTagMarker
public class CatalogDatabaseCreateTableDefaultPermissionArgsBuilder internal constructor() {
    private var permissions: Output<List<String>>? = null

    private var principal: Output<CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs>? = null

    /**
     * @param value The permissions that are granted to the principal.
     */
    @JvmName("ndqcjtrffnoaxbii")
    public suspend fun permissions(`value`: Output<List<String>>) {
        this.permissions = value
    }

    @JvmName("dnuahpnunornxkhg")
    public suspend fun permissions(vararg values: Output<String>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values The permissions that are granted to the principal.
     */
    @JvmName("fdxbwrhvtcompfqc")
    public suspend fun permissions(values: List<Output<String>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The principal who is granted permissions.. See `principal` below.
     */
    @JvmName("txjtiiqdfwfcacep")
    public suspend fun principal(`value`: Output<CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs>) {
        this.principal = value
    }

    /**
     * @param value The permissions that are granted to the principal.
     */
    @JvmName("gevsjapdmhquixta")
    public suspend fun permissions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values The permissions that are granted to the principal.
     */
    @JvmName("oxyhgiwuwkeyoyqj")
    public suspend fun permissions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The principal who is granted permissions.. See `principal` below.
     */
    @JvmName("drlhmnokrfvmdeed")
    public suspend fun principal(`value`: CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param argument The principal who is granted permissions.. See `principal` below.
     */
    @JvmName("keqnswcppedlpdun")
    public suspend fun principal(argument: suspend CatalogDatabaseCreateTableDefaultPermissionPrincipalArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogDatabaseCreateTableDefaultPermissionPrincipalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.principal = mapped
    }

    internal fun build(): CatalogDatabaseCreateTableDefaultPermissionArgs =
        CatalogDatabaseCreateTableDefaultPermissionArgs(
            permissions = permissions,
            principal = principal,
        )
}
