@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataLakePrincipalIdentifier An identifier for the Lake Formation principal.
 */
public data class CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs(
    public val dataLakePrincipalIdentifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs =
        com.pulumi.aws.glue.inputs.CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs.builder()
            .dataLakePrincipalIdentifier(dataLakePrincipalIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs].
 */
@PulumiTagMarker
public class CatalogDatabaseCreateTableDefaultPermissionPrincipalArgsBuilder internal constructor() {
    private var dataLakePrincipalIdentifier: Output<String>? = null

    /**
     * @param value An identifier for the Lake Formation principal.
     */
    @JvmName("yqsoslavtmdpnlvo")
    public suspend fun dataLakePrincipalIdentifier(`value`: Output<String>) {
        this.dataLakePrincipalIdentifier = value
    }

    /**
     * @param value An identifier for the Lake Formation principal.
     */
    @JvmName("wnnodlqhqitmewkp")
    public suspend fun dataLakePrincipalIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakePrincipalIdentifier = mapped
    }

    internal fun build(): CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs =
        CatalogDatabaseCreateTableDefaultPermissionPrincipalArgs(
            dataLakePrincipalIdentifier = dataLakePrincipalIdentifier,
        )
}
