@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogDatabaseFederatedDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName Name of the connection to the external metastore.
 * @property identifier Unique identifier for the federated database.
 */
public data class CatalogDatabaseFederatedDatabaseArgs(
    public val connectionName: Output<String>? = null,
    public val identifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogDatabaseFederatedDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogDatabaseFederatedDatabaseArgs =
        com.pulumi.aws.glue.inputs.CatalogDatabaseFederatedDatabaseArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogDatabaseFederatedDatabaseArgs].
 */
@PulumiTagMarker
public class CatalogDatabaseFederatedDatabaseArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var identifier: Output<String>? = null

    /**
     * @param value Name of the connection to the external metastore.
     */
    @JvmName("rcdjtuguasivthcc")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Unique identifier for the federated database.
     */
    @JvmName("igkgdfxjsvarnrws")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Name of the connection to the external metastore.
     */
    @JvmName("wuyrbfxxeedyyogh")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Unique identifier for the federated database.
     */
    @JvmName("qiwchoxswuijjsvf")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    internal fun build(): CatalogDatabaseFederatedDatabaseArgs = CatalogDatabaseFederatedDatabaseArgs(
        connectionName = connectionName,
        identifier = identifier,
    )
}
