@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogDatabaseTargetDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId ID of the Data Catalog in which the database resides.
 * @property databaseName Name of the catalog database.
 * @property region Region of the target database.
 */
public data class CatalogDatabaseTargetDatabaseArgs(
    public val catalogId: Output<String>,
    public val databaseName: Output<String>,
    public val region: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogDatabaseTargetDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogDatabaseTargetDatabaseArgs =
        com.pulumi.aws.glue.inputs.CatalogDatabaseTargetDatabaseArgs.builder()
            .catalogId(catalogId.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogDatabaseTargetDatabaseArgs].
 */
@PulumiTagMarker
public class CatalogDatabaseTargetDatabaseArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var region: Output<String>? = null

    /**
     * @param value ID of the Data Catalog in which the database resides.
     */
    @JvmName("lmnwhasrnlgqvntl")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the catalog database.
     */
    @JvmName("ylhhurgagynlmthc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Region of the target database.
     */
    @JvmName("nsivnicfopwuacai")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value ID of the Data Catalog in which the database resides.
     */
    @JvmName("mxxhgxcxekpchemk")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the catalog database.
     */
    @JvmName("pubmojvtwcfkgwqg")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Region of the target database.
     */
    @JvmName("dmtriaxthxoqsdiv")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): CatalogDatabaseTargetDatabaseArgs = CatalogDatabaseTargetDatabaseArgs(
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        region = region,
    )
}
