@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTablePartitionIndexArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property indexName Name of the partition index.
 * @property indexStatus
 * @property keys Keys for the partition index.
 */
public data class CatalogTablePartitionIndexArgs(
    public val indexName: Output<String>,
    public val indexStatus: Output<String>? = null,
    public val keys: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTablePartitionIndexArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTablePartitionIndexArgs =
        com.pulumi.aws.glue.inputs.CatalogTablePartitionIndexArgs.builder()
            .indexName(indexName.applyValue({ args0 -> args0 }))
            .indexStatus(indexStatus?.applyValue({ args0 -> args0 }))
            .keys(keys.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CatalogTablePartitionIndexArgs].
 */
@PulumiTagMarker
public class CatalogTablePartitionIndexArgsBuilder internal constructor() {
    private var indexName: Output<String>? = null

    private var indexStatus: Output<String>? = null

    private var keys: Output<List<String>>? = null

    /**
     * @param value Name of the partition index.
     */
    @JvmName("slnobqgqavxiusln")
    public suspend fun indexName(`value`: Output<String>) {
        this.indexName = value
    }

    /**
     * @param value
     */
    @JvmName("cskbntcjnjbayivi")
    public suspend fun indexStatus(`value`: Output<String>) {
        this.indexStatus = value
    }

    /**
     * @param value Keys for the partition index.
     */
    @JvmName("etoycsjldxjnsnhk")
    public suspend fun keys(`value`: Output<List<String>>) {
        this.keys = value
    }

    @JvmName("fyircupkcnpnvoft")
    public suspend fun keys(vararg values: Output<String>) {
        this.keys = Output.all(values.asList())
    }

    /**
     * @param values Keys for the partition index.
     */
    @JvmName("lenbdfwksurfkyev")
    public suspend fun keys(values: List<Output<String>>) {
        this.keys = Output.all(values)
    }

    /**
     * @param value Name of the partition index.
     */
    @JvmName("sdmleqsnxbgifyry")
    public suspend fun indexName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexName = mapped
    }

    /**
     * @param value
     */
    @JvmName("dpcryassmqfxulmm")
    public suspend fun indexStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexStatus = mapped
    }

    /**
     * @param value Keys for the partition index.
     */
    @JvmName("qcoswgblcujwmevy")
    public suspend fun keys(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param values Keys for the partition index.
     */
    @JvmName("lgrlgilrsvkkfoni")
    public suspend fun keys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    internal fun build(): CatalogTablePartitionIndexArgs = CatalogTablePartitionIndexArgs(
        indexName = indexName ?: throw PulumiNullFieldException("indexName"),
        indexStatus = indexStatus,
        keys = keys ?: throw PulumiNullFieldException("keys"),
    )
}
