@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property additionalLocations List of locations that point to the path where a Delta table is located.
 * @property bucketColumns List of reducer grouping columns, clustering columns, and bucketing columns in the table.
 * @property columns Configuration block for columns in the table. See `columns` below.
 * @property compressed Whether the data in the table is compressed.
 * @property inputFormat Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
 * @property location Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
 * @property numberOfBuckets Must be specified if the table contains any dimension columns.
 * @property outputFormat Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
 * @property parameters User-supplied properties in key-value form.
 * @property schemaReference Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
 * @property serDeInfo Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
 * @property skewedInfo Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
 * @property sortColumns Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
 * @property storedAsSubDirectories Whether the table data is stored in subdirectories.
 */
public data class CatalogTableStorageDescriptorArgs(
    public val additionalLocations: Output<List<String>>? = null,
    public val bucketColumns: Output<List<String>>? = null,
    public val columns: Output<List<CatalogTableStorageDescriptorColumnArgs>>? = null,
    public val compressed: Output<Boolean>? = null,
    public val inputFormat: Output<String>? = null,
    public val location: Output<String>? = null,
    public val numberOfBuckets: Output<Int>? = null,
    public val outputFormat: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val schemaReference: Output<CatalogTableStorageDescriptorSchemaReferenceArgs>? = null,
    public val serDeInfo: Output<CatalogTableStorageDescriptorSerDeInfoArgs>? = null,
    public val skewedInfo: Output<CatalogTableStorageDescriptorSkewedInfoArgs>? = null,
    public val sortColumns: Output<List<CatalogTableStorageDescriptorSortColumnArgs>>? = null,
    public val storedAsSubDirectories: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs =
        com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorArgs.builder()
            .additionalLocations(additionalLocations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bucketColumns(bucketColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .compressed(compressed?.applyValue({ args0 -> args0 }))
            .inputFormat(inputFormat?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .numberOfBuckets(numberOfBuckets?.applyValue({ args0 -> args0 }))
            .outputFormat(outputFormat?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .schemaReference(schemaReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serDeInfo(serDeInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .skewedInfo(skewedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sortColumns(
                sortColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storedAsSubDirectories(storedAsSubDirectories?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableStorageDescriptorArgs].
 */
@PulumiTagMarker
public class CatalogTableStorageDescriptorArgsBuilder internal constructor() {
    private var additionalLocations: Output<List<String>>? = null

    private var bucketColumns: Output<List<String>>? = null

    private var columns: Output<List<CatalogTableStorageDescriptorColumnArgs>>? = null

    private var compressed: Output<Boolean>? = null

    private var inputFormat: Output<String>? = null

    private var location: Output<String>? = null

    private var numberOfBuckets: Output<Int>? = null

    private var outputFormat: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var schemaReference: Output<CatalogTableStorageDescriptorSchemaReferenceArgs>? = null

    private var serDeInfo: Output<CatalogTableStorageDescriptorSerDeInfoArgs>? = null

    private var skewedInfo: Output<CatalogTableStorageDescriptorSkewedInfoArgs>? = null

    private var sortColumns: Output<List<CatalogTableStorageDescriptorSortColumnArgs>>? = null

    private var storedAsSubDirectories: Output<Boolean>? = null

    /**
     * @param value List of locations that point to the path where a Delta table is located.
     */
    @JvmName("ljtvevetlmhvpxid")
    public suspend fun additionalLocations(`value`: Output<List<String>>) {
        this.additionalLocations = value
    }

    @JvmName("hkyworsmodohnmgd")
    public suspend fun additionalLocations(vararg values: Output<String>) {
        this.additionalLocations = Output.all(values.asList())
    }

    /**
     * @param values List of locations that point to the path where a Delta table is located.
     */
    @JvmName("hdwdyoyaqtkkcsgd")
    public suspend fun additionalLocations(values: List<Output<String>>) {
        this.additionalLocations = Output.all(values)
    }

    /**
     * @param value List of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("hoxqitwkybccnbin")
    public suspend fun bucketColumns(`value`: Output<List<String>>) {
        this.bucketColumns = value
    }

    @JvmName("rpwsstnjqnfpywgu")
    public suspend fun bucketColumns(vararg values: Output<String>) {
        this.bucketColumns = Output.all(values.asList())
    }

    /**
     * @param values List of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("prlonhoyaunaaaxc")
    public suspend fun bucketColumns(values: List<Output<String>>) {
        this.bucketColumns = Output.all(values)
    }

    /**
     * @param value Configuration block for columns in the table. See `columns` below.
     */
    @JvmName("vwrospvofuwugjct")
    public suspend fun columns(`value`: Output<List<CatalogTableStorageDescriptorColumnArgs>>) {
        this.columns = value
    }

    @JvmName("rvkbgaccncfnvsek")
    public suspend fun columns(vararg values: Output<CatalogTableStorageDescriptorColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for columns in the table. See `columns` below.
     */
    @JvmName("uxlyuwiawuqmusin")
    public suspend fun columns(values: List<Output<CatalogTableStorageDescriptorColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Whether the data in the table is compressed.
     */
    @JvmName("hilsnjtcqbjkmfxl")
    public suspend fun compressed(`value`: Output<Boolean>) {
        this.compressed = value
    }

    /**
     * @param value Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
     */
    @JvmName("ikkmsxvdlttqbudp")
    public suspend fun inputFormat(`value`: Output<String>) {
        this.inputFormat = value
    }

    /**
     * @param value Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
     */
    @JvmName("kcbluvgtjdeeqauu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Must be specified if the table contains any dimension columns.
     */
    @JvmName("bugowneqkndeqols")
    public suspend fun numberOfBuckets(`value`: Output<Int>) {
        this.numberOfBuckets = value
    }

    /**
     * @param value Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
     */
    @JvmName("brfxpvvfybdpkbbk")
    public suspend fun outputFormat(`value`: Output<String>) {
        this.outputFormat = value
    }

    /**
     * @param value User-supplied properties in key-value form.
     */
    @JvmName("ccmndhrnyjycshbt")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
     */
    @JvmName("vplykiwxtmnriflv")
    public suspend fun schemaReference(`value`: Output<CatalogTableStorageDescriptorSchemaReferenceArgs>) {
        this.schemaReference = value
    }

    /**
     * @param value Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
     */
    @JvmName("pbvjlyvuakwptxge")
    public suspend fun serDeInfo(`value`: Output<CatalogTableStorageDescriptorSerDeInfoArgs>) {
        this.serDeInfo = value
    }

    /**
     * @param value Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
     */
    @JvmName("pemkocmbbsscijqa")
    public suspend fun skewedInfo(`value`: Output<CatalogTableStorageDescriptorSkewedInfoArgs>) {
        this.skewedInfo = value
    }

    /**
     * @param value Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
     */
    @JvmName("bbxlgsrltturlnnj")
    public suspend fun sortColumns(`value`: Output<List<CatalogTableStorageDescriptorSortColumnArgs>>) {
        this.sortColumns = value
    }

    @JvmName("koekknxyekndikta")
    public suspend fun sortColumns(vararg values: Output<CatalogTableStorageDescriptorSortColumnArgs>) {
        this.sortColumns = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
     */
    @JvmName("gmvtkegvmtwwvfho")
    public suspend fun sortColumns(values: List<Output<CatalogTableStorageDescriptorSortColumnArgs>>) {
        this.sortColumns = Output.all(values)
    }

    /**
     * @param value Whether the table data is stored in subdirectories.
     */
    @JvmName("sgdkrajutftlxrya")
    public suspend fun storedAsSubDirectories(`value`: Output<Boolean>) {
        this.storedAsSubDirectories = value
    }

    /**
     * @param value List of locations that point to the path where a Delta table is located.
     */
    @JvmName("bgkjmqwxanmbobvt")
    public suspend fun additionalLocations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalLocations = mapped
    }

    /**
     * @param values List of locations that point to the path where a Delta table is located.
     */
    @JvmName("xiemnjikdtcxvhdm")
    public suspend fun additionalLocations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalLocations = mapped
    }

    /**
     * @param value List of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("uupwhohlkubcqsqu")
    public suspend fun bucketColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketColumns = mapped
    }

    /**
     * @param values List of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("mynybstlhtfttvrf")
    public suspend fun bucketColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketColumns = mapped
    }

    /**
     * @param value Configuration block for columns in the table. See `columns` below.
     */
    @JvmName("xymkrfdlscafobag")
    public suspend fun columns(`value`: List<CatalogTableStorageDescriptorColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument Configuration block for columns in the table. See `columns` below.
     */
    @JvmName("gvdkvufywnryfxof")
    public suspend fun columns(argument: List<suspend CatalogTableStorageDescriptorColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogTableStorageDescriptorColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Configuration block for columns in the table. See `columns` below.
     */
    @JvmName("njhqplbnxmtgjswn")
    public suspend fun columns(vararg argument: suspend CatalogTableStorageDescriptorColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CatalogTableStorageDescriptorColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Configuration block for columns in the table. See `columns` below.
     */
    @JvmName("mmfkihfctijfmoui")
    public suspend fun columns(argument: suspend CatalogTableStorageDescriptorColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogTableStorageDescriptorColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values Configuration block for columns in the table. See `columns` below.
     */
    @JvmName("xctuynsiqipucnsh")
    public suspend fun columns(vararg values: CatalogTableStorageDescriptorColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value Whether the data in the table is compressed.
     */
    @JvmName("lkmukqfmaqjsmnap")
    public suspend fun compressed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressed = mapped
    }

    /**
     * @param value Input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
     */
    @JvmName("ddjcsmcpvekontaq")
    public suspend fun inputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputFormat = mapped
    }

    /**
     * @param value Physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
     */
    @JvmName("gspdrwggqqwjfqsa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Must be specified if the table contains any dimension columns.
     */
    @JvmName("gcyleofheyhqlyvx")
    public suspend fun numberOfBuckets(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfBuckets = mapped
    }

    /**
     * @param value Output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
     */
    @JvmName("eohrdixholxtkqfk")
    public suspend fun outputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputFormat = mapped
    }

    /**
     * @param value User-supplied properties in key-value form.
     */
    @JvmName("eyxstaeoujqxghsg")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values User-supplied properties in key-value form.
     */
    @JvmName("yxgbiwgfjvktrlwl")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
     */
    @JvmName("dpcrwpgpplpqgriv")
    public suspend fun schemaReference(`value`: CatalogTableStorageDescriptorSchemaReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaReference = mapped
    }

    /**
     * @param argument Object that references a schema stored in the AWS Glue Schema Registry. When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference. See Schema Reference below.
     */
    @JvmName("kckjwqruywtrplbt")
    public suspend fun schemaReference(argument: suspend CatalogTableStorageDescriptorSchemaReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableStorageDescriptorSchemaReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.schemaReference = mapped
    }

    /**
     * @param value Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
     */
    @JvmName("wpkallteaqhpifvs")
    public suspend fun serDeInfo(`value`: CatalogTableStorageDescriptorSerDeInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serDeInfo = mapped
    }

    /**
     * @param argument Configuration block for serialization and deserialization ("SerDe") information. See `ser_de_info` below.
     */
    @JvmName("bjewflihtjefyfmb")
    public suspend fun serDeInfo(argument: suspend CatalogTableStorageDescriptorSerDeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableStorageDescriptorSerDeInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serDeInfo = mapped
    }

    /**
     * @param value Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
     */
    @JvmName("uylydijdeackxvge")
    public suspend fun skewedInfo(`value`: CatalogTableStorageDescriptorSkewedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedInfo = mapped
    }

    /**
     * @param argument Configuration block with information about values that appear very frequently in a column (skewed values). See `skewed_info` below.
     */
    @JvmName("ihyxirahjhokmeau")
    public suspend fun skewedInfo(argument: suspend CatalogTableStorageDescriptorSkewedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = CatalogTableStorageDescriptorSkewedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.skewedInfo = mapped
    }

    /**
     * @param value Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
     */
    @JvmName("cimpvjmubkeqjdlv")
    public suspend fun sortColumns(`value`: List<CatalogTableStorageDescriptorSortColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sortColumns = mapped
    }

    /**
     * @param argument Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
     */
    @JvmName("fehuhrchxbrverua")
    public suspend fun sortColumns(argument: List<suspend CatalogTableStorageDescriptorSortColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CatalogTableStorageDescriptorSortColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sortColumns = mapped
    }

    /**
     * @param argument Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
     */
    @JvmName("uhjxjofuhcpatqgl")
    public suspend fun sortColumns(vararg argument: suspend CatalogTableStorageDescriptorSortColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CatalogTableStorageDescriptorSortColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sortColumns = mapped
    }

    /**
     * @param argument Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
     */
    @JvmName("eykhpuwkpwsrpfqb")
    public suspend fun sortColumns(argument: suspend CatalogTableStorageDescriptorSortColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CatalogTableStorageDescriptorSortColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sortColumns = mapped
    }

    /**
     * @param values Configuration block for the sort order of each bucket in the table. See `sort_columns` below.
     */
    @JvmName("vqdqlneinpeynbyu")
    public suspend fun sortColumns(vararg values: CatalogTableStorageDescriptorSortColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sortColumns = mapped
    }

    /**
     * @param value Whether the table data is stored in subdirectories.
     */
    @JvmName("jybbsickvgxgsomj")
    public suspend fun storedAsSubDirectories(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storedAsSubDirectories = mapped
    }

    internal fun build(): CatalogTableStorageDescriptorArgs = CatalogTableStorageDescriptorArgs(
        additionalLocations = additionalLocations,
        bucketColumns = bucketColumns,
        columns = columns,
        compressed = compressed,
        inputFormat = inputFormat,
        location = location,
        numberOfBuckets = numberOfBuckets,
        outputFormat = outputFormat,
        parameters = parameters,
        schemaReference = schemaReference,
        serDeInfo = serDeInfo,
        skewedInfo = skewedInfo,
        sortColumns = sortColumns,
        storedAsSubDirectories = storedAsSubDirectories,
    )
}
