@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
 * @property schemaArn ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
 * @property schemaName Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
 */
public data class CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs(
    public val registryName: Output<String>? = null,
    public val schemaArn: Output<String>? = null,
    public val schemaName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs =
        com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs.builder()
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .schemaArn(schemaArn?.applyValue({ args0 -> args0 }))
            .schemaName(schemaName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs].
 */
@PulumiTagMarker
public class CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgsBuilder internal constructor() {
    private var registryName: Output<String>? = null

    private var schemaArn: Output<String>? = null

    private var schemaName: Output<String>? = null

    /**
     * @param value Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
     */
    @JvmName("lbpjyoopictskjlx")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
     */
    @JvmName("wlnvtfwsjaftcaet")
    public suspend fun schemaArn(`value`: Output<String>) {
        this.schemaArn = value
    }

    /**
     * @param value Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
     */
    @JvmName("khdrdenrlkulrxqc")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value Name of the schema registry that contains the schema. Must be provided when `schema_name` is specified and conflicts with `schema_arn`.
     */
    @JvmName("lfdqoffapromemya")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value ARN of the schema. One of `schema_arn` or `schema_name` has to be provided.
     */
    @JvmName("vpsuvpclngfufbfj")
    public suspend fun schemaArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaArn = mapped
    }

    /**
     * @param value Name of the schema. One of `schema_arn` or `schema_name` has to be provided.
     */
    @JvmName("bvtkqpujffjdsymi")
    public suspend fun schemaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    internal fun build(): CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs =
        CatalogTableStorageDescriptorSchemaReferenceSchemaIdArgs(
            registryName = registryName,
            schemaArn = schemaArn,
            schemaName = schemaName,
        )
}
