@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the SerDe.
 * @property parameters Map of initialization parameters for the SerDe, in key-value form.
 * @property serializationLibrary Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
 */
public data class CatalogTableStorageDescriptorSerDeInfoArgs(
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val serializationLibrary: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs =
        com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSerDeInfoArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .serializationLibrary(serializationLibrary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableStorageDescriptorSerDeInfoArgs].
 */
@PulumiTagMarker
public class CatalogTableStorageDescriptorSerDeInfoArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var serializationLibrary: Output<String>? = null

    /**
     * @param value Name of the SerDe.
     */
    @JvmName("fdrbwniyjviyexlc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of initialization parameters for the SerDe, in key-value form.
     */
    @JvmName("qocshfrpedsakpkr")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
     */
    @JvmName("kbitilvfqjcrxpqy")
    public suspend fun serializationLibrary(`value`: Output<String>) {
        this.serializationLibrary = value
    }

    /**
     * @param value Name of the SerDe.
     */
    @JvmName("cmclnnlnamblpqkc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of initialization parameters for the SerDe, in key-value form.
     */
    @JvmName("lkcmvdddqfeyqbfb")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Map of initialization parameters for the SerDe, in key-value form.
     */
    @JvmName("bmofvpwxffponbuh")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Usually the class that implements the SerDe. An example is `org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe`.
     */
    @JvmName("hlmvccqeftnyglwd")
    public suspend fun serializationLibrary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializationLibrary = mapped
    }

    internal fun build(): CatalogTableStorageDescriptorSerDeInfoArgs =
        CatalogTableStorageDescriptorSerDeInfoArgs(
            name = name,
            parameters = parameters,
            serializationLibrary = serializationLibrary,
        )
}
