@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSortColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property column Name of the column.
 * @property sortOrder Whether the column is sorted in ascending (`1`) or descending order (`0`).
 */
public data class CatalogTableStorageDescriptorSortColumnArgs(
    public val column: Output<String>,
    public val sortOrder: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSortColumnArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSortColumnArgs =
        com.pulumi.aws.glue.inputs.CatalogTableStorageDescriptorSortColumnArgs.builder()
            .column(column.applyValue({ args0 -> args0 }))
            .sortOrder(sortOrder.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableStorageDescriptorSortColumnArgs].
 */
@PulumiTagMarker
public class CatalogTableStorageDescriptorSortColumnArgsBuilder internal constructor() {
    private var column: Output<String>? = null

    private var sortOrder: Output<Int>? = null

    /**
     * @param value Name of the column.
     */
    @JvmName("whrqxpqjowooejib")
    public suspend fun column(`value`: Output<String>) {
        this.column = value
    }

    /**
     * @param value Whether the column is sorted in ascending (`1`) or descending order (`0`).
     */
    @JvmName("fmwlmehqusiwrero")
    public suspend fun sortOrder(`value`: Output<Int>) {
        this.sortOrder = value
    }

    /**
     * @param value Name of the column.
     */
    @JvmName("tptlnyklgobkyqly")
    public suspend fun column(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.column = mapped
    }

    /**
     * @param value Whether the column is sorted in ascending (`1`) or descending order (`0`).
     */
    @JvmName("fpndygyuqkvthmsb")
    public suspend fun sortOrder(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sortOrder = mapped
    }

    internal fun build(): CatalogTableStorageDescriptorSortColumnArgs =
        CatalogTableStorageDescriptorSortColumnArgs(
            column = column ?: throw PulumiNullFieldException("column"),
            sortOrder = sortOrder ?: throw PulumiNullFieldException("sortOrder"),
        )
}
