@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CatalogTableTargetTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId ID of the Data Catalog in which the table resides.
 * @property databaseName Name of the catalog database that contains the target table.
 * @property name Name of the target table.
 * @property region Region of the target table.
 */
public data class CatalogTableTargetTableArgs(
    public val catalogId: Output<String>,
    public val databaseName: Output<String>,
    public val name: Output<String>,
    public val region: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CatalogTableTargetTableArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CatalogTableTargetTableArgs =
        com.pulumi.aws.glue.inputs.CatalogTableTargetTableArgs.builder()
            .catalogId(catalogId.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogTableTargetTableArgs].
 */
@PulumiTagMarker
public class CatalogTableTargetTableArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var name: Output<String>? = null

    private var region: Output<String>? = null

    /**
     * @param value ID of the Data Catalog in which the table resides.
     */
    @JvmName("pvdqnvbpkifjkomf")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the catalog database that contains the target table.
     */
    @JvmName("rtsixmlwtsjtgwcv")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Name of the target table.
     */
    @JvmName("dqvjnswoqfachiic")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Region of the target table.
     */
    @JvmName("cestjatppcrapolr")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value ID of the Data Catalog in which the table resides.
     */
    @JvmName("sbkngpxassqubiyl")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the catalog database that contains the target table.
     */
    @JvmName("imdwupgojeantati")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Name of the target table.
     */
    @JvmName("rsvynoyqrpfjdphv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Region of the target table.
     */
    @JvmName("ojkngepumqkinypn")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): CatalogTableTargetTableArgs = CatalogTableTargetTableArgs(
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
        region = region,
    )
}
