@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowSingleColumn Enables the processing of files that contain only one column.
 * @property containsHeader Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
 * @property customDatatypeConfigured Enables the custom datatype to be configured.
 * @property customDatatypes A list of supported custom datatypes. Valid values are `BINARY`, `BOOLEAN`, `DATE`, `DECIMAL`, `DOUBLE`, `FLOAT`, `INT`, `LONG`, `SHORT`, `STRING`, `TIMESTAMP`.
 * @property delimiter The delimiter used in the CSV to separate columns.
 * @property disableValueTrimming Specifies whether to trim column values.
 * @property headers A list of strings representing column names.
 * @property quoteSymbol A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
 * @property serde The SerDe for processing CSV. Valid values are `OpenCSVSerDe`, `LazySimpleSerDe`, `None`.
 */
public data class ClassifierCsvClassifierArgs(
    public val allowSingleColumn: Output<Boolean>? = null,
    public val containsHeader: Output<String>? = null,
    public val customDatatypeConfigured: Output<Boolean>? = null,
    public val customDatatypes: Output<List<String>>? = null,
    public val delimiter: Output<String>? = null,
    public val disableValueTrimming: Output<Boolean>? = null,
    public val headers: Output<List<String>>? = null,
    public val quoteSymbol: Output<String>? = null,
    public val serde: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs =
        com.pulumi.aws.glue.inputs.ClassifierCsvClassifierArgs.builder()
            .allowSingleColumn(allowSingleColumn?.applyValue({ args0 -> args0 }))
            .containsHeader(containsHeader?.applyValue({ args0 -> args0 }))
            .customDatatypeConfigured(customDatatypeConfigured?.applyValue({ args0 -> args0 }))
            .customDatatypes(customDatatypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .delimiter(delimiter?.applyValue({ args0 -> args0 }))
            .disableValueTrimming(disableValueTrimming?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .quoteSymbol(quoteSymbol?.applyValue({ args0 -> args0 }))
            .serde(serde?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassifierCsvClassifierArgs].
 */
@PulumiTagMarker
public class ClassifierCsvClassifierArgsBuilder internal constructor() {
    private var allowSingleColumn: Output<Boolean>? = null

    private var containsHeader: Output<String>? = null

    private var customDatatypeConfigured: Output<Boolean>? = null

    private var customDatatypes: Output<List<String>>? = null

    private var delimiter: Output<String>? = null

    private var disableValueTrimming: Output<Boolean>? = null

    private var headers: Output<List<String>>? = null

    private var quoteSymbol: Output<String>? = null

    private var serde: Output<String>? = null

    /**
     * @param value Enables the processing of files that contain only one column.
     */
    @JvmName("yfeggtmxvjvxjicc")
    public suspend fun allowSingleColumn(`value`: Output<Boolean>) {
        this.allowSingleColumn = value
    }

    /**
     * @param value Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
     */
    @JvmName("xixotqtdwusekrif")
    public suspend fun containsHeader(`value`: Output<String>) {
        this.containsHeader = value
    }

    /**
     * @param value Enables the custom datatype to be configured.
     */
    @JvmName("jsxxxjoqjraruwwb")
    public suspend fun customDatatypeConfigured(`value`: Output<Boolean>) {
        this.customDatatypeConfigured = value
    }

    /**
     * @param value A list of supported custom datatypes. Valid values are `BINARY`, `BOOLEAN`, `DATE`, `DECIMAL`, `DOUBLE`, `FLOAT`, `INT`, `LONG`, `SHORT`, `STRING`, `TIMESTAMP`.
     */
    @JvmName("ggaomsoolyqxgwdx")
    public suspend fun customDatatypes(`value`: Output<List<String>>) {
        this.customDatatypes = value
    }

    @JvmName("nqvowyrxmhkrsnei")
    public suspend fun customDatatypes(vararg values: Output<String>) {
        this.customDatatypes = Output.all(values.asList())
    }

    /**
     * @param values A list of supported custom datatypes. Valid values are `BINARY`, `BOOLEAN`, `DATE`, `DECIMAL`, `DOUBLE`, `FLOAT`, `INT`, `LONG`, `SHORT`, `STRING`, `TIMESTAMP`.
     */
    @JvmName("apvmtdomvedqsyrg")
    public suspend fun customDatatypes(values: List<Output<String>>) {
        this.customDatatypes = Output.all(values)
    }

    /**
     * @param value The delimiter used in the CSV to separate columns.
     */
    @JvmName("phjibnhoeqdueeue")
    public suspend fun delimiter(`value`: Output<String>) {
        this.delimiter = value
    }

    /**
     * @param value Specifies whether to trim column values.
     */
    @JvmName("hpmltrfocpmubtrh")
    public suspend fun disableValueTrimming(`value`: Output<Boolean>) {
        this.disableValueTrimming = value
    }

    /**
     * @param value A list of strings representing column names.
     */
    @JvmName("dctyybqcerfhhnap")
    public suspend fun headers(`value`: Output<List<String>>) {
        this.headers = value
    }

    @JvmName("pahfoouybvsnqwkv")
    public suspend fun headers(vararg values: Output<String>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values A list of strings representing column names.
     */
    @JvmName("gsqtwlscuevijitv")
    public suspend fun headers(values: List<Output<String>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
     */
    @JvmName("fnxlerpgldcpinnu")
    public suspend fun quoteSymbol(`value`: Output<String>) {
        this.quoteSymbol = value
    }

    /**
     * @param value The SerDe for processing CSV. Valid values are `OpenCSVSerDe`, `LazySimpleSerDe`, `None`.
     */
    @JvmName("mblkmrwkpbxanffk")
    public suspend fun serde(`value`: Output<String>) {
        this.serde = value
    }

    /**
     * @param value Enables the processing of files that contain only one column.
     */
    @JvmName("qmclcjflsjxuuftm")
    public suspend fun allowSingleColumn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSingleColumn = mapped
    }

    /**
     * @param value Indicates whether the CSV file contains a header. This can be one of "ABSENT", "PRESENT", or "UNKNOWN".
     */
    @JvmName("cxxpchiubojycjup")
    public suspend fun containsHeader(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containsHeader = mapped
    }

    /**
     * @param value Enables the custom datatype to be configured.
     */
    @JvmName("nqrfjrvlisvuvnbl")
    public suspend fun customDatatypeConfigured(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDatatypeConfigured = mapped
    }

    /**
     * @param value A list of supported custom datatypes. Valid values are `BINARY`, `BOOLEAN`, `DATE`, `DECIMAL`, `DOUBLE`, `FLOAT`, `INT`, `LONG`, `SHORT`, `STRING`, `TIMESTAMP`.
     */
    @JvmName("sowbrtxltbodrfmp")
    public suspend fun customDatatypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDatatypes = mapped
    }

    /**
     * @param values A list of supported custom datatypes. Valid values are `BINARY`, `BOOLEAN`, `DATE`, `DECIMAL`, `DOUBLE`, `FLOAT`, `INT`, `LONG`, `SHORT`, `STRING`, `TIMESTAMP`.
     */
    @JvmName("qebwjnpxoggyydhb")
    public suspend fun customDatatypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDatatypes = mapped
    }

    /**
     * @param value The delimiter used in the CSV to separate columns.
     */
    @JvmName("rolpgvmegvvbalov")
    public suspend fun delimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delimiter = mapped
    }

    /**
     * @param value Specifies whether to trim column values.
     */
    @JvmName("dekfrwtwpkqqblca")
    public suspend fun disableValueTrimming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableValueTrimming = mapped
    }

    /**
     * @param value A list of strings representing column names.
     */
    @JvmName("ladnvydrwsjeaaca")
    public suspend fun headers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values A list of strings representing column names.
     */
    @JvmName("yowyjmdidudsqshl")
    public suspend fun headers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.
     */
    @JvmName("xftbxlwhdfihfcmx")
    public suspend fun quoteSymbol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quoteSymbol = mapped
    }

    /**
     * @param value The SerDe for processing CSV. Valid values are `OpenCSVSerDe`, `LazySimpleSerDe`, `None`.
     */
    @JvmName("rftblgrxeyjabnfh")
    public suspend fun serde(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serde = mapped
    }

    internal fun build(): ClassifierCsvClassifierArgs = ClassifierCsvClassifierArgs(
        allowSingleColumn = allowSingleColumn,
        containsHeader = containsHeader,
        customDatatypeConfigured = customDatatypeConfigured,
        customDatatypes = customDatatypes,
        delimiter = delimiter,
        disableValueTrimming = disableValueTrimming,
        headers = headers,
        quoteSymbol = quoteSymbol,
        serde = serde,
    )
}
