@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property classification An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
 * @property customPatterns Custom grok patterns used by this classifier.
 * @property grokPattern The grok pattern used by this classifier.
 */
public data class ClassifierGrokClassifierArgs(
    public val classification: Output<String>,
    public val customPatterns: Output<String>? = null,
    public val grokPattern: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs =
        com.pulumi.aws.glue.inputs.ClassifierGrokClassifierArgs.builder()
            .classification(classification.applyValue({ args0 -> args0 }))
            .customPatterns(customPatterns?.applyValue({ args0 -> args0 }))
            .grokPattern(grokPattern.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassifierGrokClassifierArgs].
 */
@PulumiTagMarker
public class ClassifierGrokClassifierArgsBuilder internal constructor() {
    private var classification: Output<String>? = null

    private var customPatterns: Output<String>? = null

    private var grokPattern: Output<String>? = null

    /**
     * @param value An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
     */
    @JvmName("elbwiemcjyqhoktm")
    public suspend fun classification(`value`: Output<String>) {
        this.classification = value
    }

    /**
     * @param value Custom grok patterns used by this classifier.
     */
    @JvmName("sepvkjporbwflfkv")
    public suspend fun customPatterns(`value`: Output<String>) {
        this.customPatterns = value
    }

    /**
     * @param value The grok pattern used by this classifier.
     */
    @JvmName("nkwjoslctwiiqphi")
    public suspend fun grokPattern(`value`: Output<String>) {
        this.grokPattern = value
    }

    /**
     * @param value An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
     */
    @JvmName("kwmodgkfhckadxlv")
    public suspend fun classification(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value Custom grok patterns used by this classifier.
     */
    @JvmName("imrcuppufkmgmnnm")
    public suspend fun customPatterns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPatterns = mapped
    }

    /**
     * @param value The grok pattern used by this classifier.
     */
    @JvmName("qtuouabjejkmjbkw")
    public suspend fun grokPattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grokPattern = mapped
    }

    internal fun build(): ClassifierGrokClassifierArgs = ClassifierGrokClassifierArgs(
        classification = classification ?: throw PulumiNullFieldException("classification"),
        customPatterns = customPatterns,
        grokPattern = grokPattern ?: throw PulumiNullFieldException("grokPattern"),
    )
}
