@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property classification An identifier of the data format that the classifier matches.
 * @property rowTag The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
 */
public data class ClassifierXmlClassifierArgs(
    public val classification: Output<String>,
    public val rowTag: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs =
        com.pulumi.aws.glue.inputs.ClassifierXmlClassifierArgs.builder()
            .classification(classification.applyValue({ args0 -> args0 }))
            .rowTag(rowTag.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClassifierXmlClassifierArgs].
 */
@PulumiTagMarker
public class ClassifierXmlClassifierArgsBuilder internal constructor() {
    private var classification: Output<String>? = null

    private var rowTag: Output<String>? = null

    /**
     * @param value An identifier of the data format that the classifier matches.
     */
    @JvmName("rvedibiyrdifhixv")
    public suspend fun classification(`value`: Output<String>) {
        this.classification = value
    }

    /**
     * @param value The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
     */
    @JvmName("ykflrreuebffftxl")
    public suspend fun rowTag(`value`: Output<String>) {
        this.rowTag = value
    }

    /**
     * @param value An identifier of the data format that the classifier matches.
     */
    @JvmName("dpkyxsxeopeagfih")
    public suspend fun classification(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.classification = mapped
    }

    /**
     * @param value The XML tag designating the element that contains each record in an XML document being parsed. Note that this cannot identify a self-closing element (closed by `/>`). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, `<row item_a="A" item_b="B"></row>` is okay, but `<row item_a="A" item_b="B" />` is not).
     */
    @JvmName("ebemtehcmguhfgoi")
    public suspend fun rowTag(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rowTag = mapped
    }

    internal fun build(): ClassifierXmlClassifierArgs = ClassifierXmlClassifierArgs(
        classification = classification ?: throw PulumiNullFieldException("classification"),
        rowTag = rowTag ?: throw PulumiNullFieldException("rowTag"),
    )
}
