@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.ConnectionPhysicalConnectionRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZone The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
 * @property securityGroupIdLists The security group ID list used by the connection.
 * @property subnetId The subnet ID used by the connection.
 */
public data class ConnectionPhysicalConnectionRequirementsArgs(
    public val availabilityZone: Output<String>? = null,
    public val securityGroupIdLists: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.ConnectionPhysicalConnectionRequirementsArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.ConnectionPhysicalConnectionRequirementsArgs =
        com.pulumi.aws.glue.inputs.ConnectionPhysicalConnectionRequirementsArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .securityGroupIdLists(securityGroupIdLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionPhysicalConnectionRequirementsArgs].
 */
@PulumiTagMarker
public class ConnectionPhysicalConnectionRequirementsArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var securityGroupIdLists: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
     */
    @JvmName("gbsixbirhoujvmos")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The security group ID list used by the connection.
     */
    @JvmName("woemqlirgrqtfxni")
    public suspend fun securityGroupIdLists(`value`: Output<List<String>>) {
        this.securityGroupIdLists = value
    }

    @JvmName("qtcfamujjvwehfcl")
    public suspend fun securityGroupIdLists(vararg values: Output<String>) {
        this.securityGroupIdLists = Output.all(values.asList())
    }

    /**
     * @param values The security group ID list used by the connection.
     */
    @JvmName("schfaggopnxjwftn")
    public suspend fun securityGroupIdLists(values: List<Output<String>>) {
        this.securityGroupIdLists = Output.all(values)
    }

    /**
     * @param value The subnet ID used by the connection.
     */
    @JvmName("gpaupsfyjelhaxil")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The availability zone of the connection. This field is redundant and implied by `subnet_id`, but is currently an api requirement.
     */
    @JvmName("qxxnqvugktsmpctt")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The security group ID list used by the connection.
     */
    @JvmName("sxjwytyjstnvnujf")
    public suspend fun securityGroupIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIdLists = mapped
    }

    /**
     * @param values The security group ID list used by the connection.
     */
    @JvmName("hxbvuhachlordfkn")
    public suspend fun securityGroupIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIdLists = mapped
    }

    /**
     * @param value The subnet ID used by the connection.
     */
    @JvmName("owoytebhaxqdrmst")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): ConnectionPhysicalConnectionRequirementsArgs =
        ConnectionPhysicalConnectionRequirementsArgs(
            availabilityZone = availabilityZone,
            securityGroupIdLists = securityGroupIdLists,
            subnetId = subnetId,
        )
}
