@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerDeltaTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the connection to use to connect to the Delta table target.
 * @property createNativeDeltaTable Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
 * @property deltaTables A list of the Amazon S3 paths to the Delta tables.
 * @property writeManifest Specifies whether to write the manifest files to the Delta table path.
 */
public data class CrawlerDeltaTargetArgs(
    public val connectionName: Output<String>? = null,
    public val createNativeDeltaTable: Output<Boolean>? = null,
    public val deltaTables: Output<List<String>>,
    public val writeManifest: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerDeltaTargetArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerDeltaTargetArgs =
        com.pulumi.aws.glue.inputs.CrawlerDeltaTargetArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .createNativeDeltaTable(createNativeDeltaTable?.applyValue({ args0 -> args0 }))
            .deltaTables(deltaTables.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .writeManifest(writeManifest.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerDeltaTargetArgs].
 */
@PulumiTagMarker
public class CrawlerDeltaTargetArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var createNativeDeltaTable: Output<Boolean>? = null

    private var deltaTables: Output<List<String>>? = null

    private var writeManifest: Output<Boolean>? = null

    /**
     * @param value The name of the connection to use to connect to the Delta table target.
     */
    @JvmName("hhfsjjirlqstjxwl")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
     */
    @JvmName("vukpqksipgnmhpxt")
    public suspend fun createNativeDeltaTable(`value`: Output<Boolean>) {
        this.createNativeDeltaTable = value
    }

    /**
     * @param value A list of the Amazon S3 paths to the Delta tables.
     */
    @JvmName("sapeuqtgsbyicqgn")
    public suspend fun deltaTables(`value`: Output<List<String>>) {
        this.deltaTables = value
    }

    @JvmName("xjdlrrcgnahcunyy")
    public suspend fun deltaTables(vararg values: Output<String>) {
        this.deltaTables = Output.all(values.asList())
    }

    /**
     * @param values A list of the Amazon S3 paths to the Delta tables.
     */
    @JvmName("wqruivkixchsitcj")
    public suspend fun deltaTables(values: List<Output<String>>) {
        this.deltaTables = Output.all(values)
    }

    /**
     * @param value Specifies whether to write the manifest files to the Delta table path.
     */
    @JvmName("qhhjpdjsniebecmt")
    public suspend fun writeManifest(`value`: Output<Boolean>) {
        this.writeManifest = value
    }

    /**
     * @param value The name of the connection to use to connect to the Delta table target.
     */
    @JvmName("qdiclvibkcuuxpvr")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
     */
    @JvmName("gayureliievokahr")
    public suspend fun createNativeDeltaTable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createNativeDeltaTable = mapped
    }

    /**
     * @param value A list of the Amazon S3 paths to the Delta tables.
     */
    @JvmName("ngosmvhlkhemduqd")
    public suspend fun deltaTables(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deltaTables = mapped
    }

    /**
     * @param values A list of the Amazon S3 paths to the Delta tables.
     */
    @JvmName("wiuxtqcpcwousvei")
    public suspend fun deltaTables(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deltaTables = mapped
    }

    /**
     * @param value Specifies whether to write the manifest files to the Delta table path.
     */
    @JvmName("dhisasbnkaljbbft")
    public suspend fun writeManifest(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeManifest = mapped
    }

    internal fun build(): CrawlerDeltaTargetArgs = CrawlerDeltaTargetArgs(
        connectionName = connectionName,
        createNativeDeltaTable = createNativeDeltaTable,
        deltaTables = deltaTables ?: throw PulumiNullFieldException("deltaTables"),
        writeManifest = writeManifest ?: throw PulumiNullFieldException("writeManifest"),
    )
}
