@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerDynamodbTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property path The name of the DynamoDB table to crawl.
 * @property scanAll Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.  defaults to `true`.
 * @property scanRate The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
 */
public data class CrawlerDynamodbTargetArgs(
    public val path: Output<String>,
    public val scanAll: Output<Boolean>? = null,
    public val scanRate: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerDynamodbTargetArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerDynamodbTargetArgs =
        com.pulumi.aws.glue.inputs.CrawlerDynamodbTargetArgs.builder()
            .path(path.applyValue({ args0 -> args0 }))
            .scanAll(scanAll?.applyValue({ args0 -> args0 }))
            .scanRate(scanRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerDynamodbTargetArgs].
 */
@PulumiTagMarker
public class CrawlerDynamodbTargetArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var scanAll: Output<Boolean>? = null

    private var scanRate: Output<Double>? = null

    /**
     * @param value The name of the DynamoDB table to crawl.
     */
    @JvmName("ojmpuylhklqmhmhu")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.  defaults to `true`.
     */
    @JvmName("xogppdovvknvwuet")
    public suspend fun scanAll(`value`: Output<Boolean>) {
        this.scanAll = value
    }

    /**
     * @param value The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
     */
    @JvmName("xnykgxnsyldukavb")
    public suspend fun scanRate(`value`: Output<Double>) {
        this.scanRate = value
    }

    /**
     * @param value The name of the DynamoDB table to crawl.
     */
    @JvmName("qpjvpuunbtpdcjvl")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.  defaults to `true`.
     */
    @JvmName("ppcxhtobaojjtieg")
    public suspend fun scanAll(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanAll = mapped
    }

    /**
     * @param value The percentage of the configured read capacity units to use by the AWS Glue crawler. The valid values are null or a value between 0.1 to 1.5.
     */
    @JvmName("fjilwmbwpaxcdgqd")
    public suspend fun scanRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanRate = mapped
    }

    internal fun build(): CrawlerDynamodbTargetArgs = CrawlerDynamodbTargetArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        scanAll = scanAll,
        scanRate = scanRate,
    )
}
