@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerHudiTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the connection to use to connect to the Hudi target.
 * @property exclusions A list of glob patterns used to exclude from the crawl.
 * @property maximumTraversalDepth The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in your Amazon S3 path. Used to limit the crawler run time. Valid values are between `1` and `20`.
 * @property paths One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix.
 */
public data class CrawlerHudiTargetArgs(
    public val connectionName: Output<String>? = null,
    public val exclusions: Output<List<String>>? = null,
    public val maximumTraversalDepth: Output<Int>,
    public val paths: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerHudiTargetArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerHudiTargetArgs =
        com.pulumi.aws.glue.inputs.CrawlerHudiTargetArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .exclusions(exclusions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maximumTraversalDepth(maximumTraversalDepth.applyValue({ args0 -> args0 }))
            .paths(paths.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CrawlerHudiTargetArgs].
 */
@PulumiTagMarker
public class CrawlerHudiTargetArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var exclusions: Output<List<String>>? = null

    private var maximumTraversalDepth: Output<Int>? = null

    private var paths: Output<List<String>>? = null

    /**
     * @param value The name of the connection to use to connect to the Hudi target.
     */
    @JvmName("wvadqyoatliunmhr")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("jatkygjefjbosthl")
    public suspend fun exclusions(`value`: Output<List<String>>) {
        this.exclusions = value
    }

    @JvmName("fnbrgitnolvvfgod")
    public suspend fun exclusions(vararg values: Output<String>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("gamqsfisstvlnuol")
    public suspend fun exclusions(values: List<Output<String>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in your Amazon S3 path. Used to limit the crawler run time. Valid values are between `1` and `20`.
     */
    @JvmName("rxesgjyvodqmouwv")
    public suspend fun maximumTraversalDepth(`value`: Output<Int>) {
        this.maximumTraversalDepth = value
    }

    /**
     * @param value One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix.
     */
    @JvmName("hxiotjchmjfmxewe")
    public suspend fun paths(`value`: Output<List<String>>) {
        this.paths = value
    }

    @JvmName("dnhvcfbdaypsbrwu")
    public suspend fun paths(vararg values: Output<String>) {
        this.paths = Output.all(values.asList())
    }

    /**
     * @param values One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix.
     */
    @JvmName("lbsyvvewclvwgklu")
    public suspend fun paths(values: List<Output<String>>) {
        this.paths = Output.all(values)
    }

    /**
     * @param value The name of the connection to use to connect to the Hudi target.
     */
    @JvmName("ygtrtrmiiqmyrnwr")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("eausxjndqgewsfoa")
    public suspend fun exclusions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param values A list of glob patterns used to exclude from the crawl.
     */
    @JvmName("fwaoveawlytsajph")
    public suspend fun exclusions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Hudi metadata folder in your Amazon S3 path. Used to limit the crawler run time. Valid values are between `1` and `20`.
     */
    @JvmName("pgpwwthcgstwalxn")
    public suspend fun maximumTraversalDepth(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maximumTraversalDepth = mapped
    }

    /**
     * @param value One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix.
     */
    @JvmName("dbtofpuiknofeqws")
    public suspend fun paths(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param values One or more Amazon S3 paths that contains Hudi metadata folders as s3://bucket/prefix.
     */
    @JvmName("achtgvuoswhxfcpl")
    public suspend fun paths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    internal fun build(): CrawlerHudiTargetArgs = CrawlerHudiTargetArgs(
        connectionName = connectionName,
        exclusions = exclusions,
        maximumTraversalDepth = maximumTraversalDepth ?: throw
            PulumiNullFieldException("maximumTraversalDepth"),
        paths = paths ?: throw PulumiNullFieldException("paths"),
    )
}
