@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerMongodbTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
 * @property path The path of the Amazon DocumentDB or MongoDB target (database/collection).
 * @property scanAll Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
 */
public data class CrawlerMongodbTargetArgs(
    public val connectionName: Output<String>,
    public val path: Output<String>,
    public val scanAll: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerMongodbTargetArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerMongodbTargetArgs =
        com.pulumi.aws.glue.inputs.CrawlerMongodbTargetArgs.builder()
            .connectionName(connectionName.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 }))
            .scanAll(scanAll?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerMongodbTargetArgs].
 */
@PulumiTagMarker
public class CrawlerMongodbTargetArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var path: Output<String>? = null

    private var scanAll: Output<Boolean>? = null

    /**
     * @param value The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
     */
    @JvmName("iymhhowgduxtfhjc")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value The path of the Amazon DocumentDB or MongoDB target (database/collection).
     */
    @JvmName("shxlvsrdwgygpcfk")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
     */
    @JvmName("yvnitsejojbpjdwc")
    public suspend fun scanAll(`value`: Output<Boolean>) {
        this.scanAll = value
    }

    /**
     * @param value The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
     */
    @JvmName("fivasnxxtjfacfoi")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value The path of the Amazon DocumentDB or MongoDB target (database/collection).
     */
    @JvmName("rtoqqatyofvnnqpy")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table. Default value is `true`.
     */
    @JvmName("knkqjpekesbvdcuq")
    public suspend fun scanAll(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanAll = mapped
    }

    internal fun build(): CrawlerMongodbTargetArgs = CrawlerMongodbTargetArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        path = path ?: throw PulumiNullFieldException("path"),
        scanAll = scanAll,
    )
}
