@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.CrawlerSchemaChangePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteBehavior The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
 * @property updateBehavior The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
 */
public data class CrawlerSchemaChangePolicyArgs(
    public val deleteBehavior: Output<String>? = null,
    public val updateBehavior: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.CrawlerSchemaChangePolicyArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.CrawlerSchemaChangePolicyArgs =
        com.pulumi.aws.glue.inputs.CrawlerSchemaChangePolicyArgs.builder()
            .deleteBehavior(deleteBehavior?.applyValue({ args0 -> args0 }))
            .updateBehavior(updateBehavior?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CrawlerSchemaChangePolicyArgs].
 */
@PulumiTagMarker
public class CrawlerSchemaChangePolicyArgsBuilder internal constructor() {
    private var deleteBehavior: Output<String>? = null

    private var updateBehavior: Output<String>? = null

    /**
     * @param value The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
     */
    @JvmName("vjgxuspwsdyipthq")
    public suspend fun deleteBehavior(`value`: Output<String>) {
        this.deleteBehavior = value
    }

    /**
     * @param value The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
     */
    @JvmName("ywweulrwwfmmpnme")
    public suspend fun updateBehavior(`value`: Output<String>) {
        this.updateBehavior = value
    }

    /**
     * @param value The deletion behavior when the crawler finds a deleted object. Valid values: `LOG`, `DELETE_FROM_DATABASE`, or `DEPRECATE_IN_DATABASE`. Defaults to `DEPRECATE_IN_DATABASE`.
     */
    @JvmName("gwdsfnaqkpnjcmsh")
    public suspend fun deleteBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteBehavior = mapped
    }

    /**
     * @param value The update behavior when the crawler finds a changed schema. Valid values: `LOG` or `UPDATE_IN_DATABASE`. Defaults to `UPDATE_IN_DATABASE`.
     */
    @JvmName("kknceykkknmoruek")
    public suspend fun updateBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateBehavior = mapped
    }

    internal fun build(): CrawlerSchemaChangePolicyArgs = CrawlerSchemaChangePolicyArgs(
        deleteBehavior = deleteBehavior,
        updateBehavior = updateBehavior,
    )
}
