@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogEncryptionMode The encryption-at-rest mode for encrypting Data Catalog data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-KMS-WITH-SERVICE-ROLE`.
 * @property catalogEncryptionServiceRole The ARN of the AWS IAM role used for accessing encrypted Data Catalog data.
 * @property sseAwsKmsKeyId The ARN of the AWS KMS key to use for encryption at rest.
 */
public data class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs(
    public val catalogEncryptionMode: Output<String>,
    public val catalogEncryptionServiceRole: Output<String>? = null,
    public val sseAwsKmsKeyId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs =
        com.pulumi.aws.glue.inputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs.builder()
            .catalogEncryptionMode(catalogEncryptionMode.applyValue({ args0 -> args0 }))
            .catalogEncryptionServiceRole(catalogEncryptionServiceRole?.applyValue({ args0 -> args0 }))
            .sseAwsKmsKeyId(sseAwsKmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs].
 */
@PulumiTagMarker
public class DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgsBuilder
internal constructor() {
    private var catalogEncryptionMode: Output<String>? = null

    private var catalogEncryptionServiceRole: Output<String>? = null

    private var sseAwsKmsKeyId: Output<String>? = null

    /**
     * @param value The encryption-at-rest mode for encrypting Data Catalog data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-KMS-WITH-SERVICE-ROLE`.
     */
    @JvmName("ofkagsnxybohvahu")
    public suspend fun catalogEncryptionMode(`value`: Output<String>) {
        this.catalogEncryptionMode = value
    }

    /**
     * @param value The ARN of the AWS IAM role used for accessing encrypted Data Catalog data.
     */
    @JvmName("hyrsoclnowxhalas")
    public suspend fun catalogEncryptionServiceRole(`value`: Output<String>) {
        this.catalogEncryptionServiceRole = value
    }

    /**
     * @param value The ARN of the AWS KMS key to use for encryption at rest.
     */
    @JvmName("kuwngjxrwudqlkuq")
    public suspend fun sseAwsKmsKeyId(`value`: Output<String>) {
        this.sseAwsKmsKeyId = value
    }

    /**
     * @param value The encryption-at-rest mode for encrypting Data Catalog data. Valid values: `DISABLED`, `SSE-KMS`, `SSE-KMS-WITH-SERVICE-ROLE`.
     */
    @JvmName("grtsskrlsctgfruy")
    public suspend fun catalogEncryptionMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogEncryptionMode = mapped
    }

    /**
     * @param value The ARN of the AWS IAM role used for accessing encrypted Data Catalog data.
     */
    @JvmName("sprgfivlrpxdpdcc")
    public suspend fun catalogEncryptionServiceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogEncryptionServiceRole = mapped
    }

    /**
     * @param value The ARN of the AWS KMS key to use for encryption at rest.
     */
    @JvmName("kvfilwqoclrslfor")
    public suspend fun sseAwsKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseAwsKmsKeyId = mapped
    }

    internal fun build(): DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs =
        DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsEncryptionAtRestArgs(
            catalogEncryptionMode = catalogEncryptionMode ?: throw
                PulumiNullFieldException("catalogEncryptionMode"),
            catalogEncryptionServiceRole = catalogEncryptionServiceRole,
            sseAwsKmsKeyId = sseAwsKmsKeyId,
        )
}
