@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId The catalog id where the AWS Glue table exists.
 * @property databaseName Name of the database where the AWS Glue table exists.
 * @property tableName Name of the AWS Glue table.
 */
public data class DataQualityRulesetTargetTableArgs(
    public val catalogId: Output<String>? = null,
    public val databaseName: Output<String>,
    public val tableName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs =
        com.pulumi.aws.glue.inputs.DataQualityRulesetTargetTableArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityRulesetTargetTableArgs].
 */
@PulumiTagMarker
public class DataQualityRulesetTargetTableArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The catalog id where the AWS Glue table exists.
     */
    @JvmName("hrbeoxdbckedlmnd")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Name of the database where the AWS Glue table exists.
     */
    @JvmName("upsveowkeokluqrd")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Name of the AWS Glue table.
     */
    @JvmName("lqftdkdstqfocbki")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The catalog id where the AWS Glue table exists.
     */
    @JvmName("orpbvsjptmkwsvpb")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the database where the AWS Glue table exists.
     */
    @JvmName("kxhdsnfhqgqwcpud")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Name of the AWS Glue table.
     */
    @JvmName("cyyhydhihdiraygm")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): DataQualityRulesetTargetTableArgs = DataQualityRulesetTargetTableArgs(
        catalogId = catalogId,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
