@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.GetCatalogTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCatalogTable.
 * @property catalogId ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
 * @property databaseName Name of the metadata database where the table metadata resides.
 * @property name Name of the table.
 * @property queryAsOfTime The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `transaction_id`. Specified in RFC 3339 format, e.g. `2006-01-02T15:04:05Z07:00`.
 * @property transactionId The transaction ID at which to read the table contents.
 */
public data class GetCatalogTablePlainArgs(
    public val catalogId: String? = null,
    public val databaseName: String,
    public val name: String,
    public val queryAsOfTime: String? = null,
    public val transactionId: Int? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.GetCatalogTablePlainArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.GetCatalogTablePlainArgs =
        com.pulumi.aws.glue.inputs.GetCatalogTablePlainArgs.builder()
            .catalogId(catalogId?.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .queryAsOfTime(queryAsOfTime?.let({ args0 -> args0 }))
            .transactionId(transactionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCatalogTablePlainArgs].
 */
@PulumiTagMarker
public class GetCatalogTablePlainArgsBuilder internal constructor() {
    private var catalogId: String? = null

    private var databaseName: String? = null

    private var name: String? = null

    private var queryAsOfTime: String? = null

    private var transactionId: Int? = null

    /**
     * @param value ID of the Glue Catalog and database where the table metadata resides. If omitted, this defaults to the current AWS Account ID.
     */
    @JvmName("mmkoyvhapwphrycv")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the metadata database where the table metadata resides.
     */
    @JvmName("uxnnjpoacnxdnjaf")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value Name of the table.
     */
    @JvmName("ortqyxnlnklkquox")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with `transaction_id`. Specified in RFC 3339 format, e.g. `2006-01-02T15:04:05Z07:00`.
     */
    @JvmName("jqnexwjafsputwfs")
    public suspend fun queryAsOfTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryAsOfTime = mapped
    }

    /**
     * @param value The transaction ID at which to read the table contents.
     */
    @JvmName("culsmodqhcdyhkin")
    public suspend fun transactionId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transactionId = mapped
    }

    internal fun build(): GetCatalogTablePlainArgs = GetCatalogTablePlainArgs(
        catalogId = catalogId,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
        queryAsOfTime = queryAsOfTime,
        transactionId = transactionId,
    )
}
