@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.GetConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnection.
 * @property id Concatenation of the catalog ID and connection name. For example, if your account ID is
 * `123456789123` and the connection name is `conn` then the ID is `123456789123:conn`.
 * @property tags Tags assigned to the resource
 */
public data class GetConnectionPlainArgs(
    public val id: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.GetConnectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.GetConnectionPlainArgs =
        com.pulumi.aws.glue.inputs.GetConnectionPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Concatenation of the catalog ID and connection name. For example, if your account ID is
     * `123456789123` and the connection name is `conn` then the ID is `123456789123:conn`.
     */
    @JvmName("nrfxnteonkhnqvue")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Tags assigned to the resource
     */
    @JvmName("xxwbjjomcjrwqpjv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags assigned to the resource
     */
    @JvmName("aaqcsbwkcsficoqk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetConnectionPlainArgs = GetConnectionPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        tags = tags,
    )
}
