@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.GetScriptDagNodeArg.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the argument or property.
 * @property param Boolean if the value is used as a parameter. Defaults to `false`.
 * @property value Value of the argument or property.
 */
public data class GetScriptDagNodeArg(
    public val name: String,
    public val `param`: Boolean? = null,
    public val `value`: String,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.GetScriptDagNodeArg> {
    override fun toJava(): com.pulumi.aws.glue.inputs.GetScriptDagNodeArg =
        com.pulumi.aws.glue.inputs.GetScriptDagNodeArg.builder()
            .name(name.let({ args0 -> args0 }))
            .`param`(`param`?.let({ args0 -> args0 }))
            .`value`(`value`.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScriptDagNodeArg].
 */
@PulumiTagMarker
public class GetScriptDagNodeArgBuilder internal constructor() {
    private var name: String? = null

    private var `param`: Boolean? = null

    private var `value`: String? = null

    /**
     * @param value Name of the argument or property.
     */
    @JvmName("tfmvwjkpdedgaxma")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Boolean if the value is used as a parameter. Defaults to `false`.
     */
    @JvmName("yqjsdheuwpghuexy")
    public suspend fun `param`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`param` = mapped
    }

    /**
     * @param value Value of the argument or property.
     */
    @JvmName("rgkhvauwgmxvvnxg")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.`value` = mapped
    }

    internal fun build(): GetScriptDagNodeArg = GetScriptDagNodeArg(
        name = name ?: throw PulumiNullFieldException("name"),
        `param` = `param`,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
