@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.JobExecutionPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxConcurrentRuns The maximum number of concurrent runs allowed for a job. The default is 1.
 */
public data class JobExecutionPropertyArgs(
    public val maxConcurrentRuns: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.JobExecutionPropertyArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.JobExecutionPropertyArgs =
        com.pulumi.aws.glue.inputs.JobExecutionPropertyArgs.builder()
            .maxConcurrentRuns(maxConcurrentRuns?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobExecutionPropertyArgs].
 */
@PulumiTagMarker
public class JobExecutionPropertyArgsBuilder internal constructor() {
    private var maxConcurrentRuns: Output<Int>? = null

    /**
     * @param value The maximum number of concurrent runs allowed for a job. The default is 1.
     */
    @JvmName("pjggygjslgxkbumt")
    public suspend fun maxConcurrentRuns(`value`: Output<Int>) {
        this.maxConcurrentRuns = value
    }

    /**
     * @param value The maximum number of concurrent runs allowed for a job. The default is 1.
     */
    @JvmName("hauiwhqfcununlep")
    public suspend fun maxConcurrentRuns(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentRuns = mapped
    }

    internal fun build(): JobExecutionPropertyArgs = JobExecutionPropertyArgs(
        maxConcurrentRuns = maxConcurrentRuns,
    )
}
