@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.MLTransformParametersFindMatchesParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accuracyCostTradeOff The value that is selected when tuning your transform for a balance between accuracy and cost.
 * @property enforceProvidedLabels The value to switch on or off to force the output to match the provided labels from users.
 * @property precisionRecallTradeOff The value selected when tuning your transform for a balance between precision and recall.
 * @property primaryKeyColumnName The name of a column that uniquely identifies rows in the source table.
 */
public data class MLTransformParametersFindMatchesParametersArgs(
    public val accuracyCostTradeOff: Output<Double>? = null,
    public val enforceProvidedLabels: Output<Boolean>? = null,
    public val precisionRecallTradeOff: Output<Double>? = null,
    public val primaryKeyColumnName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.MLTransformParametersFindMatchesParametersArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.MLTransformParametersFindMatchesParametersArgs =
        com.pulumi.aws.glue.inputs.MLTransformParametersFindMatchesParametersArgs.builder()
            .accuracyCostTradeOff(accuracyCostTradeOff?.applyValue({ args0 -> args0 }))
            .enforceProvidedLabels(enforceProvidedLabels?.applyValue({ args0 -> args0 }))
            .precisionRecallTradeOff(precisionRecallTradeOff?.applyValue({ args0 -> args0 }))
            .primaryKeyColumnName(primaryKeyColumnName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MLTransformParametersFindMatchesParametersArgs].
 */
@PulumiTagMarker
public class MLTransformParametersFindMatchesParametersArgsBuilder internal constructor() {
    private var accuracyCostTradeOff: Output<Double>? = null

    private var enforceProvidedLabels: Output<Boolean>? = null

    private var precisionRecallTradeOff: Output<Double>? = null

    private var primaryKeyColumnName: Output<String>? = null

    /**
     * @param value The value that is selected when tuning your transform for a balance between accuracy and cost.
     */
    @JvmName("wpradjctusniewsx")
    public suspend fun accuracyCostTradeOff(`value`: Output<Double>) {
        this.accuracyCostTradeOff = value
    }

    /**
     * @param value The value to switch on or off to force the output to match the provided labels from users.
     */
    @JvmName("nkcpejagqdxyghso")
    public suspend fun enforceProvidedLabels(`value`: Output<Boolean>) {
        this.enforceProvidedLabels = value
    }

    /**
     * @param value The value selected when tuning your transform for a balance between precision and recall.
     */
    @JvmName("xfwaacbfojqbwwtj")
    public suspend fun precisionRecallTradeOff(`value`: Output<Double>) {
        this.precisionRecallTradeOff = value
    }

    /**
     * @param value The name of a column that uniquely identifies rows in the source table.
     */
    @JvmName("pkgckuygkhbjduvl")
    public suspend fun primaryKeyColumnName(`value`: Output<String>) {
        this.primaryKeyColumnName = value
    }

    /**
     * @param value The value that is selected when tuning your transform for a balance between accuracy and cost.
     */
    @JvmName("hpqhudywmqoleibm")
    public suspend fun accuracyCostTradeOff(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accuracyCostTradeOff = mapped
    }

    /**
     * @param value The value to switch on or off to force the output to match the provided labels from users.
     */
    @JvmName("cqlhmefuhjdesjri")
    public suspend fun enforceProvidedLabels(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceProvidedLabels = mapped
    }

    /**
     * @param value The value selected when tuning your transform for a balance between precision and recall.
     */
    @JvmName("nfhqtcfmaeyqqhyn")
    public suspend fun precisionRecallTradeOff(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.precisionRecallTradeOff = mapped
    }

    /**
     * @param value The name of a column that uniquely identifies rows in the source table.
     */
    @JvmName("ihqyyofdiminmjse")
    public suspend fun primaryKeyColumnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKeyColumnName = mapped
    }

    internal fun build(): MLTransformParametersFindMatchesParametersArgs =
        MLTransformParametersFindMatchesParametersArgs(
            accuracyCostTradeOff = accuracyCostTradeOff,
            enforceProvidedLabels = enforceProvidedLabels,
            precisionRecallTradeOff = precisionRecallTradeOff,
            primaryKeyColumnName = primaryKeyColumnName,
        )
}
