@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property bucketColumns A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
 * @property columns A list of the Columns in the table.
 * @property compressed True if the data in the table is compressed, or False if not.
 * @property inputFormat The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
 * @property location The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
 * @property numberOfBuckets Must be specified if the table contains any dimension columns.
 * @property outputFormat The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
 * @property parameters User-supplied properties in key-value form.
 * @property serDeInfo Serialization/deserialization (SerDe) information.
 * @property skewedInfo Information about values that appear very frequently in a column (skewed values).
 * @property sortColumns A list of Order objects specifying the sort order of each bucket in the table.
 * @property storedAsSubDirectories True if the table data is stored in subdirectories, or False if not.
 */
public data class PartitionStorageDescriptorArgs(
    public val bucketColumns: Output<List<String>>? = null,
    public val columns: Output<List<PartitionStorageDescriptorColumnArgs>>? = null,
    public val compressed: Output<Boolean>? = null,
    public val inputFormat: Output<String>? = null,
    public val location: Output<String>? = null,
    public val numberOfBuckets: Output<Int>? = null,
    public val outputFormat: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val serDeInfo: Output<PartitionStorageDescriptorSerDeInfoArgs>? = null,
    public val skewedInfo: Output<PartitionStorageDescriptorSkewedInfoArgs>? = null,
    public val sortColumns: Output<List<PartitionStorageDescriptorSortColumnArgs>>? = null,
    public val storedAsSubDirectories: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.PartitionStorageDescriptorArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.PartitionStorageDescriptorArgs =
        com.pulumi.aws.glue.inputs.PartitionStorageDescriptorArgs.builder()
            .bucketColumns(bucketColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .compressed(compressed?.applyValue({ args0 -> args0 }))
            .inputFormat(inputFormat?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .numberOfBuckets(numberOfBuckets?.applyValue({ args0 -> args0 }))
            .outputFormat(outputFormat?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .serDeInfo(serDeInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .skewedInfo(skewedInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sortColumns(
                sortColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storedAsSubDirectories(storedAsSubDirectories?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartitionStorageDescriptorArgs].
 */
@PulumiTagMarker
public class PartitionStorageDescriptorArgsBuilder internal constructor() {
    private var bucketColumns: Output<List<String>>? = null

    private var columns: Output<List<PartitionStorageDescriptorColumnArgs>>? = null

    private var compressed: Output<Boolean>? = null

    private var inputFormat: Output<String>? = null

    private var location: Output<String>? = null

    private var numberOfBuckets: Output<Int>? = null

    private var outputFormat: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var serDeInfo: Output<PartitionStorageDescriptorSerDeInfoArgs>? = null

    private var skewedInfo: Output<PartitionStorageDescriptorSkewedInfoArgs>? = null

    private var sortColumns: Output<List<PartitionStorageDescriptorSortColumnArgs>>? = null

    private var storedAsSubDirectories: Output<Boolean>? = null

    /**
     * @param value A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("okiydskxlxyrjvrf")
    public suspend fun bucketColumns(`value`: Output<List<String>>) {
        this.bucketColumns = value
    }

    @JvmName("kjycfkhlbssilvtv")
    public suspend fun bucketColumns(vararg values: Output<String>) {
        this.bucketColumns = Output.all(values.asList())
    }

    /**
     * @param values A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("nkiccsgkmgqxhqys")
    public suspend fun bucketColumns(values: List<Output<String>>) {
        this.bucketColumns = Output.all(values)
    }

    /**
     * @param value A list of the Columns in the table.
     */
    @JvmName("yrhionwutldfbmtp")
    public suspend fun columns(`value`: Output<List<PartitionStorageDescriptorColumnArgs>>) {
        this.columns = value
    }

    @JvmName("hycepxvrwjfwmnfv")
    public suspend fun columns(vararg values: Output<PartitionStorageDescriptorColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values A list of the Columns in the table.
     */
    @JvmName("jbttuywlmqcgpipg")
    public suspend fun columns(values: List<Output<PartitionStorageDescriptorColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value True if the data in the table is compressed, or False if not.
     */
    @JvmName("scfxiltctylbdcyl")
    public suspend fun compressed(`value`: Output<Boolean>) {
        this.compressed = value
    }

    /**
     * @param value The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
     */
    @JvmName("uvixmxwmsoesopel")
    public suspend fun inputFormat(`value`: Output<String>) {
        this.inputFormat = value
    }

    /**
     * @param value The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
     */
    @JvmName("krxxtlvcxbnhpuuu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Must be specified if the table contains any dimension columns.
     */
    @JvmName("pkplsjsthjighdrf")
    public suspend fun numberOfBuckets(`value`: Output<Int>) {
        this.numberOfBuckets = value
    }

    /**
     * @param value The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
     */
    @JvmName("ejlejlvawdibcqfg")
    public suspend fun outputFormat(`value`: Output<String>) {
        this.outputFormat = value
    }

    /**
     * @param value User-supplied properties in key-value form.
     */
    @JvmName("kgwexurcnurqmyut")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Serialization/deserialization (SerDe) information.
     */
    @JvmName("qaxqyskldhnkyeyg")
    public suspend fun serDeInfo(`value`: Output<PartitionStorageDescriptorSerDeInfoArgs>) {
        this.serDeInfo = value
    }

    /**
     * @param value Information about values that appear very frequently in a column (skewed values).
     */
    @JvmName("kouectknqeckonhf")
    public suspend fun skewedInfo(`value`: Output<PartitionStorageDescriptorSkewedInfoArgs>) {
        this.skewedInfo = value
    }

    /**
     * @param value A list of Order objects specifying the sort order of each bucket in the table.
     */
    @JvmName("ytsuoymyvxxxwvti")
    public suspend fun sortColumns(`value`: Output<List<PartitionStorageDescriptorSortColumnArgs>>) {
        this.sortColumns = value
    }

    @JvmName("fpcwtboikoautbec")
    public suspend fun sortColumns(vararg values: Output<PartitionStorageDescriptorSortColumnArgs>) {
        this.sortColumns = Output.all(values.asList())
    }

    /**
     * @param values A list of Order objects specifying the sort order of each bucket in the table.
     */
    @JvmName("bkqriexdkbdqxqjs")
    public suspend fun sortColumns(values: List<Output<PartitionStorageDescriptorSortColumnArgs>>) {
        this.sortColumns = Output.all(values)
    }

    /**
     * @param value True if the table data is stored in subdirectories, or False if not.
     */
    @JvmName("bbxnsikmvfnylgcp")
    public suspend fun storedAsSubDirectories(`value`: Output<Boolean>) {
        this.storedAsSubDirectories = value
    }

    /**
     * @param value A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("viwekkyupyqdgubj")
    public suspend fun bucketColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketColumns = mapped
    }

    /**
     * @param values A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
     */
    @JvmName("airmvvpkufxgtjuj")
    public suspend fun bucketColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketColumns = mapped
    }

    /**
     * @param value A list of the Columns in the table.
     */
    @JvmName("khuyecluerkeqbtg")
    public suspend fun columns(`value`: List<PartitionStorageDescriptorColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument A list of the Columns in the table.
     */
    @JvmName("usiwqbkyjlwftafa")
    public suspend fun columns(argument: List<suspend PartitionStorageDescriptorColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PartitionStorageDescriptorColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument A list of the Columns in the table.
     */
    @JvmName("hegmgglxyasjsdyn")
    public suspend fun columns(vararg argument: suspend PartitionStorageDescriptorColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PartitionStorageDescriptorColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument A list of the Columns in the table.
     */
    @JvmName("edlxfgeqwaucmtyt")
    public suspend fun columns(argument: suspend PartitionStorageDescriptorColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PartitionStorageDescriptorColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values A list of the Columns in the table.
     */
    @JvmName("tjaafxxlblrktigp")
    public suspend fun columns(vararg values: PartitionStorageDescriptorColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value True if the data in the table is compressed, or False if not.
     */
    @JvmName("dphmrgglixdqxwud")
    public suspend fun compressed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressed = mapped
    }

    /**
     * @param value The input format: SequenceFileInputFormat (binary), or TextInputFormat, or a custom format.
     */
    @JvmName("sswtljqhqscqwwkx")
    public suspend fun inputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputFormat = mapped
    }

    /**
     * @param value The physical location of the table. By default this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
     */
    @JvmName("gyivoxrpcntsrxka")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Must be specified if the table contains any dimension columns.
     */
    @JvmName("jmjlumwcwemphalx")
    public suspend fun numberOfBuckets(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfBuckets = mapped
    }

    /**
     * @param value The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat, or a custom format.
     */
    @JvmName("wdyukrwdmcjuytkx")
    public suspend fun outputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputFormat = mapped
    }

    /**
     * @param value User-supplied properties in key-value form.
     */
    @JvmName("ltdjfgadvlcluyua")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values User-supplied properties in key-value form.
     */
    @JvmName("ytvpsbcewbdlmuny")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Serialization/deserialization (SerDe) information.
     */
    @JvmName("swvxnxoxxuvyxdre")
    public suspend fun serDeInfo(`value`: PartitionStorageDescriptorSerDeInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serDeInfo = mapped
    }

    /**
     * @param argument Serialization/deserialization (SerDe) information.
     */
    @JvmName("oxxbclfgluacypmk")
    public suspend fun serDeInfo(argument: suspend PartitionStorageDescriptorSerDeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PartitionStorageDescriptorSerDeInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serDeInfo = mapped
    }

    /**
     * @param value Information about values that appear very frequently in a column (skewed values).
     */
    @JvmName("yxchyyhpgwfmdwhf")
    public suspend fun skewedInfo(`value`: PartitionStorageDescriptorSkewedInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skewedInfo = mapped
    }

    /**
     * @param argument Information about values that appear very frequently in a column (skewed values).
     */
    @JvmName("xrrkopgadtwqwhgu")
    public suspend fun skewedInfo(argument: suspend PartitionStorageDescriptorSkewedInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PartitionStorageDescriptorSkewedInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.skewedInfo = mapped
    }

    /**
     * @param value A list of Order objects specifying the sort order of each bucket in the table.
     */
    @JvmName("sympcvgbkwkmdoal")
    public suspend fun sortColumns(`value`: List<PartitionStorageDescriptorSortColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sortColumns = mapped
    }

    /**
     * @param argument A list of Order objects specifying the sort order of each bucket in the table.
     */
    @JvmName("eolemsiomddnsxev")
    public suspend fun sortColumns(argument: List<suspend PartitionStorageDescriptorSortColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PartitionStorageDescriptorSortColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sortColumns = mapped
    }

    /**
     * @param argument A list of Order objects specifying the sort order of each bucket in the table.
     */
    @JvmName("bkgmhswqmgubbapx")
    public suspend fun sortColumns(vararg argument: suspend PartitionStorageDescriptorSortColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PartitionStorageDescriptorSortColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sortColumns = mapped
    }

    /**
     * @param argument A list of Order objects specifying the sort order of each bucket in the table.
     */
    @JvmName("klxrjppdlbgqmnjv")
    public suspend fun sortColumns(argument: suspend PartitionStorageDescriptorSortColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PartitionStorageDescriptorSortColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sortColumns = mapped
    }

    /**
     * @param values A list of Order objects specifying the sort order of each bucket in the table.
     */
    @JvmName("mpprhqtvvrnqhrpu")
    public suspend fun sortColumns(vararg values: PartitionStorageDescriptorSortColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sortColumns = mapped
    }

    /**
     * @param value True if the table data is stored in subdirectories, or False if not.
     */
    @JvmName("nltbodyfjxfqejud")
    public suspend fun storedAsSubDirectories(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storedAsSubDirectories = mapped
    }

    internal fun build(): PartitionStorageDescriptorArgs = PartitionStorageDescriptorArgs(
        bucketColumns = bucketColumns,
        columns = columns,
        compressed = compressed,
        inputFormat = inputFormat,
        location = location,
        numberOfBuckets = numberOfBuckets,
        outputFormat = outputFormat,
        parameters = parameters,
        serDeInfo = serDeInfo,
        skewedInfo = skewedInfo,
        sortColumns = sortColumns,
        storedAsSubDirectories = storedAsSubDirectories,
    )
}
