@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.PartitionStorageDescriptorColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comment Free-form text comment.
 * @property name
 * @property type The datatype of data in the Column.
 */
public data class PartitionStorageDescriptorColumnArgs(
    public val comment: Output<String>? = null,
    public val name: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.PartitionStorageDescriptorColumnArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.PartitionStorageDescriptorColumnArgs =
        com.pulumi.aws.glue.inputs.PartitionStorageDescriptorColumnArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartitionStorageDescriptorColumnArgs].
 */
@PulumiTagMarker
public class PartitionStorageDescriptorColumnArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Free-form text comment.
     */
    @JvmName("dscferjukwyktqkk")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value
     */
    @JvmName("xvsxuudwbvxjfxuo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The datatype of data in the Column.
     */
    @JvmName("dtvqbynonajctekm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Free-form text comment.
     */
    @JvmName("plmjrccsjeskdjha")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value
     */
    @JvmName("uabruabfgtogeltj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The datatype of data in the Column.
     */
    @JvmName("ojxjayujecnkyntg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PartitionStorageDescriptorColumnArgs = PartitionStorageDescriptorColumnArgs(
        comment = comment,
        name = name ?: throw PulumiNullFieldException("name"),
        type = type,
    )
}
