@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchEncryptionMode Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 */
public data class SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs(
    public val cloudwatchEncryptionMode: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs =
        com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs.builder()
            .cloudwatchEncryptionMode(cloudwatchEncryptionMode?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs].
 */
@PulumiTagMarker
public class SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgsBuilder internal constructor() {
    private var cloudwatchEncryptionMode: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
     */
    @JvmName("avgwbedqiewdxxxs")
    public suspend fun cloudwatchEncryptionMode(`value`: Output<String>) {
        this.cloudwatchEncryptionMode = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    @JvmName("urkhyuumuogsxekw")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Encryption mode to use for CloudWatch data. Valid values: `DISABLED`, `SSE-KMS`. Default value: `DISABLED`.
     */
    @JvmName("mmtbdwxtytrchkoa")
    public suspend fun cloudwatchEncryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchEncryptionMode = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    @JvmName("xuhksbystojnijld")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs =
        SecurityConfigurationEncryptionConfigurationCloudwatchEncryptionArgs(
            cloudwatchEncryptionMode = cloudwatchEncryptionMode,
            kmsKeyArn = kmsKeyArn,
        )
}
