@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobBookmarksEncryptionMode Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
 * @property kmsKeyArn Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
 */
public data class SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs(
    public val jobBookmarksEncryptionMode: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs =
        com.pulumi.aws.glue.inputs.SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs.builder()
            .jobBookmarksEncryptionMode(jobBookmarksEncryptionMode?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs].
 */
@PulumiTagMarker
public class SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgsBuilder internal constructor() {
    private var jobBookmarksEncryptionMode: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
     */
    @JvmName("cdbwgxkrhwsaysmb")
    public suspend fun jobBookmarksEncryptionMode(`value`: Output<String>) {
        this.jobBookmarksEncryptionMode = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    @JvmName("qppwhvugoosfquwl")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Encryption mode to use for job bookmarks data. Valid values: `CSE-KMS`, `DISABLED`. Default value: `DISABLED`.
     */
    @JvmName("wqefwtvjugdfbike")
    public suspend fun jobBookmarksEncryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobBookmarksEncryptionMode = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
     */
    @JvmName("atawuofcaoribcmb")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs =
        SecurityConfigurationEncryptionConfigurationJobBookmarksEncryptionArgs(
            jobBookmarksEncryptionMode = jobBookmarksEncryptionMode,
            kmsKeyArn = kmsKeyArn,
        )
}
