@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.TriggerActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property arguments Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
 * @property crawlerName The name of the crawler to be executed. Conflicts with `job_name`.
 * @property jobName The name of a job to be executed. Conflicts with `crawler_name`.
 * @property notificationProperty Specifies configuration properties of a job run notification. See Notification Property details below.
 * @property securityConfiguration The name of the Security Configuration structure to be used with this action.
 * @property timeout The job run timeout in minutes. It overrides the timeout value of the job.
 */
public data class TriggerActionArgs(
    public val arguments: Output<Map<String, String>>? = null,
    public val crawlerName: Output<String>? = null,
    public val jobName: Output<String>? = null,
    public val notificationProperty: Output<TriggerActionNotificationPropertyArgs>? = null,
    public val securityConfiguration: Output<String>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.TriggerActionArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.TriggerActionArgs =
        com.pulumi.aws.glue.inputs.TriggerActionArgs.builder()
            .arguments(
                arguments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .crawlerName(crawlerName?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .notificationProperty(
                notificationProperty?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityConfiguration(securityConfiguration?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerActionArgs].
 */
@PulumiTagMarker
public class TriggerActionArgsBuilder internal constructor() {
    private var arguments: Output<Map<String, String>>? = null

    private var crawlerName: Output<String>? = null

    private var jobName: Output<String>? = null

    private var notificationProperty: Output<TriggerActionNotificationPropertyArgs>? = null

    private var securityConfiguration: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
     */
    @JvmName("mijxlyqsaldmywqo")
    public suspend fun arguments(`value`: Output<Map<String, String>>) {
        this.arguments = value
    }

    /**
     * @param value The name of the crawler to be executed. Conflicts with `job_name`.
     */
    @JvmName("dgkctisrkwqxclyy")
    public suspend fun crawlerName(`value`: Output<String>) {
        this.crawlerName = value
    }

    /**
     * @param value The name of a job to be executed. Conflicts with `crawler_name`.
     */
    @JvmName("ndbhgwcpoowcixvr")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Specifies configuration properties of a job run notification. See Notification Property details below.
     */
    @JvmName("mrnktvmaghrunodd")
    public suspend fun notificationProperty(`value`: Output<TriggerActionNotificationPropertyArgs>) {
        this.notificationProperty = value
    }

    /**
     * @param value The name of the Security Configuration structure to be used with this action.
     */
    @JvmName("xenpbsgranwgsmet")
    public suspend fun securityConfiguration(`value`: Output<String>) {
        this.securityConfiguration = value
    }

    /**
     * @param value The job run timeout in minutes. It overrides the timeout value of the job.
     */
    @JvmName("tbcfahulpqjvhdak")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
     */
    @JvmName("oxvlvyfqdlqdkvtp")
    public suspend fun arguments(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param values Arguments to be passed to the job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.
     */
    @JvmName("risiaxdjtimjmlbi")
    public fun arguments(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value The name of the crawler to be executed. Conflicts with `job_name`.
     */
    @JvmName("xkmlkvttyblgbauv")
    public suspend fun crawlerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crawlerName = mapped
    }

    /**
     * @param value The name of a job to be executed. Conflicts with `crawler_name`.
     */
    @JvmName("yehgaspscifnxigl")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Specifies configuration properties of a job run notification. See Notification Property details below.
     */
    @JvmName("aqigwgoqlnrirucr")
    public suspend fun notificationProperty(`value`: TriggerActionNotificationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationProperty = mapped
    }

    /**
     * @param argument Specifies configuration properties of a job run notification. See Notification Property details below.
     */
    @JvmName("qfitrxputdydofdj")
    public suspend fun notificationProperty(argument: suspend TriggerActionNotificationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerActionNotificationPropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.notificationProperty = mapped
    }

    /**
     * @param value The name of the Security Configuration structure to be used with this action.
     */
    @JvmName("dxpjfshwtmebfqka")
    public suspend fun securityConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityConfiguration = mapped
    }

    /**
     * @param value The job run timeout in minutes. It overrides the timeout value of the job.
     */
    @JvmName("hxarhrgrcmouvkjl")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): TriggerActionArgs = TriggerActionArgs(
        arguments = arguments,
        crawlerName = crawlerName,
        jobName = jobName,
        notificationProperty = notificationProperty,
        securityConfiguration = securityConfiguration,
        timeout = timeout,
    )
}
