@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.TriggerEventBatchingConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchSize Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
 * @property batchWindow Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
 */
public data class TriggerEventBatchingConditionArgs(
    public val batchSize: Output<Int>,
    public val batchWindow: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.TriggerEventBatchingConditionArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.TriggerEventBatchingConditionArgs =
        com.pulumi.aws.glue.inputs.TriggerEventBatchingConditionArgs.builder()
            .batchSize(batchSize.applyValue({ args0 -> args0 }))
            .batchWindow(batchWindow?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerEventBatchingConditionArgs].
 */
@PulumiTagMarker
public class TriggerEventBatchingConditionArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var batchWindow: Output<Int>? = null

    /**
     * @param value Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
     */
    @JvmName("gryevoxfnauhehyd")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
     */
    @JvmName("hfrxjbrkfgutskac")
    public suspend fun batchWindow(`value`: Output<Int>) {
        this.batchWindow = value
    }

    /**
     * @param value Number of events that must be received from Amazon EventBridge before EventBridge  event trigger fires.
     */
    @JvmName("ylehvptvsyncfeue")
    public suspend fun batchSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received. Default value is `900`.
     */
    @JvmName("ohfierhhvkhbuviq")
    public suspend fun batchWindow(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchWindow = mapped
    }

    internal fun build(): TriggerEventBatchingConditionArgs = TriggerEventBatchingConditionArgs(
        batchSize = batchSize ?: throw PulumiNullFieldException("batchSize"),
        batchWindow = batchWindow,
    )
}
