@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.glue.kotlin.inputs

import com.pulumi.aws.glue.inputs.TriggerPredicateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property conditions A list of the conditions that determine when the trigger will fire. See Conditions.
 * @property logical How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
 */
public data class TriggerPredicateArgs(
    public val conditions: Output<List<TriggerPredicateConditionArgs>>,
    public val logical: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.glue.inputs.TriggerPredicateArgs> {
    override fun toJava(): com.pulumi.aws.glue.inputs.TriggerPredicateArgs =
        com.pulumi.aws.glue.inputs.TriggerPredicateArgs.builder()
            .conditions(
                conditions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .logical(logical?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerPredicateArgs].
 */
@PulumiTagMarker
public class TriggerPredicateArgsBuilder internal constructor() {
    private var conditions: Output<List<TriggerPredicateConditionArgs>>? = null

    private var logical: Output<String>? = null

    /**
     * @param value A list of the conditions that determine when the trigger will fire. See Conditions.
     */
    @JvmName("fmrqyudvodhfpyil")
    public suspend fun conditions(`value`: Output<List<TriggerPredicateConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("yrnqvgeaykopvrff")
    public suspend fun conditions(vararg values: Output<TriggerPredicateConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values A list of the conditions that determine when the trigger will fire. See Conditions.
     */
    @JvmName("giopivinupnllfrv")
    public suspend fun conditions(values: List<Output<TriggerPredicateConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
     */
    @JvmName("rpwjjttlbaerwcra")
    public suspend fun logical(`value`: Output<String>) {
        this.logical = value
    }

    /**
     * @param value A list of the conditions that determine when the trigger will fire. See Conditions.
     */
    @JvmName("iutjjeyulissexir")
    public suspend fun conditions(`value`: List<TriggerPredicateConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument A list of the conditions that determine when the trigger will fire. See Conditions.
     */
    @JvmName("rmytkrhvqmobdklw")
    public suspend fun conditions(argument: List<suspend TriggerPredicateConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TriggerPredicateConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument A list of the conditions that determine when the trigger will fire. See Conditions.
     */
    @JvmName("vdcsyhwwpwjglvea")
    public suspend fun conditions(vararg argument: suspend TriggerPredicateConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TriggerPredicateConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument A list of the conditions that determine when the trigger will fire. See Conditions.
     */
    @JvmName("mqlrkvfawnmisxnq")
    public suspend fun conditions(argument: suspend TriggerPredicateConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TriggerPredicateConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values A list of the conditions that determine when the trigger will fire. See Conditions.
     */
    @JvmName("akremaqphbmyfsvu")
    public suspend fun conditions(vararg values: TriggerPredicateConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value How to handle multiple conditions. Defaults to `AND`. Valid values are `AND` or `ANY`.
     */
    @JvmName("vouadlncuwgqehwk")
    public suspend fun logical(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logical = mapped
    }

    internal fun build(): TriggerPredicateArgs = TriggerPredicateArgs(
        conditions = conditions ?: throw PulumiNullFieldException("conditions"),
        logical = logical,
    )
}
